<?php

class Zsam_View_Helper_Folhaaprovar extends Zend_View_Helper_FormElement {

    var $cript;

    public function __construct(){
        $this->cript = new Zsam_Crypt_Cisweb();
    }

    public function Folhaaprovar($name, $value = null, $attribs = null)
    {
		
    	$references 	= new Cisweb_Db_References();
    	$table_func		= new Cisweb_Db_Abstract('func');
    	
    	$controller 		= Zend_Controller_Front::getInstance()->getRequest();
    	$banco				= $controller->getParam('id');
    	$tipo				= $attribs['tipo'];
    	
    	
    	$dados_folha  = $this->getFolha($tipo);
    	
    	$auth = Zend_Auth::getInstance();
    	if ($auth->hasIdentity()) {
    		$user = $auth->getStorage()->read();
    		$level  = @$user['NIVEL'];
    	}
    	
    	$total = 0;
    	foreach($dados_folha as $k => $v){
    		
    		$total += $v['VALORPAGTO'];
    	}
    	
    	$total = number_format($total,2,'.',',');
    	
    	$element			= "";
    	
    	if($level >= 3 && $tipo == 'aprovar'){
    		$element .= "<input type='button' value='Aprovar' id='btn_aprovar_folha' style='width:90px;'/>";
    	}
    	
    	if($level >= 3 && $tipo == 'gerar'){
    		$element .= "<input type='button' value='Gerar' id='btn_gerar_folha' style='width:90px;'/>";
    	}

		$element .= "<br/>";
		$element .= "<br/>";
		
		if($tipo == 'aprovar'){
			$element .= "<input type='checkbox' style='width: 17px;'  name='aprovacao_folha_todos' value='master_aprovacao'>";
			$element .= "<lable><b>Marcar todos</b></label>";
		}
    		
    	$element .= "<span style='float: right;' id='total_aprovacoes'> Total <b> R$ $total </b></span>";
    		
    	$element .= "<br/>";
    	$element .= "<br/>";
    		
    	$element .= "<div id='div_aprovacao_folha' style='padding=0'>";

    	foreach ($dados_folha as $k => $v){
    		
    		$func 			= $references->ReferenceFuncNoObj($v['FUNCIONARIO'], $table_func);
    		$func			= utf8_encode($func);
    		
    		$value 			= $v['ANO'].":".$v['MES'].":".$v['FUNCIONARIO'].":".$v['PAGTO_ADIANTAMENTO'];
    		$label 			= "Período: <b><span style='color: black;'>".$v['MES']."/".$v['ANO']."</span></b>";
    		$label 		   .= " | Funcionário: <b><span style='color: black;'>".$v['FUNCIONARIO']."-".substr($func,0,20)."</span></b>";
    		$label 		   .= " | Pagto: <b><span style='color: black;'>".number_format($v['VALORPAGTO'],2,'.',',')."</span></b>";
    		if($v['ULTIMO_PAGTO20']) $label .= " | Último Adiantamento: <b><span style='color: black;'>".number_format($v['ULTIMO_PAGTO20'],2,'.',',')."</span></b>";
            $label         .= " | Último Pagamento: <b><span style='color: black;'>".number_format($v['ULTIMO_PAGTO05'],2,'.',',')."</span></b>";
    		//$label 		   .= " | FGTS: <b>".	number_format($v['VALORFGTS'],2,'.',',')."</b>";
    		//$label 		   .= " | INSS <b>".	number_format($v['VALORINSS'],2,'.',',')."</b>";
    		//$label 		   .= " | IRRF <b>".	number_format($v['VALORIRRF'],2,'.',',')."</b>";
    		
    		if($tipo == 'aprovar'){
    			$element .=  "<input type='checkbox'  name='aprovarfolha' style='width:16px; border: 1 px #333;' value='$value' /> <label style='border-bottom: 1px gray solid; color: #666; width: 820px !important; display: block; float: right;'>$label</label><br/><br/>";
    		}else{
    			$element .= "<label style='border-bottom: 1px gray solid; color: #666; width: 820px !important; display: block; float: right;'>$label</label><br/><br/>"; 
    		}
    		
    	}
    	
    	
    	$element .= "</div>";
    		
    	$element .= "<br/>";
    		
    	if($level >= 3 && $tipo == 'aprovar'){
    		$element .= "<input type='button' value='Aprovar' id='btn_aprovar_folha' style='width:90px;'/>";
    	}
    	
        return $element;
    }
    
    public function getFolha($tipo){
    	
    	$table_folha 	= new Cisweb_Db_Abstract('folha');
    	
    	if($tipo == 'gerar'){
    		$dados_folha 	= $table_folha->select()->where("APROVAR_PAGTO IS NOT NULL AND IMPRESSAO_PAGTO IS NULL");
    	}
    	
    	if($tipo == 'aprovar'){
    		$dados_folha 	= $table_folha->select()->where("APROVAR_PAGTO IS NULL");
    	}
    	
    	$dados_folha 	= $table_folha->fetchAll($dados_folha)->toArray();

    	
    	return $dados_folha;
    	
    	
    }

}
