<?php

class Zsam_Validate_ProducaoDia extends Zend_Validate_Abstract {
    const PERMICAO = 'permissionDenied';

    /**
     * @var array
     */
    protected $_messageTemplates = array(
        self::PERMICAO => "Você não tem permissão para executar esta modificação.",
    );
    protected $_opts;

    public function __construct($options = array()) {
        $this->_opts = $options;
    }

    public function isValid($value, $context = null) {
        if ($_SESSION['Zend_Auth']['storage']['NIVEL'] <= 3) {
            $tabuser = new core_Model_DbTable_Produto();
            $dbAdapter = $tabuser->getAdapter();
            $select = $dbAdapter->select();
            $select->from('produtos','PRODUCAO_DIA')
                    ->where("CODIGO = ?", $context['CODIGO']);
            $consulta = $dbAdapter->fetchAll($select);
            if (empty ($consulta))
                return true;
            $produ = $consulta[0]['PRODUCAO_DIA'];
            
            if ($value < $produ) {
                $this->_error(self::PERMICAO);
                //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
                return false;
            }
        }
        return true;
    }

}
