<?php
/**
 * Classe de cration des ACL via un fichier de configuration INI
**/

class Zsam_Acl_Ini extends Zend_Acl	{
	
	const ROLE_FILE      =      '/configs/roles.ini';
	const PRIVILEGE_FILE = '/configs/privileges.ini';
	const RESOURCE_FILE  =  '/configs/resources.ini';
	
	public function __construct()	{

	}
	public function readRoles(){
		try {
		  $config = new Zend_Config_Ini(APPLICATION_PATH.Zsam_Acl_Ini::ROLE_FILE, 'roles') ;
	    } catch (Exception $e) {
	      $config = new Zend_Config(array());
		}
	    return $config;
	}
	public function readResources(){
		try {
		  $config = new Zend_Config_Ini(APPLICATION_PATH.Zsam_Acl_Ini::RESOURCE_FILE, 'resources') ;	 
		} catch (Exception $e) {
	      $config = new Zend_Config(array());
		}
	    return $config;
	}	
	public function readPrivileges($role=null){
		try {
			if ($role == null )
			   $config = new Zend_Config_Ini(APPLICATION_PATH.Zsam_Acl_Ini::PRIVILEGE_FILE) ;
			else
			   $config = new Zend_Config_Ini(APPLICATION_PATH.Zsam_Acl_Ini::PRIVILEGE_FILE, $role) ;
	    } catch (Exception $e) {
	      $config = new Zend_Config(array());
		}
	    return $config;
	}	
	public function load(){
		$roles = $this->readRoles() ;
		$this->_setRoles($roles) ;
		
		$this->_setResources($this->readResources()) ;
		
		foreach ($roles->toArray() as $role => $parents)	{
			$privileges = $this->readPrivileges( $role) ;
			$this->_setPrivileges($role, $privileges) ;
		}
	}
	protected function _setRoles($roles)	{
		foreach ($roles as $role => $parents)	{
			if (empty($parents))	{
				$parents = null ;
			} else {
				$parents = explode(',', $parents) ;
			}

			$this->addRole(new Zend_Acl_Role($role), $parents);
		}
		
		return $this ;
	}

	protected function _setResources($resources)	{
		foreach ($resources as $resource => $parents)	{
			if (empty($parents))	{
				$parents = null ;
			} else {
				$parents = explode(',', $parents) ;
			}

			$this->add(new Zend_Acl_Resource($resource), $parents);
		}
		
		return $this ;
	}

	protected function _setPrivileges($role, $privileges)	{
		foreach ($privileges as $resource => $actions)	{
				if (empty($actions))	{
					$actions = null ;
				} else {
					$actions = explode(',', $actions) ;
				}
				
				$this->allow($role, $resource, $actions);
		}
		
		return $this ;
	}
	public function writeResource($array){
		try {
	       $config = new Zend_Config_Writer_Ini();
	       $config->write(APPLICATION_PATH.Zsam_Acl_Ini::RESOURCE_FILE, new Zend_Config($array));
	  	   return true;
	    } catch (Exception $e) {
	       return false;
	    }
   }
public function writePrivileges($array){
		try {
	       $config = new Zend_Config_Writer_Ini();
	       $config->write(APPLICATION_PATH.Zsam_Acl_Ini::PRIVILEGE_FILE, new Zend_Config($array));
	  	   return true;
	    } catch (Exception $e) {
	       return false;
	    }
   }
}