<?php

class Cisweb_Auth_Plugin extends Zend_Controller_Plugin_Abstract	{
	/**
	 * @var Zend_Auth instance 
	 */
	private $_auth;
	
	/**
	 * @var Zend_Acl instance 
	 */
	private $_acl;
	

	const FAIL_AUTH_MODULE     = 'default';
	const FAIL_AUTH_ACTION     = 'login';
	const FAIL_AUTH_CONTROLLER = 'auth';

	const FAIL_ACL_MODULE     = 'default';
	const FAIL_ACL_ACTION     = 'deny';
	const FAIL_ACL_CONTROLLER = 'auth';

	const FAIL_TIMEOUT_MODULE     = 'default';
	const FAIL_TIMEOUT_ACTION     = 'pretimeout';
	const FAIL_TIMEOUT_CONTROLLER = 'auth';

	private $_allow_guest = array('zsam_controller_json','default_auth_change','default_auth_login','default_auth_logout','default_admin_veracesso','default_auth_recover','default_error_error','default_auth_timeout');
	private $_allow_user = array('default_index','default_auth_pretimeout','default_json_search','default_admin_makeresources','core_nfe_index');
	/**
	 * Construct
	 */
	public function __construct()	{
		
	}
	public function preDispatch(Zend_Controller_Request_Abstract $request)	{
		
		$view = Zend_Controller_Action_HelperBroker::getStaticHelper('ViewRenderer')->view;
		
		/**** PROCESSO ****/
		$cache = Zend_Registry::get('cache');
        /**
		*  @author Gelso Rocha
        *  TODO Ronaldo por favor verificar se esta é a melhor solução para este caso
		*  (limpar o cache quando a lista de processos for atualizada)
        */        
        $cache->remove('list_processos');
                                
	    $module     = $request->getModuleName();
	    $controller = $request->getControllerName();
	    $action     = $request->getActionName();
	    
	    /* Não efetua validações para os actions listados na variavel $_allow */
	    if (in_array($module.'_'.$controller.'_'.$action,$this->_allow_guest))
	    	return;
		
	    if ( !$result = $cache->load('list_processos')){
			$result = array();
			$tab = new core_Model_DbTable_Filedoc1();
                        $cript = new Zsam_Crypt_Cisweb();
			$list = $tab->fetchAll();
			foreach ($list as $r){
				$result[$r->ID]= $cript->decode($r->ROTULO_MENU);
			} 
		    $cache->save($result, 'list_processos');
	    }
		$view->processos = $result;
		
		/**** MENU ******/
	   $array = array();
	   $auth = Zend_Auth::getInstance() ;
	   $timeoutLogin = new Zend_Session_Namespace('Zend_Auth');
	   
	   if ($auth->hasIdentity() ){
	       if ( time() > @$timeoutLogin->timeout) {
	         	$request->setModuleName(self::FAIL_TIMEOUT_MODULE);
	            $request->setControllerName(self::FAIL_TIMEOUT_CONTROLLER);
	            $request->setActionName(self::FAIL_TIMEOUT_ACTION);
	            return;
	       }
	   	   $config = Zend_Registry::get('Cisweb_Config');
		   $timeoutSession = $config[0]['TIMEOUT'];
	   	   $timeoutLogin->timeout = time() + $timeoutSession;
	   	
	   	   $user = $auth->getStorage()->read();
		   $session = new Zend_Session_Namespace('processo');
		   $filedoc = new core_Model_DbTable_Filedoc();
		   /* VERIFICA ACESSO AO CONTROLLER */
		   /* RETIRAR o $user['ACESSORESTRITO']!='S' . Ele foi configurado apenas para termos o usuario com pleno acesso durante o desenvolvimento */
		   if ( !in_array($module.'_'.$controller,$this->_allow_user) && !in_array($module.'_'.$controller.'_'.$action,$this->_allow_user) ){
		   	   // 
		       $pages = $filedoc->getAccessController($user);
		       if ( !in_array($module.'_'.$controller,$pages) && !in_array($module.'_'.$controller.'_'.$action,$pages) ){
		         	$request->setModuleName(self::FAIL_ACL_MODULE);
		            $request->setControllerName(self::FAIL_ACL_CONTROLLER);
		            $request->setActionName(self::FAIL_ACL_ACTION);
		            return;
		       }
		   }
		   
		   
		   
		   if ( $session->__isset('proc') ){
		   	   if ( $session->__isset('menu_'.$session->__get('proc')) && false)
		   	   {
		   	   	  $array = $session->__get('menu_'.$session->__get('proc'));
		   	   } else {
		   	   	  $modulos= array( 
		   	   	  array("label"=>"VENDAS","uri"=>"/"), 
		   	   	  array("label"=>"PAGAMENTOS","uri"=>"/"),
		   	   	  array("label"=>"COMPRAS","uri"=>"/"),
		   	   	  array("label"=>"ESTOQUE","uri"=>"/"), 
		   	   	  array("label"=>"ENGENHARIA","uri"=>"/"), 
		   	   	  array("label"=>"PRODUÇÃO","uri"=>"/"),
		   	   	  array("label"=>"QUALIDADE","uri"=>"/"),
		   	   	  array("label"=>"CONTABILIDADE","uri"=>"/"),
		   	   	  array("label"=>"RH","uri"=>"/"),
		   	   	  array("label"=>"B2B","uri"=>"/"),
		   	   	  array("label"=>"TREINAMENTO","uri"=>"/"),
		   	   	  array("label"=>"CONFIGURAÇÕES","uri"=>"/"));
		   	   	  
		   	   	  $array = array(
		   	   	      array("label"=>"MANUAIS","uri"=>"/","class"=>"manuais","pages"=>$filedoc->getMenuAccess($user,'MANUAIS')),
			   	   	  array("label"=>"LANÇAMENTOS BÁSICOS","uri"=>"/","pages"=>$filedoc->getMenuAccess($user,'LAN_BASICO')),
			   	   	  array("label"=>"LANÇAMENTOS AVANÇADOS","uri"=>"/","pages"=>$filedoc->getMenuAccess($user,'LAN_AVANCADO')),
			   	   	  array("label"=>"RELATÓRIOS BÁSICOS","uri"=>"/","pages"=>$filedoc->getMenuAccess($user,'REL_BASICO')),
			   	   	  array("label"=>"RELATÓRIOS AVANÇADOS","uri"=>"/","pages"=>$filedoc->getMenuAccess($user,'REL_AVANCADO')))
		   	   	 ;
		   	   	  
		   	   	  $session->__set('menu_'.$session->__get('proc'),$array);
		   	   }
		   }
		   //var_dump($array); exit;
		   $config = new Zend_Config($array);
		   $navigation = new Zend_Navigation($config);
	       $view->navigation($navigation);//->setAcl($this->_acl)->setRole(Zend_Registry::get('role'));
			   
	   } else {
         	$request->setModuleName(self::FAIL_AUTH_MODULE);
            $request->setControllerName(self::FAIL_AUTH_CONTROLLER);
            $request->setActionName(self::FAIL_AUTH_ACTION);
	   }
	}	
	/*
	public function preDispatch(Zend_Controller_Request_Abstract $request)	{

		$role =  Zend_Registry::get('role');
		if ($role == 'admin') return;
		
		$module 	= $request->getModuleName() ;
		$controller = $request->getControllerName() ;
		$action     = $request->getActionName() ;
		
		$front = Zend_Controller_Front::getInstance() ;
		$default = $front->getDefaultModule() ;
		
		// compose le nom de la ressource
		if ($module == $default)	{
			$resource = $controller ;
		} else {
			$resource = $module.'_'.$controller ;
		}
        $resource=strtolower($resource);
	    // est-ce que la ressource existe ?
		if (!$this->_acl->has($resource)) {
		  $resource = null;
		}

		if (!$this->_acl->isAllowed($role, $resource, $action)) {
			if (!$this->_auth->hasIdentity()) {
				$module = self::FAIL_AUTH_MODULE ;
				$controller = self::FAIL_AUTH_CONTROLLER ;
				$action = self::FAIL_AUTH_ACTION ;
			} else {
				$module = self::FAIL_ACL_MODULE ;
				$controller = self::FAIL_ACL_CONTROLLER ;
				$action = self::FAIL_ACL_ACTION ;
			}
		}

		$request->setModuleName($module) ;
		$request->setControllerName($controller) ;
		$request->setActionName($action) ;
	}
	
	static function verifica_permissao($page){
		if (Zend_Registry::get('role') == 'admin')
		    return true;
		    
	    $front = Zend_Controller_Front::getInstance() ;
		$default = $front->getDefaultModule() ;
		
		if ($page->getResource) {
		    $resource = $page->getResource() ;
		    $action     = $page->getPrivilege() ;
		} else {
		   $module 	= $page->get('_module') ;
		   $controller = $page->get('_controller') ;
		   $action     = $page->get('_action') ;
			if ($module == $default or $module == "")	{
				$resource = $controller ;
			} else {
				$resource = $module.'_'.$controller ;
			}   
		}
		
		$resource=strtolower($resource);
	    // est-ce que la ressource existe ?
		$acl = Zend_Registry::get('zend_acl');	
		if (!$acl->has($resource)) {
		  $resource = "";
		}
		if ( $resource == "" )
		    return true;
		else
        {		
            $auth = Zend_Auth::getInstance() ;
            return $acl->isAllowed(Zend_Registry::get('role'), $resource, $action);
		}
		
	
	}
	*/
}