<?php

class serv_Model_DbTable_Nfeservicoitem extends Zsam_Db_Table {

	/**
	 * The default table name
	 */

	protected $_name = 'nfeservicoitens';

	var $_autocomplet = array('ITEM_PROGR','NUM_ITEM','PRODUTO');

	var $_conf = array(
			'ID_NFSE' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'NUM_NF' 				=> array('edit' => 'N', 'NULLABLE' => false),
			'ITEM'					=> array('edit' => 'N'),
            'ID_ITEM'				=> array('edit' => 'N'),
			'EMPRESA' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'SERVICO' 				=> array('autocomplete'=>'Y','NULLABLE' => false),
			'SERV_VALOR'  			=> array(),
			'SERV_DEDUCAO' 			=> array(),
			'SERV_PIS' 				=> array(),
			'SERV_COFINS' 			=> array(),
			'SERV_INSS' 			=> array(),
			'SERV_IR' 				=> array(),
			'SERV_CSLL' 			=> array(),
			'SERV_TIPO_ISSRETIDO' 	=> array(),
			'SERV_VALOR_ISS' 		=> array(),
			'SERV_VALOR_ISSRETIDO'  => array(),
			'SERV_RETENCOES' 		=> array(),
			'SERV_ALIQUOTA' 		=> array(),
			'SERV_DESC_CONDIC' 		=> array(),
			'SERV_ITEM_LISTA_SERV'  => array(),
			'SERV_COD_TRIB_MUN'     => array(),
			'SERV_DESCRIMINACAO'    => array(),

	);
	var $_referenceMap = array(
			'SERVICO' => array(
					'columns' 		=> 'SERVICO',
					'refTableClass' => 'serv_Model_DbTable_Servico',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'SERVICO'
			),

			'EMPRESA' => array(
					'columns' 		=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'NOME'
			),

	);
	public function __construct()
	{
		parent::__construct();

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
	}

	public function atualizar($id1)
	{
		$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET ITEM = ITEM - 1 WHERE = ID_NFSE'.$id1);
		$sql->execute();

	}

	public function getCfopsittrib($emp, $cfop)
	{

		$tablecfop  = new core_Model_DbTable_Cfop();
		$tableemp   = new core_Model_DbTable_Empresa();

		$table_icms				= new Cisweb_Db_Abstract("sticms");
		$table_estado			= new Cisweb_Db_Abstract("stipi");
		$table_cidade			= new Cisweb_Db_Abstract("stpis");


		$tab  		= $tablecfop->find($cfop)->current();
		$tabemp  	= $tableemp->find($emp)->current();

		if ($tabemp['REGIME_TRIBUTARIO'] == 3 || $tabemp['REGIME_TRIBUTARIO'] == 4 || $tabemp['REGIME_TRIBUTARIO'] == 13 || $tabemp['REGIME_TRIBUTARIO'] == 14)
		{

			$data['STICMS'] 	= $tab['STICMS'];
			$data['STIPI'] 		= $tab['STIPI'];
			$data['STPIS'] 		= $tab['STPIS'];
			$data['STCOFINS'] 	= $tab['STCOFINS'];

			$tabicms  	= $table_icms->find($tab['STICMS'])->current();

			if  ($tabicms['ALIQUOTA_ICMS'] == 'S')$data['ALIQUOTA_ICMS_EDIT']   = 'S';
			else $data['ALIQUOTA_ICMS_EDIT']   = 'N';

			if  ($tabicms['VALOR_BASE_CALC_ICMS'] == 'S')$data['VALOR_BASE_CALC_ICMS_EDIT']   = 'S';
			else $data['VALOR_BASE_CALC_ICMS_EDIT']   = 'N';

			if  ($tabicms['VALOR_ICMS'] == 'S')$data['VALOR_ICMS_EDIT']   = 'S';
			else $data['VALOR_ICMS_EDIT']   = 'N';
		}
		else
		{

			if (!is_null($tab['ALIQUOTA_DE_CREDITO']))
			{
				$data['ALIQUOTA_ICMS'] 	= $tab['ALIQUOTA_DE_CREDITO'];

			}
			else
			{
				$data['ALIQUOTA_ICMS'] 			= 0.0;

			}

			$data['STICMS'] 	= $tab['STICMS_SIMPLES'];
			$data['STIPI'] 		= $tab['STIPI_SIMPLES'];
			$data['STPIS'] 		= $tab['STPIS_SIMPLES'];
			$data['STCOFINS'] 	= $tab['STCOFINS_SIMPLES'];

		}

		return $data;

	}

	public function beforeInsert(array $data)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if (is_null($data['SERV_VALOR']))$data['SERV_VALOR'] 						= 0.00;
		if (is_null($data['SERV_DEDUCAO']))$data['SERV_DEDUCAO'] 					= 0.00;
		if (is_null($data['SERV_PIS']))$data['SERV_PIS'] 							= 0.00;
		if (is_null($data['SERV_COFINS']))$data['SERV_COFINS'] 						= 0.00;
		if (is_null($data['SERV_INSS']))$data['SERV_INSS'] 							= 0.00;
		if (is_null($data['SERV_IR']))$data['SERV_IR'] 								= 0.00;
		if (is_null($data['SERV_CSLL']))$data['SERV_CSLL'] 							= 0.00;
		if (is_null($data['SERV_TIPO_ISSRETIDO']))$data['SERV_TIPO_ISSRETIDO'] 		= 0;
		if (is_null($data['SERV_VALOR_ISS']))$data['SERV_VALOR_ISS'] 				= 0.00;
		if (is_null($data['SERV_VALOR_ISSRETIDO']))$data['SERV_VALOR_ISSRETIDO'] 	= 0.00;
		if (is_null($data['SERV_RETENCOES']))$data['SERV_RETENCOES'] 				= 0;
		if (is_null($data['SERV_ALIQUOTA']))$data['SERV_ALIQUOTA'] 					= 0.00;
		if (is_null($data['SERV_DESC_CONDIC']))$data['SERV_DESC_CONDIC'] 			= 0.00;
		if (is_null($data['SERV_DESC_INCONDIC']))$data['SERV_DESC_INCONDIC'] 		= 0.00;

		return parent::beforeInsert($data);
	}


	public function beforeUpdate(array $data, $where)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora



		if (is_null($data['SERV_VALOR']))$data['SERV_VALOR'] 						= 0.00;
		if (is_null($data['SERV_DEDUCAO']))$data['SERV_DEDUCAO'] 					= 0.00;
		if (is_null($data['SERV_PIS']))$data['SERV_PIS'] 							= 0.00;
		if (is_null($data['SERV_COFINS']))$data['SERV_COFINS'] 						= 0.00;
		if (is_null($data['SERV_INSS']))$data['SERV_INSS'] 							= 0.00;
		if (is_null($data['SERV_IR']))$data['SERV_IR'] 								= 0.00;
		if (is_null($data['SERV_CSLL']))$data['SERV_CSLL'] 							= 0.00;
		if (is_null($data['SERV_TIPO_ISSRETIDO']))$data['SERV_TIPO_ISSRETIDO'] 		= 0;
		if (is_null($data['SERV_VALOR_ISS']))$data['SERV_VALOR_ISS'] 				= 0.00;
		if (is_null($data['SERV_VALOR_ISSRETIDO']))$data['SERV_VALOR_ISSRETIDO'] 	= 0.00;
		if (is_null($data['SERV_RETENCOES']))$data['SERV_RETENCOES'] 				= 0;
		if (is_null($data['SERV_ALIQUOTA']))$data['SERV_ALIQUOTA'] 					= 0.00;
		if (is_null($data['SERV_DESC_CONDIC']))$data['SERV_DESC_CONDIC'] 			= 0.00;
		if (is_null($data['SERV_DESC_INCONDIC']))$data['SERV_DESC_INCONDIC'] 		= 0.00;


		return parent::beforeUpdate($data, $where);

	}

	public function beforeDelete($where)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		return parent::beforeDelete($where);
	}
}
?>