<?php

class serv_Model_DbTable_Nfeservico extends Zsam_Db_Table {

	protected $_name 			= 'nfes';

	var $_restrict 				= null;

	private $xml_autorizado 	= null;
	private $num_nfes 			= null;
	private $cod_erro 			= null;
	private $cod_verificacao 	= null;
	private $rps_num 			= null;
	private $url 				= null;
	private $nfse 				= null;
	private $id_nfse 			= null;


	public function __construct()
	{
		parent::__construct();

		$controller = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA
		$nome_action=$controller->getActionName();

		/*
		 *  chama as classes do library para a nfse...
		 */
		$this->url = APPLICATION_PATH . DIRECTORY_SEPARATOR . '..'.DIRECTORY_SEPARATOR.
		'library'.DIRECTORY_SEPARATOR.'Cisweb'.DIRECTORY_SEPARATOR. 'Nfeserv'
				. DIRECTORY_SEPARATOR . 'Nusoap'
						. DIRECTORY_SEPARATOR . 'nusoap.php';

		$this->nfse     = new Cisweb_Nfeserv_Nfsephpginfes(false, 1, false);

		$cliente = Zend_Registry::get('Cliente');

/*		if($cliente[0]['IND_COM_SERV'] == "I")
		{
			$this->_referenceMap['CLIENTE']['refTableClass'] = "ind_Model_DbTable_Cliente";
		}

		else if($cliente[0]['IND_COM_SERV'] == "C")
		{
			$this->_referenceMap['CLIENTE']['refTableClass'] = "com_Model_DbTable_Cliente";
		}

		else
		{
			$this->_referenceMap['CLIENTE']['refTableClass'] = "serv_Model_DbTable_Cliente";
		}*/

		if ($nome_action == 'upd')
		{
			$this->_conf['EMPRESA']['edit'] = 'N';
		}

		if($nome_controller == 'nfescancelar')
		{
			$tipo= "CANCELAMENTO = '' OR CANCELAMENTO IS NULL";
			$this->_restrict = $tipo;

			$this->_conf['EMPRESA']['NULLABLE']= true;
			$this->_conf['SERVICO']['NULLABLE']= true;
			$this->_conf['EMIT_RAZAO']['NULLABLE']= true;
			$this->_conf['EMIT_CNPJ']['NULLABLE']= true;
			$this->_conf['EMIT_IM']['NULLABLE']= true;
			$this->_conf['CLIENTE']['NULLABLE']= true;
			$this->_conf['CLI_RAZAO']['NULLABLE']= true;
			$this->_conf['CLI_CNPJ_CPF']['NULLABLE']= true;
			$this->_conf['CLI_LAGRADOURO']['NULLABLE']= true;
			$this->_conf['CLI_NUMEROEND']['NULLABLE']= true;
			$this->_conf['CLI_BAIRRO']['NULLABLE']= true;
			$this->_conf['CLI_CIDADE']['NULLABLE']= true;
			$this->_conf['CLI_UF']['NULLABLE']= true;
			$this->_conf['CLI_CEP']['NULLABLE']= true;
			$this->_conf['SERV_VALOR']['NULLABLE']= true;
			$this->_conf['SERV_TIPO_ISSRETIDO']['NULLABLE']= true;
			$this->_conf['SERV_COD_TRIB_MUN']['NULLABLE']= true;
			$this->_conf['SERV_DESCRIMINACAO']['NULLABLE']= true;
			$this->_conf['CANCELAMENTO']['NULLABLE']= true;
			$this->_conf['CANCELAMENTO']['grid']	= true;
			$this->_conf['EMPRESA']['edit'] 		= 'N';
			$this->_conf['DATA']['edit'] 			= 'N';
			$this->_conf['CLIENTE']['edit'] 		= 'N';
			$this->_conf['TOTAL']['edit'] 			= 'N';

		}


		if($nome_controller == 'nfesgerenciar')
		{


			$this->_conf['CANCELAMENTO']['grid']			= true;
			$this->_conf['CANCELAMENTO']['edit'] 			= 'N';
			$this->_conf['EMPRESA']['edit'] 				= 'N';
			$this->_conf['DATA']['edit'] 					= 'N';
			$this->_conf['CLIENTE']['edit'] 				= 'N';
			$this->_conf['TOTAL']['edit'] 					= 'N';
			$this->_conf['CLI_EMAIL']['edit'] 				= 'N';
			$this->_conf['SERVICO']['edit'] 				= 'N';
			$this->_conf['SERV_VALOR']['edit'] 				= 'N';
			$this->_conf['SERV_DEDUCAO']['edit'] 			= 'N';
			$this->_conf['SERV_PIS']['edit'] 				= 'N';
			$this->_conf['SERV_COFINS']['edit'] 			= 'N';
			$this->_conf['SERV_INSS']['edit'] 				= 'N';
			$this->_conf['SERV_IR']['edit'] 				= 'N';
			$this->_conf['SERV_CSLL']['edit'] 				= 'N';
			$this->_conf['SERV_TIPO_ISSRETIDO']['edit'] 	= 'N';
			$this->_conf['SERV_VALOR_ISS']['edit'] 			= 'N';
			$this->_conf['SERV_VALOR_ISSRETIDO']['edit'] 	= 'N';
			$this->_conf['ERV_RETENCOES']['edit'] 			= 'N';
			$this->_conf['SERV_DESC_CONDIC']['edit'] 		= 'N';
			$this->_conf['SERV_DESC_INCONDIC']['edit'] 		= 'N';
			$this->_conf['SERV_DESCRIMINACAO']['edit'] 		= 'N';
			$this->_conf['SERV_COD_TRIB_MUN']['edit'] 		= 'N';
			$this->_conf['SERV_RETENCOES']['edit'] 			= 'N';

		}


	}

	var $_conf = array(
			'ID_NFSE' 				=> array('edit'=>'N'),
			'NUMERO' 				=> array("grid" => true,'NULLABLE'=>false,'edit'=>'N'),
			'RPS' 					=> array(),
			'DUPLI' 				=> array('edit'=>'N'),
			'DATA' 					=> array('edit'=>'N','grid' => true),
			'PLANO_CONTA' 			=> array('edit'=>'N'),
			'TOTAL' 				=> array('edit'=>'N'),
			'TIPO_SERVICO' 			=> array('edit'=>'N'),
			'EMPRESA' 				=> array('NULLABLE'=>false,"grid" => true),
			'EMIT_RAZAO' 			=> array('NULLABLE'=>false,'edit'=>'N'),
			'EMIT_FANTASIA' 		=> array('edit'=>'N'),
			'EMIT_CNPJ' 			=> array('NULLABLE'=>false,'edit'=>'N'),
			'EMIT_IM' 				=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLIENTE' 				=> array('NULLABLE'=>false,'grid' => true,'edit' => 'N'),
            'CLI_RAZAO' 			=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLI_CNPJ_CPF' 			=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLI_LAGRADOURO' 		=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLI_NUMEROEND' 		=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLI_COMPL' 			=> array('edit'=>'N'),
			'CLI_BAIRRO' 			=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLI_CIDADE' 			=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLI_UF' 				=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLI_CEP' 				=> array('NULLABLE'=>false,'edit'=>'N'),
			'CLI_EMAIL' 			=> array('edit'=>'S'),
			'CLI_TELEFONE' 			=> array('edit'=>'N'),
			'SERVICO' 				=> array('autocomplete'=>'Y','NULLABLE' => false),
			'SERV_VALOR'  			=> array('NULLABLE'=>false),
			'SERV_DEDUCAO' 			=> array(),
			'SERV_PIS' 				=> array(),
			'SERV_COFINS' 			=> array(),
			'SERV_INSS' 			=> array(),
			'SERV_IR' 				=> array(),
			'SERV_CSLL' 			=> array(),
			'SERV_TIPO_ISSRETIDO' 	=> array('NULLABLE'=>false,'VP' =>array('1'=>'iss_retido','2'=>'iss_nao_retido')),
			'SERV_VALOR_ISS' 		=> array(),
			'SERV_VALOR_ISSRETIDO'  => array(),
			'SERV_RETENCOES' 		=> array(),
			'SERV_ALIQUOTA' 		=> array('edit' => 'N',),
			'SERV_DESC_CONDIC' 		=> array(),
			'SERV_DESC_INCONDIC' 	=> array(),
			'SERV_ITEM_LISTA_SERV'  => array('edit' => 'N'),
			'SERV_COD_TRIB_MUN'     => array(),
			'SERV_DESCRIMINACAO'    => array('NULLABLE'=>false),
			'NAT_OPERACAO' 			=> array('edit'=>'N'),
			'STATUS' 				=> array('edit'=>'N','VP'=>array('N'=>' N -Nfe Inutilizada','E'=>' E -Nfe com Erro','U'=>' U -Nfe Autorizada','C'=>' C -Nfe Cancelada','I'=>' I -Em Andamento','A'=>'A -Em Andamento' ,'D'=>'D - Devolvida'),'grid' => true),
			'PROTOCOLO' 			=> array('edit'=>'N'),
			'COD_VERIFICACAO' 		=> array('edit'=>'N'),
			'NUM_NF_GINFES' 		=> array("grid" => true),
			'XML_SERV' 				=> array('edit'=>'S'),
            'CANCELAMENTO' 			=> array('editlevel'=>3,'char_spec'=>'NONE','case'=>'NONE','title'=>'motivo_cancelamento','help'=>'deletar_dupli'),
			'FUNC_ALTERACAO' 		=> array('grid' => false, 'edit' => 'N'),
			'DATA_ALTERACAO' 		=> array('grid' => false, 'edit' => 'N'),
			'REVISAO' 				=> array('grid' => false, 'edit' => 'N'),
            //'GRID' 					=> array('type' => 'itemGrid','model' => 'serv_Model_DbTable_Nfeservicoitem', 'controller' => 'serv_NfeservicoitemController','columns' => array('ID_ITEM','ITEM','SERVICO','SERV_VALOR'),'idWhere' => 'ID_NFSE')
		);

        var $_referenceMap = array(
        'EMPRESA' => array(
            'columns' 		=> 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'EMPRESA'
        ),
        'CLIENTE' => array(
            'columns'       => 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'CLIENTE'
        ),

        'SERVICO' => array(
        	'columns' 		=> 'SERVICO',
        	'refTableClass' => 'serv_Model_DbTable_Servico',
        	'refColumns' 	=> 'CODIGO',
        	'refTitle' 		=> 'SERVICO'
        ),

        'SERV_COD_TRIB_MUN' => array(
        	'columns' 		=> 'SERV_COD_TRIB_MUN',
        	'refTableClass' => 'serv_Model_DbTable_Tribmunicipio',
        	'refColumns' 	=> 'ID',
        	'refTitle' 		=> 'SERV_COD_TRIB_MUN'
        ),

        'CIDADE' => array(
        	'columns' => 'CIDADE',
        	'refTableClass' => 'core_Model_DbTable_Cidade',
        	'refColumns' => 'CODIGO',
        	'refTitle' => 'CIDADE'),

        /*'GRID' => array(
            'columns' 		=> 'ID_NFSE',
            'refTableClass' => 'serv_Model_DbTable_Nfeservicoitem',
            'refColumns' 	=> 'ID_NFSE',
            'refTitle' 		=> 'ID_NFSE'
        )*/

    );

    public function beforeInsert(array $data)
    {
    	$controller 		= Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller 	= $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA
    	$nome_action 		= $controller->getActionName();

    	$dadostom = $this->getTomador($data['CLIENTE']);

    		$data['CLI_RAZAO'] 		= $dadostom['NOME'];
    		$data['CLI_CNPJ_CPF'] 	= $dadostom['CNPJ'];
    		$data['CLI_LAGRADOURO'] = $dadostom['ENDERECO'];
    		$data['CLI_NUMEROEND'] 	= $dadostom['NUMERO_ENDERECO'];
    		$data['CLI_COMPL'] 		= $dadostom['COMPLEMENTO'];
    		$data['CLI_BAIRRO'] 	= $dadostom['BAIRRO'];
    		$data['CLI_CIDADE'] 	= $dadostom['CIDADE'];
    		$data['CLI_UF'] 		= $dadostom['ESTADO'];
    		$data['CLI_CEP'] 		= $dadostom['CEP'].$dadostom['CEP1'];
    		$data['CLI_TELEFONE'] 	= $dadostom['FONEFAX'];

    	$dadosemp = $this->getEmpresa($data['EMPRESA']);

    		$data['EMIT_RAZAO'] 	= $dadosemp['NOME'];
    		$data['EMIT_CNPJ'] 		= $dadosemp['CNPJ'];
    		$data['EMIT_FANTASIA'] 	= $dadosemp['NOME_FANTASIA'];
    		$data['EMIT_IM'] 		= $dadosemp['INSCRICAO_MUNICIPAL'];

    		$data['DATA'] 			= date("Y-m-d");

    	if (is_null(@$data['SERV_VALOR']))$data['SERV_VALOR'] 						= 0.00;
    	if (is_null(@$data['SERV_DEDUCAO']))$data['SERV_DEDUCAO'] 					= 0.00;
    	if (is_null(@$data['SERV_PIS']))$data['SERV_PIS'] 							= 0.00;
    	if (is_null(@$data['SERV_COFINS']))$data['SERV_COFINS'] 						= 0.00;
    	if (is_null(@$data['SERV_INSS']))$data['SERV_INSS'] 							= 0.00;
    	if (is_null(@$data['SERV_IR']))$data['SERV_IR'] 								= 0.00;
    	if (is_null(@$data['SERV_CSLL']))$data['SERV_CSLL'] 							= 0.00;
    	if (is_null(@$data['SERV_TIPO_ISSRETIDO']))$data['SERV_TIPO_ISSRETIDO'] 		= 0;
    	if (is_null(@$data['SERV_VALOR_ISS']))$data['SERV_VALOR_ISS'] 				= 0.00;
    	if (is_null(@$data['SERV_VALOR_ISSRETIDO']))$data['SERV_VALOR_ISSRETIDO'] 	= 0.00;
    	if (is_null(@$data['SERV_RETENCOES']))$data['SERV_RETENCOES'] 				= 0;
    	if (is_null(@$data['SERV_ALIQUOTA']))$data['SERV_ALIQUOTA'] 					= 0.00;
    	if (is_null(@$data['SERV_DESC_CONDIC']))$data['SERV_DESC_CONDIC'] 			= 0.00;
    	if (is_null(@$data['SERV_DESC_INCONDIC']))$data['SERV_DESC_INCONDIC'] 		= 0.00;

    	$id_tributcao = '';

    	/*
    	 *  pega o codigo de tributo do servico por municipio...
    	 */
		if (isset($data['SERV_COD_TRIB_MUN'])){
			$id_tributcao = @$data['SERV_COD_TRIB_MUN'];
			$trib  = $this->gettribMunicipio($id_tributcao);
			$data['SERV_COD_TRIB_MUN']      = $trib['CODIGO'];
		}		
		 
    	/*
    	 *  funcao para criar o xml para envio...
    	 */
    	$data['XML_SERV'] = $this->crianf($data);
    	$data['STATUS']   				= "I";
    	$data['SERV_COD_TRIB_MUN']      = $id_tributcao;
    	$data['RPS'] 					= $this->rps_num;


    	// ATUALIZA EMPRESA O NUM DA NFE
    	$emp = new core_Model_DbTable_Empresa();
    	$dataemp['ULTIMA_NFE_SERVICO'] = $data['NUMERO'];
    	$whereemp = 'CODIGO = '.$data['EMPRESA'];
    	$emp->update($dataemp, $whereemp);

    	return parent::beforeInsert($data);
    }

    public function beforeUpdate(array $data, $where)
    {
    	$controller = Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA
		//para deletar as duplicatas em caso de cancelamento

		if($nome_controller == 'nfescancelar')
		{
			$id		 = $data["NUMERO"];
			$emp	 = $data["EMPRESA"];
			$dataemi = $data["DATA"];
			$cancel	 = $data["CANCELAMENTO"];

		    if (!is_null($cancel) && $cancel <> ''){
				$table2 		= new core_Model_DbTable_Duplicata();
				$adapter2 		= $table2->getAdapter();
				$where2 		= "NF = '$id' AND EMPRESA1 = '$emp' AND DATA_EMISSAO = '$dataemi'";
				$table2->delete($where2);

				$data["STATUS"] = 'C';

			}
		}else{

			$dadostom = $this->getTomador($data['CLIENTE']);

			$data['CLI_RAZAO'] 		= $dadostom['NOME'];
			$data['CLI_CNPJ_CPF'] 	= $dadostom['CNPJ'];
			$data['CLI_LAGRADOURO'] = $dadostom['ENDERECO'];
			$data['CLI_NUMEROEND'] 	= $dadostom['NUMERO_ENDERECO'];
			$data['CLI_COMPL'] 		= $dadostom['COMPLEMENTO'];
			$data['CLI_BAIRRO'] 	= $dadostom['BAIRRO'];
			$data['CLI_CIDADE'] 	= $dadostom['CIDADE'];
			$data['CLI_UF'] 		= $dadostom['ESTADO'];
			$data['CLI_CEP'] 		= $dadostom['CEP'].$dadostom['CEP1'];
			$data['CLI_TELEFONE'] 	= $dadostom['FONEFAX'];

			$dadosemp = $this->getEmpresa($data['EMPRESA']);

			$data['EMIT_RAZAO'] 	= $dadosemp['NOME'];
			$data['EMIT_CNPJ'] 		= $dadosemp['CNPJ'];
			$data['EMIT_FANTASIA'] 	= $dadosemp['NOME_FANTASIA'];
			$data['EMIT_IM'] 		= $dadosemp['INSCRICAO_MUNICIPAL'];

			if (is_null($data['SERV_VALOR']))$data['SERV_VALOR'] 						= 0.00;
			if (is_null($data['SERV_DEDUCAO']))$data['SERV_DEDUCAO'] 					= 0.00;
			if (is_null($data['SERV_PIS']))$data['SERV_PIS'] 							= 0.00;
			if (is_null($data['SERV_COFINS']))$data['SERV_COFINS'] 						= 0.00;
			if (is_null($data['SERV_INSS']))$data['SERV_INSS'] 							= 0.00;
			if (is_null($data['SERV_IR']))$data['SERV_IR'] 								= 0.00;
			if (is_null($data['SERV_CSLL']))$data['SERV_CSLL'] 							= 0.00;
			if (is_null($data['SERV_TIPO_ISSRETIDO']))$data['SERV_TIPO_ISSRETIDO'] 		= 0;
			if (is_null($data['SERV_VALOR_ISS']))$data['SERV_VALOR_ISS'] 				= 0.00;
			if (is_null($data['SERV_VALOR_ISSRETIDO']))$data['SERV_VALOR_ISSRETIDO'] 	= 0.00;
			if (is_null($data['SERV_RETENCOES']))$data['SERV_RETENCOES'] 				= 0;
			if (is_null($data['SERV_ALIQUOTA']))$data['SERV_ALIQUOTA'] 					= 0.00;
			if (is_null($data['SERV_DESC_CONDIC']))$data['SERV_DESC_CONDIC'] 			= 0.00;
			if (is_null($data['SERV_DESC_INCONDIC']))$data['SERV_DESC_INCONDIC'] 		= 0.00;


			$id_tributcao = @$data['SERV_COD_TRIB_MUN'];

			/*
			 *  pega o codigo de tributo do servico por municipio...
			*/
			$trib  = $this->gettribMunicipio(@$data['SERV_COD_TRIB_MUN']);
			$data['SERV_COD_TRIB_MUN']      = $trib['CODIGO'];

			/*
			 *  funcao para criar o xml para envio...
			*/
			$data['XML_SERV'] = $this->crianf($data);
			$data['STATUS']   				= "I";
			$data['SERV_COD_TRIB_MUN']      = $id_tributcao;
		}

    	return parent::beforeUpdate($data, $where);
    }

    public function getTomador($id)
    {
    	$table = new Cisweb_Db_Abstract('cliente');
    	$dados = $table->find($id)->current()->toArray();
    	return $dados = $table->decrypt($dados);
    }

    public function getEmpresa($id)
    {
    	$table = new core_Model_DbTable_Empresa();
    	$dados = $table->find($id)->current()->toArray();
    	return $dados = $table->decrypt($dados);
    }

    public function getServico($id)
    {
    	$table = new serv_Model_DbTable_Servico();
    	$dados = $table->find($id)->current()->toArray();
    }

    public function gettribMunicipio($id)
    {
    	$table = new serv_Model_DbTable_Tribmunicipio();
    	return $dados = $table->find($id)->current();
    }

    public function crianf($rowNfe)
    {

    	//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=PREENCHENDO DADOS-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

    	$idLote = $rowNfe['NUMERO']; // número qualquer desde que não exista ainda no ginfes

    	$rps    = $rowNfe['NUMERO']; // número superior ao ultimo rps enviado

    	$rps    = date("ym") . sprintf('%011s', $rps);

    	$aLote = array();

    	//$this->numeroLote   = date("ym").sprintf("%011s", $idlote);
    	// classe para preenchimento dos dados
    	//$oNF = new Nfsephpginfesdata($rps++);
    	$oNF 	= new Cisweb_Nfeserv_Nfsephpginfesdata($rps);
    	$nfse 	= new Cisweb_Nfeserv_Nfsephpginfes(false, 1, false);

    	//- - - - - - - - - - - - - - DADOS DO EMISSOR - - - - - - - - - - - - - -

    	$emp = new core_Model_DbTable_Empresa();
    	$cidadeemp = $emp->getCidade($rowNfe['EMPRESA'])->toArray();

    	$oNF->set('razaoSocial', $rowNfe['EMIT_RAZAO']);
    	$oNF->set('nomeFantasia', $rowNfe['EMIT_FANTASIA']);
    	$oNF->set('CNPJ', $rowNfe['EMIT_CNPJ']);
    	$oNF->set('IM', $rowNfe['EMIT_IM']);

    	// série da nota fiscal
    	$oNF->set('numSerie', '1');

    	// 1 = nota conjugada / 2-mista / 3-cupom
    	$oNF->set('tipo', '1');

    	/*
    	 01 – Tributação no municipio;
    	02 – Tributação fora do municipio;
    	03 – Isenção;
    	04 – Imune;
    	05 – Exigibilidade suspensa por decisão judicial;
    	06 – Exigibilidade suspensa por procedimento administrativo.
    	*/
    	$oNF->set('natOperacao', '1');

    	// 1 = sim | 2 = não
    	$oNF->set('optanteSimplesNacional', '1');

    	// 1 = sim | 2 = não
    	$oNF->set('incentivadorCultural', '2');

    	// 1 = sim | 2 = não
    	$oNF->set('regimeEspecialTributacao', '5');

    	// 1 - normal 2 - cancelado (status da nota fiscal)
    	$oNF->set('status', '1');

    	// código do municipio do prestador segundo tabela do ibge
    	$oNF->set('cMun', $cidadeemp['cidadeCodigoIBGE']);
    	//- - - - - - - - - - - - - - DESCRIÇÃO DOS SERVIÇOS - - - - - - - - - - - - - -

    		$oNF->setItem('valorServicos', $rowNfe['SERV_VALOR']);
    		$oNF->setItem('valorDeducoes', $rowNfe['SERV_DEDUCAO']);
    		$oNF->setItem('valorPis', $rowNfe['SERV_PIS']);
    		$oNF->setItem('valorCofins', $rowNfe['SERV_COFINS']);
    		$oNF->setItem('valorInss', $rowNfe['SERV_INSS']);
    		$oNF->setItem('valorIr', $rowNfe['SERV_IR']);
    		$oNF->setItem('valorCsll', $rowNfe['SERV_CSLL']);
    		$oNF->setItem('issRetido',$rowNfe['SERV_TIPO_ISSRETIDO']);
    		$oNF->setItem('valorIss', number_format($rowNfe['SERV_VALOR_ISS'],2,'.',''));
    		$oNF->setItem('valorIssRetido', $rowNfe['SERV_VALOR_ISSRETIDO']);
    		$oNF->setItem('outrasRetencoes', $rowNfe['SERV_RETENCOES']);
    		$oNF->setItem('aliquota',number_format($rowNfe['SERV_ALIQUOTA']/100,2,'.',''));
    		$oNF->setItem('descontoIncondicionado', $rowNfe['SERV_DESC_INCONDIC']);
    		$oNF->setItem('descontoCondicionado', $rowNfe['SERV_DESC_CONDIC']);
    		$oNF->setItem('itemListaServico', @$rowNfe['SERV_ITEM_LISTA_SERV']);
    		$oNF->setItem('codigoTributacaoMunicipio', @$rowNfe['SERV_COD_TRIB_MUN']);
    		$oNF->setItem('discriminacao', @$rowNfe['SERV_DESCRIMINACAO']);


    	/*  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
    	 *
    	* OBS:
    	* No item, os campos 'itemListaServico'  e 'codigoTributacaoMunicipio' precisam ter o EXATO formato conforme cadastro na prefeitura do municipio
    	*
    	* Para verificar qual o código de tributação referente ao serviço informado no arquivo acesse o Ginfes: http://PREFEITURADASUACIDADE.ginfes.com.br
    	* com o usuário e senha da empresa.
    	*
    	* Clique em emitir NFS-e / clique em serviços prestados / clique na lupa ao lado de Código do Serviço/Atividade: informe o código ou a
    	* descrição do serviço na barra de pesquisa e clique em pesquisar / será exibido uma lista com todos os serviços referente ao código /
    	* descrição pesquisado, o código de tributação é a coluna código de atividade copie exatamente como demonstrado no sistema.
    	*
    	* *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  */

    	$cliente = new serv_Model_DbTable_Cliente();
    	$cidade  = $cliente->getCidade($rowNfe['CLIENTE']);

    	//- - - - - - - - - - - - - - DADOS DO TOMADOR DO SERVIÇO - - - - - - -

    	if (strlen($rowNfe['CLI_CNPJ_CPF']) == 14)
    	{
    		$oNF->set('tomaCNPJ', $rowNfe['CLI_CNPJ_CPF']);
    	}
    	else
    	{
    		$oNF->set('tomaCPF', $rowNfe['CLI_CNPJ_CPF']);
    	}

    	$oNF->set('tomaRazaoSocial', $rowNfe['CLI_RAZAO']);
    	$oNF->set('tomaEndLogradouro', $rowNfe['CLI_LAGRADOURO']);
    	$oNF->set('tomaEndNumero', $rowNfe['CLI_NUMEROEND']);
    	$oNF->set('tomaEndComplemento', $rowNfe['CLI_COMPL']);
    	$oNF->set('tomaEndBairro', $rowNfe['CLI_BAIRRO']);


    	$oNF->set('tomaEndxMun', (string)$cidade['cidadeNome']);
    	$oNF->set('tomaEndcMun', (string)$cidade['cidadeCodigoIBGE']);
    	$oNF->set('tomaEndUF', $rowNfe['CLI_UF']);
    	$oNF->set('tomaEndCep', $rowNfe['CLI_CEP']);
    	$oNF->set('tomaEmail', @$rowNfe['CLI_EMAIL']);
    	$oNF->set('tomaFone', @$rowNfe['CLI_TELEFONE']);
    	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    	$aLote[] = $oNF;

    	$xmlLote = $nfse->montarLoteRps($idLote , $aLote);

    	$this->rps_num = $rps;

    	return utf8_encode($this->removeEmptyNodes($xmlLote));

    }
	
	public static function removeEmptyNodes($xml) {
        // carrega o documento no DOM
        $dom = new DOMDocument('1.0', 'UTF-8');
        $dom->preservWhiteSpace = false;
        // $dom->loadXML($xml);
        $dom->loadXML($xml, LIBXML_NOEMPTYTAG | LIBXML_NOBLANKS);
        $dom->formatOutput = true;

        $fixed_node =  array('cEAN', 'cEANTrib','vIOF');
        // muito importante deixar ativadas as opçoes para limpar os espacos em branco
        // e as tags vazias
        $xpath = new DOMXPath($dom);
        foreach( $xpath->query('//*[not(node())]') as $node ) {
            if (in_array($node->nodeName, $fixed_node )) continue;
            else $node->parentNode->removeChild($node);
        }
        return $dom->saveXML() ;
    }

    public function envianf($id,$password = '',$certs = '')
    {
    	$this->id_nfse  = $id;

    	$nfe 			= new Cisweb_Db_Abstract('nfes');
    	$row 			= $this->find($id)->current()->toArray();

    	$modelEmpresa 	= new core_Model_DbTable_Empresa();
    	$rowEmpresa 	= $modelEmpresa->decrypt($modelEmpresa->find($row['EMPRESA'])->current()->toArray());

    	if ($password != '' && $certs != '')
    	{
    		$retorno  = $this->nfse->enviarLoteRps($row['XML_SERV'],'S');
    		$pos      = strripos($retorno, '<ns3:Protocolo>');
    		$prot 	  = substr($retorno, $pos+15,7);
    		$prot 	  = $this->nfse->limparString($prot);

    		$this->rps_num 	 = $this->tratamento($retorno,'lote');

    		$data['PROTOCOLO'] = $prot;

    		$nfe->update($data, "ID_NFSE = '$id'");
    		//$prot = '14823307';
    		//$retorno2 = $nfse->consultarLoteRps($prot, $row['EMIT_CNPJ'], $row['EMIT_IM']);
    	}

        $retorno2 = $this->nfse->consultarNfseRps($row['RPS'], '1', '1',$row['EMIT_CNPJ'], $row['EMIT_IM']);

    	//$retorno2 = $nfse->consultarNfse('4',$row['EMIT_CNPJ'], $row['EMIT_IM']);

    	$tratamento =  $this->tratamento($retorno2,'consulta');

    	if (! is_null($this->num_nfes) && ! is_null($this->cod_verificacao))
    	{
    		$dataret['STATUS'] 				= 'U';
    		$dataret['COD_VERIFICACAO'] 	= $this->cod_verificacao;
    		$dataret['NUM_NF_GINFES']       = $this->num_nfes;
    		$dataret['XML_SERV']        	= $this->nfse->limparString2($this->xml_autorizado);
    		$nfe->update($dataret, "ID_NFSE = '$id'");
    	}
    	elseif(! is_null($this->cod_erro))
    	{
    		$this->verificaErro($this->cod_erro);
    	}

    	return $tratamento;


    }

    /*
     *  funcao criada para achar solucao para os erros retornados
     */
    public function verificaErro($codigo)
    {
    	// rps nao encontrado ... consulta novamente..
    	if ($codigo == 'E89')
    	{
    		$this->envianf($this->id_nfse);
    	}

    }

    public function criaPdf($id)
    {

    	$nfe 			= new Cisweb_Db_Abstract('nfes');
    	$row 			= $this->find($id)->current()->toArray();

    	$pref['NomePrefeitura'] 	= 'PREFEITURA MUNICIPAL DE SAO JOSE DOS CAMPOS';
    	$pref['Municipio'] 			= 'SAO JOSE DOS CAMPOS';
    	$pref['UfMunicipio'] 		= 'SP';
    	$pref['FantasiaPrestador'] 	= '';
    	$pref['MunicipioPrestador'] = 'SAO JOSE DOS CAMPOS';
    	$pref['UfPrestador'] 		= 'SP';
    	$pref['EmailPrestador'] 	= 'elana@cis-erp.com.br';
    	$pref['InscricaoMunicipalTomador'] = '';
    	$pref['MunicipioTomador'] 	= 'SAO JOSE DOS CAMPOS';
    	$pref['UfTomador'] 			= 'SP';
    	$pref['TelefoneTomador'] 	= '1288513634';
    	$pref['EmailTomador'] 		= 'tiago@cis-erp.com.br';
    	$pref['ServicoPrestado'] 	= 'DESENVOLVIMENTO DE SISTEMA';
    	$pref['Avisos']    			= '1- Uma via desta Nota Fiscal sera enviada atraves do e-mail fornecido pelo Tomador dos Serviços.
'."\n".'2- A autenticidade desta Nota Fiscal podera ser verificada no site, sjc.ginfes.com.br com a utilização do Codigo de Verificacao.
'."\n".'3 - Documento emitido por ME ou EPP optante pelo Simples Nacional.Nao gera direito a credito fiscal de ISS e IPI'."\n";

    	$this->nfse->gerarPDF('2',$pref,$row['XML_SERV']);


    }

    private function tratamento($soap,$tipo) {

    	$doc = new DOMDocument(); //cria objeto DOM
    	$doc->formatOutput = FALSE;
    	$doc->preserveWhiteSpace = FALSE;
    	$doc->loadXML($soap, LIBXML_NOBLANKS | LIBXML_NOEMPTYTAG);
    	//status do recebimento ou mensagem de erro
    	//$aRet['Numero'] = $doc->getElementsByTagName('Numero')->item(0)->nodeValue;
    	//$aRet['CodigoVerificacao'] = $doc->getElementsByTagName('CodigoVerificacao')->item(0)->nodeValue;
    	//$aRet['DataEmissao'] = $doc->getElementsByTagName('DataEmissao')->item(0)->nodeValue;

    	if ($tipo == 'lote')
    	{
    		$ret = @$doc->getElementsByTagName('NumeroLote')->item(0)->nodeValue;

    		return $ret;
    	}

    	if ($tipo == 'consulta')
    	{

	    	$erros = $doc->getElementsByTagName('ListaMensagemRetorno');

	    	if ($erros->length > 0) {

	    		$errMsg = "Codigo de erro: " . $doc->getElementsByTagName('Codigo')->item(0)->nodeValue . "\n";
	    		$errMsg.= "Mensagem: " . $doc->getElementsByTagName('Mensagem')->item(0)->nodeValue . "\n";
	    		$errMsg.= "Correcao: " . $doc->getElementsByTagName('Correcao')->item(0)->nodeValue . "\n";
	    		$this->cod_erro = $doc->getElementsByTagName('Codigo')->item(0)->nodeValue;

	    		return $errMsg;
	    	}
	    	elseif(isset($doc->getElementsByTagName('CodigoVerificacao')->item(0)->nodeValue) && isset($doc->getElementsByTagName('Numero')->item(0)->nodeValue))
	    	{

	    		 $ret = 'Nota Fiscal Autorizada'. "\n";
	    		 $ret .= 'Numero : '.$doc->getElementsByTagName('Numero')->item(0)->nodeValue. "\n";
	    		 $ret .= 'Codigo : '.$doc->getElementsByTagName('CodigoVerificacao')->item(0)->nodeValue. "\n";

	    		 $this->num_nfes 		= $doc->getElementsByTagName('Numero')->item(0)->nodeValue;
	    		 $this->cod_verificacao = $doc->getElementsByTagName('CodigoVerificacao')->item(0)->nodeValue;
				 $this->xml_autorizado  = $soap;

	    		 return $ret;
	    	}
	    	else
	    	{
	    		return "Erro de comunicacao ... Tente Novamente ou contate o Suporte ...";
	    	}
    	}
    }

    public function insereItens($itens,$nf,$control=null)// itens vindo programa...
    {
    	$table 		= new core_Model_DbTable_Nfecisitem();
    	$tableprog 	= new serv_Model_DbTable_Programa();

    	if (is_null($control))
    	{
	    	foreach ($itens as $k => $values)
	    	{

	    		$formData['NF'] 					= $nf;
	    		$formData['EMPRESA']				= $itens[$k]['EMPRESA'];
	    		$formData['ITEM']					= $itens[$k]['NUM_ITEM'];
	    		$formData['PROGRAMA']				= $itens[$k]['ITEM_PROGR'];

	    		$formData['PRODUTO'] 				= $itens[$k]['PRODUTO'];
	    		$formData['PROGRAMA_ITEM']			= $itens[$k]['NUM_ITEM'];
	    		$formData['QUANTIDADE']				= $itens[$k]['QUANTIDADE'];
	    		$formData['PRECO_UNITARIO']			= $itens[$k]['PRECO_UNITARIO'];
	    		$formData['UNI'] 					= $itens[$k]['UNI'];
	    		$formData['NCM']					= $itens[$k]['NCM'];
	    		$formData['CFOP']					= $itens[$k]['CFOP'];
	    		$formData['TOTAL_ITEM']				= $itens[$k]['PRECO_TOTAL_ITEM'];
	    		$formData['ORIGEM_SIT_TRIBUTARIA']	= $itens[$k]['ORIGEM_SIT_TRIBUTARIA'];

	    		$formData['STICMS'] 				= $itens[$k]['STICMS'];
	    		$formData['ALIQUOTA_ICMS']			= $itens[$k]['ALIQUOTA_ICMS'];
	    		$formData['BASE_DE_CALCULO_ICMS']	= $itens[$k]['BASE_DE_CALCULO_ICMS'];
	    		$formData['TOTAL_ICMS']				= $itens[$k]['TOTAL_ICMS'];

	    		$formData['STIPI'] 					= $itens[$k]['STIPI'];
	    		$formData['BASE_DE_CALCULO_IPI']	= $itens[$k]['BASE_DE_CALCULO_IPI'];
	    		$formData['ALIQUOTA_IPI']			= $itens[$k]['ALIQUOTA_IPI'];
	    		$formData['TOTAL_IPI']				= $itens[$k]['TOTAL_IPI'];

	    		$formData['STPIS'] 					= $itens[$k]['STPIS'];
	    		$formData['BASE_DE_CALCULO_PIS']	= $itens[$k]['BASE_DE_CALCULO_PIS'];
	    		$formData['ALIQUOTA_PIS']			= $itens[$k]['ALIQUOTA_PIS'];
	    		$formData['TOTAL_PIS']				= $itens[$k]['TOTAL_PIS'];

	    		$formData['STCOFINS'] 				= $itens[$k]['STCOFINS'];
	    		$formData['BASE_DE_CALCULO_COFINS']	= $itens[$k]['BASE_DE_CALCULO_COFINS'];
	    		$formData['ALIQUOTA_COFINS']		= $itens[$k]['ALIQUOTA_COFINS'];
	    		$formData['TOTAL_COFINS']			= $itens[$k]['TOTAL_COFINS'];

	    		$formData['PERCENTUAL_REDUCAO_BC_ICMS']= $itens[$k]['PERCENTUAL_REDUCAO_BC_ICMS'];
	    		$formData['MODALIDADE_BC_ICMS']		= $itens[$k]['MODALIDADE_BC_ICMS'];// PRECISA CORRIGIR 0-Margem Valor Agregado / 1-Pauta (valor) / 2-preco Tabelado(valor) / 3-valor da operacao
	    		$formData['MODALIDADE_BC_ICMSST'] 	= $itens[$k]['MODALIDADE_BC_ICMSST'];
	    		$formData["BASE_DE_CALCULO_ICMS_ST"]= $itens[$k]["BASE_DE_CALCULO_ICMS_ST"];
	    		$formData["ALIQUOTA_ICMS_ST"]		= $itens[$k]["ALIQUOTA_ICMS_ST"];
	    		$formData['TOTAL_ICMS_ST']			= $itens[$k]['TOTAL_ICMS_ST'];
	    		$formData['BASE_CALCULO_ICMSST_RETIDO']= $itens[$k]['BASE_CALCULO_ICMSST_RETIDO'];
	    		$formData['VALOR_ICMSST_RETIDO']	= $itens[$k]['VALOR_ICMSST_RETIDO'];

	    		$formData['OBS']					= $itens[$k]['INFORMACAO_ADICIONAL'];

				$table->insert($formData);

	        }

    	}
    }

    public function Baixapedidos($id,$numnf,$campos,$modelprogitem,$modelprog)
    {

    		$datap['NUMERO_NF'] = $numnf;
    		$datap['DATA_NF'] 	= Zsam_Util::dateSql(Zsam_Util::dateNow());

    		foreach($campos as $k => $v){

    			$where = "ID = '{$v['ID']}'";
    			$modelprogitem->update($datap, $where);
    		}

    		$datap['BAIXA'] 	= 'B';
    		$datap['NUMERO_NF'] = $numnf;
    		$datap['DATA_NF'] 	= Zsam_Util::dateSql(Zsam_Util::dateNow());

    		$modelprog->updateMultiplesKeys($datap, $id);

    }

    public function getLocacao($id)
    {

    	$model     	= new Cisweb_Db_Abstract("locacao");

    	$adapter 				= $model->getAdapter();
    	$where					= "ID  = '$id'";
    	$row 					= $adapter->fetchRow($model->select()->where($where));
    	return $row;

    }
}

?>