<?php

class serv_Model_DbTable_Manutsitesurvey extends Zsam_Db_Table {

	protected $_name = 'manutsitesurvey';
	var $_restrict 	 = 'FECHADO IS NULL';

	var $_conf = array(
			'ID'				=> array('edit' => 'N'),
			'CLIENTE' 			=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'ITEM_PROGR'		=> array('edit' => 'N','grid' => true),
			'NUM_ITEM' 			=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'EMPRESA' 			=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'DATA' 				=> array('NULLABLE' => false),
			'NUMERO_CHAMADO' 	=> array(),
			'NUMERO_MANUT' 		=> array('edit' => 'N'),
			'DATA_ATENDIMENTO' 	=> array(),
			'NOME_CLIENTE' 		=> array(),
			'HORA_INICIO' 		=> array('validate' => array('Cisweb_Validate_Horasitesurvey')),
			'HORA_FIM' 			=> array(),
			'HORA_INICIO2' 		=> array(),
			'HORA_FIM2' 		=> array(),
			'OBSERVACAO' 		=> array(),
			'STATUS' 			=> array('VP' => array('C' => 'concluido', 'P' => 'pendente')),
			'GRID'              => array('type' => 'itemGridAuto', //Padrão, indica o helper que monta a grid
                                    'configitem'    => 'GRID', //Indica qual campo do atributo $zsam_form_item da controladora deve ser usado             
                                    'model'     => 'serv_Model_DbTable_Manutsitesurveytecnico', //Model do filho
                                    //Colunas que aparecerão na grid
                                    'columns'   => array('NUM_ITEM','CLIENTE','ITEM_PROGR','SITE_SURVEY','TECNICO'),
                                    'idWhere'   => array('CLIENTE','ITEM_PROGR','SITE_SURVEY'),//Chave primária sem o campo "auto increment"
                                    'buttons'   => array('edit'=>'S', 'del' => 'S')),//Configuração dos botões da grid
			'GRID1'             => array('type' => 'itemGridAuto', //Padrão, indica o helper que monta a grid
			                        'configitem'    => 'GRID1', //Indica qual campo do atributo $zsam_form_item da controladora deve ser usado             
			                        'model'     => 'serv_Model_DbTable_Manutsitesurveyrecurso', //Model do filho
			                        //Colunas que aparecerão na grid
			                        'columns'   => array('NUM_ITEM','CLIENTE','ITEM_PROGR','SITE_SURVEY','RECURSO'),
			                        'idWhere'   => array('CLIENTE','ITEM_PROGR','SITE_SURVEY'),//Chave primária sem o campo "auto increment"
			                        'buttons'   => array('edit'=>'S', 'del' => 'S')),//Configuração dos botões da grid
	);
	
	var $_referenceMap = array(
			
			'EMPRESA' => array(
					'columns' 		=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'NOME'
			),
			'CLIENTE' => array(
				'columns' 		=> 'CLIENTE',
				'refTableClass' => 'serv_Model_DbTable_Cliente',
				'refColumns' 	=> 'CODIGO',
				'refTitle' 		=> 'CLIENTE'
			),
			'GRID' => array(
			    'columns'       => 'ID',
			    'refTableClass' => 'serv_Model_DbTable_Manutsitesurveytecnico',
			    'refColumns'    => 'ID',
			    'refTitle'      => 'ITEM'
			),
			'GRID1' => array(
			    'columns'       => 'ID',
			    'refTableClass' => 'serv_Model_DbTable_Manutsitesurveyrecurso',
			    'refColumns'    => 'ID',
			    'refTitle'      => 'ITEM'
			),
	);
	
	public function __construct()
    {
		parent::__construct();
		$controller 			 = Zend_Controller_Front::getInstance()->getRequest();
		$nome_action 	 = $controller->getActionName();
		
		if($nome_action == 'newmodalcis'){
			
			$this->_conf['HORA_INICIO'] 			= array(); 
			$this->_conf['HORA_FIM'] 				= array();
			$this->_conf['DATA_ATENDIMENTO']		= array();
			$this->_conf['NOME_CLIENTE'] 			= array();
			$this->_conf['STATUS'] 					= array();
			$this->_conf['NUMERO_CHAMADO']['edit']	= null;
		}
		
    }
    
    
    public function beforeInsert(array $data){
    
    	$data['NUMERO_MANUT'] = $data['CLIENTE'].'/'.$data['ITEM_PROGR']; 
    	return parent::beforeInsert($data);
    
    }
    
    public function beforeUpdate(array $data,$where){
    	
    	$status = $data['STATUS'];
    	
    	if($status == 'C'){
    		$data['FECHADO'] = 'S';
    	}
    	
    	//Gera um novo site survey
    	if($status == 'P'){
    		    		
    		$table 	 = new serv_Model_DbTable_Manutsitesurvey();
    		$select = $table->select()
    								  ->from('manutsitesurvey', array('MAX(NUM_ITEM) AS NUM_ITEM'))
    								  ->where('CLIENTE=?', $where[' CLIENTE = ? '])->where('ITEM_PROGR=?', $where[' ITEM_PROGR = ? ']);
    		
    		$select = $table->fetchRow($select)->toArray();
    		
    		$data_apoio['CLIENTE'] 				= $where[' CLIENTE = ? '];
    		$data_apoio['ITEM_PROGR'] 			= $where[' ITEM_PROGR = ? '];
    		$data_apoio['NUM_ITEM']             = $select['NUM_ITEM'] +1;
    		$data_apoio['ID'] 					= null;
    		$data_apoio['EMPRESA']              = $data['EMPRESA'];
    		$data_apoio['DATA'] 				= null;
    		$data_apoio['NUMERO_CHAMADO']       = $data['NUMERO_CHAMADO'];
    		$data_apoio['DATA_ATENDIMENTO']     = null;
    		$data_apoio['NOME_CLIENTE'] 		= null;
    		$data_apoio['HORA_INICIO'] 			= null;
    		$data_apoio['HORA_FIM'] 			= null;
    		$data_apoio['HORA_INICIO2'] 		= null;
    		$data_apoio['HORA_FIM2'] 			= null;
    		$data_apoio['STATUS'] 				= null;
    		
    		$data['FECHADO'] 					= 'S';

			$table->insert($data_apoio);    		
    	}
    	
    	return parent::beforeUpdate($data,$where);
    }
    
    public function atualizar($id1,$id2,$id3)
    {
	    	$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
	    	$sql->execute();
    }
    
}
?>