<?php

class serv_Model_DbTable_Manuthoras extends Zsam_Db_Table {

	protected $_name = 'manuthoras';

	
	var $_autocomplet = array('ITEM_PROGR','NUM_ITEM','PRODUTO');

	var $_conf = array(
			'CLIENTE' 					=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'ITEM_PROGR'					=> array('edit' => 'N','grid' => true),
			'NUM_ITEM' 					=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
                        'ID'						=> array('edit' => 'N'),
			'EMPRESA' 					=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'SERVICO' 					=> array('autocomplete'=>'Y','NULLABLE' => false),
			'NATUREZA_OPERACAO'                             => array('NULLABLE' => false,'VP' => array('S' => 'servico', 'L' => "locacaoserv")),
			'TOTALITEM'					=> array('edit' => 'N'),
			'QUANTIDADE' 					=> array('title'=>'QUANTIDADE_NECESSIDADE','NULLABLE' => false),
			'PRECO'                                         => array('NULLABLE' => false,'edit'=>'S'),
			'PRECO_BASE'                                    => array('edit' => 'N'),
                        'PRECO_CUSTO'                                   => array('edit' => 'N'),
                        'PRECO_MAXIMO'                                  => array('edit' => 'N'),
                        'BAIXA'                                         => array('edit' => 'N'),
                        'DATANECESSIDADE'                               => array('edit' => 'N'),
                        'FUNC_ALTERACAO'                                => array('edit' => 'N'),
			'DATA_ALTERACAO'                                => array('edit' => 'N'),
			'REVISAO'                                       => array('edit' => 'N'),
			'DATASINC'                                      => array('edit' => 'N')
			
			
	);
	var $_referenceMap = array(
			

			'EMPRESA' => array(
					'columns' 	=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 	=> 'NOME'
			),
			
			
			'SERVICO' => array(
					'columns' 	=> 'SERVICO',
					'refTableClass' => 'serv_Model_DbTable_Servico',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 	=> 'SERVICO'
			),

	);
	public function __construct()
	{
		parent::__construct();
		
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
		
		if($nome_controller == 'ordemservico'){
			
			$this->_restrict 						= "FECHADO  = 'S'";
			$this->_conf['NUMERO_HORAS']['edit']                            = 'N';
			$this->_conf['DATA_PREVISAO_INICIO']['edit']                    = 'N';
			$this->_conf['MVS']['edit'] 					= 'N';
		}
		
		

		//$this->_restrict = "CODIGO_CLIENTE = ".$id;

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

	}
        
        public function beforeInsert(array $data){
	
            $controller      = Zend_Controller_Front::getInstance()->getRequest();
            $nome_controller = $controller->getControllerName(); //pegar a controladora

            if ($nome_controller == 'manuthoras'){

                    $total = $data['PRECO'] * $data['QUANTIDADE'];
                    $data['TOTALITEM'] = $total;

            }
            return parent::beforeInsert($data);
	}
        
         public function beforeUpdate(array $data, $where){
	
            $controller      = Zend_Controller_Front::getInstance()->getRequest();
            $nome_controller = $controller->getControllerName(); //pegar a controladora

            if ($nome_controller == 'manuthoras'){

                    $total = $data['PRECO'] * $data['QUANTIDADE'];
                    $data['TOTALITEM'] = $total;

            }
            return parent::beforeUpdate($data, $where);
	}

	public function atualizar($id1,$id2,$id3)
	{
		$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
		$sql->execute();

	}

	public function calcula_total($dados_item)
	{
		$total = 0;

		foreach ($dados_item as $key => $value)
		{

			$total 		+= $value['PRECO_TOTAL_ITEM'];
		}

		return $total;
	}

	public function getEmpresa($emp)
	{

		$table = new core_Model_DbTable_Empresa();
		$dados = $table->find($emp)->toArray();

		return $dados[0];
	}

}
?>