<?php

class serv_Model_DbTable_Manut extends Zsam_Db_Table {

    /**
     * The default table name
     */
    protected $_name 		= 'manut';
    var $_autocomplet 		= array('CLIENTE','ITEM');
    //var $regime 			= null;

    
    var $_conf = array(
    'ID'				=> array("grid"=>true,'edit' => 'N'),
    'ITEM'	         	=> array("grid"=>true,'NULLABLE' => false,'edit' => 'N'),
    'EMPRESA'           => array("grid"=>true,'NULLABLE' => false,'edit' => 'N'),
    'CLIENTE' 		 	=> array('autocomplete'=>'Y',"grid"=>true,'NULLABLE' => false,'edit' => 'N'),
    'CONTATO'           => array('NULLABLE' => false),
    'VENDEDOR'   		=> array('editlevel' => '3'),
    'DATA_ORCAMENTO'    => array('edit' => 'N'),
    'FECHAR_ORCAMENTO'  => array(),
    'DATA_PREV_ENTREGA' => array(),	
    'OBS_PREV_ENTREGA'  => array(),
    'DATA_ENTREGA' 		=> array(),
    'OBS_ENTREGA' 		=> array(),
    'VALOR_TOTAL'       => array('edit' => 'N'),
    'DATA_EXECUCAO_SERV'=> array('title' => 'DATANECESSIDADE', 'NULLABLE' => false),
    'NUMERO_NF'			=> array('edit' => 'N'),
    'DATA_NF'			=> array('edit' => 'N'),
    'VENCIMENTO'		=> array('title' => 'VENC'),
    'JUROS'         	=> array(),
    'ULTIMO_ITEM'       => array('edit' => 'N'),
    'TIPO'              => array(),
    'TIPO_R_L'			=> array(),
    'TIPO_FRETE' 		=> array('VP' => 'FOB,CIF,EXW', 'DEFAULT' => 'CIF', 'NULLABLE' => false),
    'VALOR_FRETE' 		=> array(),
    'VALOR_SEGURO' 		=> array(),
    'PRAZO_ENTREGA_DIAS'=> array('NULLABLE' => false),
    'OBSERVACAO'		=> array(),
    'OBSERVACAO_DO_SERVICO'	=> array('char_spec'=>'NONE','case'=>'NONE'),
    'REFERENCIA_CLIENTE'=> array("grid"=>true),
    'REFERENCIA_PEDIDO' => array(),
    'BAIXA'             => array(),
    'DEPARTAMENTO' 		=> array(),
    'STATUS' 			=> array(),
    'STATUS_PADRAO'		=> array(),
	'SITUACAO'        	=> array('title' => 'tem_estoque_S_sim_N_nao_K_falta_num_serie'),
    'APROVACAO'			=> array('edit' => 'N'),
        
        
    'GRID'    			=> array('type' 		=> 'itemGridAuto', //Padrão, indica o helper que monta a grid
                                                                        'configitem' 	=> 'GRID', //Indica qual campo do atributo $zsam_form_item da controladora deve ser usado			  
                                                                        'model' 	=> 'serv_Model_DbTable_Manutitem', //Model do filho
                                                                        //Colunas que aparecerão na grid
                                                                        'columns' 	=> array('NUM_ITEM','PRODUTO','NATUREZA_OPERACAO','QUANTIDADE','PRECO_UNITARIO','PRECO_TOTAL_ITEM'),
                                                                        'idWhere' 	=> array('CLIENTE','ITEM_PROGR'),//Chave primária sem o campo "auto increment"
                                                                        'buttons'	=> array('edit'=>'S', 'del' => 'S')),//Configuração dos botões da grid

    	
    'GRID1'    			=> array('type' 		=> 'itemGridAuto',
                                                                        'configitem' 	=> 'GRID1',
                                                                        'model' 	=> 'serv_Model_DbTable_Manuthoras',
                                                                        'columns' 	=> array('NUM_ITEM','SERVICO','NATUREZA_OPERACAO','QUANTIDADE','PRECO','TOTALITEM'),
                                                                        'idWhere' 	=> array('CLIENTE','ITEM_PROGR'),
                                                                        'buttons'	=> array('edit'=>'S', 'del' => 'S')),

	'GRID2'    			=> array('type'                 => 'itemGridAuto',
                                                                        'configitem' 	=> 'GRID2',
                                                                        'model'         => 'serv_Model_DbTable_Manutsitesurvey',
                                                                        'columns' 	=> array('CLIENTE','ITEM_PROGR','NUM_ITEM','NUMERO_CHAMADO','DATA','DATA_ATENDIMENTO'),
                                                                        'idWhere' 	=> array('CLIENTE','ITEM_PROGR'),
                                                                        'buttons'	=> array('edit'=>'S', 'del' => 'S')),

	'FUNC_ALTERACAO' 	=> array('edit' => 'N'),
	'DATA_ALTERACAO' 	=> array('edit' => 'N'),
	'REVISAO'        	=> array('edit' => 'N'),
	'DATASINC'       	=> array('edit' => 'N'),
	);
    var $_referenceMap = array(
        'EMPRESA' => array(
            'columns'       => 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'NOME'
        ),
        'CLIENTE' => array(
            'columns'       => 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'CLIENTE'
        ),
        'CONDICOES_GERAIS' => array(
            'columns'       => 'CONDICOES_GERAIS',
            'refTableClass' => 'core_Model_DbTable_Obsvendas',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'CONDICOES_GERAIS'
        ),

		'VENDEDOR' => array(
            'columns'       => 'VENDEDOR',
            'refTableClass' => 'core_Model_DbTable_Usuario',
            'refColumns'    => 'ID',
            'refTitle'      => 'VENDEDOR'
    	),

    	'VENCIMENTO' => array(
            'columns'       => 'VENCIMENTO',
            'refTableClass' => 'core_Model_DbTable_Vencimento',
            'refColumns'    => 'ID',
            'refTitle'      => 'VENC'
    	),

    	'CONTATO' => array(
            'columns'       => 'CONTATO',
            'refTableClass' => 'core_Model_DbTable_Clientecontatoitem',
            'refColumns'    => 'ID',
            'refTitle'      => 'CONTATO',
    	    'semChave'      => 'S'    //neste caso � quando temos uma chave primaria composta e incluimos o ID para poder fazer orelacionamento
										//porem o ID n�o � chave primaria e portanto no zsam form simple (linha +-103) desabilitamos o validador do zend para chave primaria
		),

    	'DEPARTAMENTO' => array(
            'columns'       => 'DEPARTAMENTO',
            'refTableClass' => 'core_Model_DbTable_Depto',
            'refColumns'    => 'DEPARTAMENTO',
            'refTitle'      => 'DEPARTAMENTO'
    	),

    	'STATUS_PADRAO' => array(
            'columns'       => 'STATUS_PADRAO',
            'refTableClass' => 'core_Model_DbTable_Obsprogr',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'STATUS_PADRAO'
    	),

    	'GRID' => array(
            'columns'       => 'ITEM_PROGR',
            'refTableClass' => 'serv_ManutitemController',
            'refColumns'    => 'ITEM_PROGR',
            'refTitle'      => 'ITEM'
    	),
    		
    	'GRID' =>  array(
            'columns'       => 'ITEM_PROGR',
            'refTableClass' => 'serv_Model_DbTable_Manutitem',
            'refColumns'    => 'ITEM_PROGR',
            'refTitle'      => 'ITEM'
    	),
    		 
    	'GRID1' =>  array(
            'columns'       => 'ITEM_PROGR',
            'refTableClass' => 'serv_Model_DbTable_Manuthoras',
            'refColumns'    => 'ITEM_PROGR',
            'refTitle'      => 'ITEM'
    		),
    		
    	'GRID2' =>  array(
            'columns'       => 'ITEM_PROGR',
            'refTableClass' => 'serv_Model_DbTable_Manutsitesurvey',
            'refColumns'    => 'ITEM_PROGR',
            'refTitle'      => 'ITEM'
    	)

    );
    public function __construct() {
        $this->config = Zend_Registry::get('Cisweb_Config');
        $controller = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action = $controller->getActionName(); //pegar a controladora

        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            $user = $auth->getStorage()->read();
            $funcao = @$user['FUNCAO'];
            $id = @$user['ID'];
            $nome = @$user['NOME'];
            $level = @$user['NIVEL'];
            $acessorestrito = @$user['ACESSORESTRITO'];
        }

        if ($level < 3 && $this->config[0]['VENDEDOR_POR_CLIENTE_RESTRICT'] != 'N') {
            $this->_restrict = "(FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O') AND VENDEDOR =" . $id;
        } else {
            $this->_restrict = "FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
        }

		$config_modulos = new Cisweb_Db_Abstract('config_modulos');
		$dados_modulos  = $config_modulos->fetchRow()->toArray();
		if ($acessorestrito == 'S' && $dados_modulos['USAR_ACESSO_RESTRITO'] == 'S' ){//neste caso tem o mesmo nível de um nivel 3
		    $this->_restrict = " FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
		}

        if ($nome_controller == 'manut') {
            $this->_conf['DEPARTAMENTO']['NULLABLE'] = FALSE;

            if ($nome_action == 'upd') {
                $table = new Cisweb_Db_Abstract("manut");
                $venc = new Cisweb_Db_Abstract("venc");

                $id = $controller->getParam("id");
                $id = explode(":", $id);
                $id1 = $id[0];
                $id2 = $id[1];
                $dados = $table->getAdapter()->fetchRow($table->select()->where("CLIENTE = '$id1' AND ITEM = '$id2'"));

                if ($dados['VENCIMENTO'] != '') {

                    $this->_conf['VENCIMENTO']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S' or ID = '{$dados['VENCIMENTO']}'";
                } else {

                    $this->_conf['VENCIMENTO']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S'";
                }

                if ($dados['PROGRAMA'] == 'P') {

                    $this->_conf['GRID']['buttons'] = "N";
                }
                
                if ($dados['SERVICO'] == 'P') {

                    $this->_conf['GRID1']['buttons'] = "N";
                }
                
                if ($dados['LOCACAO'] == 'P') {

                    $this->_conf['GRID']['buttons'] = "N";
                }
                
                if ($dados['LOCACAOSERV'] == 'P') {

                    $this->_conf['GRID1']['buttons'] = "N";
                }
            }
        }

        if ($nome_controller == 'impressaoormclientemanut') {
            $this->_restrict = "TIPO = 'O' AND FECHAR_ORCAMENTO = 'S' ";
            $this->_conf['DATA_ORCAMENTO']['grid'] = true;
        }

        if ($nome_controller == 'impressaopedidoclientemanut') {
            $this->_restrict = "TIPO = 'P'";
            $this->_conf['DATA_ORCAMENTO']['grid'] = true;
            $this->_conf['REFERENCIA_CLIENTE']['grid'] = false;
            $this->_conf['REFERENCIA_PEDIDO']['grid'] = true;
            $this->_conf['PROGRAMA']['grid'] = true;
            $this->_conf['LOCACAO']['grid'] = true;
            $this->_conf['SERVICO']['grid'] = true;
            $this->_conf['LOCACAOSERV']['grid'] = true;
        }

        parent::__construct();
    }
    
    public function beforeInsert(array $data) {
        if (is_null($data['TIPO']) || $data['TIPO'] == '') {
            $data['TIPO'] = 'O';
        }
        return parent::beforeInsert($data);
    }

    public function beforeDelete($where) {

        $cli = $where[' CLIENTE = ? '];
        $num = $where[' ITEM = ? '];

        $this->deleteCascade($cli, $num);

        return parent::beforeDelete($where);
    }

    public function deleteCascade($cliente,$item){

        $table 		= new serv_Model_DbTable_Manutitem();
    	$adapter 	= $table->getAdapter();
    	$where 		= $adapter->quoteInto('CLIENTE = ?', $cliente).' AND '.$adapter->quoteInto(' ITEM_PROGR = ?', $item);
    	$table->delete($where);
        
        $table 		= new serv_Model_DbTable_Manuthoras();
    	$adapter 	= $table->getAdapter();
    	$where 		= $adapter->quoteInto('CLIENTE = ?', $cliente).' AND '.$adapter->quoteInto(' ITEM_PROGR = ?', $item);
    	$table->delete($where);
        
        $table 		= new serv_Model_DbTable_Manutsitesurvey();
    	$adapter 	= $table->getAdapter();
    	$where 		= $adapter->quoteInto('CLIENTE = ?', $cliente).' AND '.$adapter->quoteInto(' ITEM_PROGR = ?', $item);
    	$table->delete($where);
   }
}
?>