<?php

class serv_Model_DbTable_Locacaointer extends Zsam_Db_Table {

	protected $_name = 'locacaointer';

	var  $_restrict 	= null;
	var  $_autocomplet  = array( 'NUMERO', 'EMPRESA', 'NOME_CLI');

	public function __construct()
	{
		$this->config  = Zend_Registry::get('Cisweb_Config');
		parent::__construct();

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action 	 = $controller->getActionName(); //pegar a controladora

	    $auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
			$level  = @$user['NIVEL'];
            $acessorestrito = @$user['ACESSORESTRITO'];
		}

		if ($level < 3 && $this->config[0]['VENDEDOR_POR_CLIENTE_RESTRICT'] != 'N') {
		    $this->_restrict = "(FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O') AND VENDEDOR = '$id'";
		} else {
		    $this->_restrict = " FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
		}

		$config_modulos = new Cisweb_Db_Abstract('config_modulos');
		$dados_modulos  = $config_modulos->fetchRow()->toArray();
		if ($acessorestrito == 'S' && $dados_modulos['USAR_ACESSO_RESTRITO'] == 'S' ){//neste caso tem o mesmo nível de um nivel 3
		    $this->_restrict = " FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
		}

		if($nome_controller == 'impressaoormclientelocacaointer')
		{
		    $this->_restrict = "(TIPO = 'O' OR TIPO = 'C') AND FECHAR_ORCAMENTO = 'S' ";
		    $this->_conf['DATA_ORCAMENTO']['grid'] = true;
		}

		if($nome_controller == 'impressaopedidoclientelocacaointer')
		{
		    $this->_restrict = "TIPO = 'P'";
		    $this->_conf['DATA_ORCAMENTO']['grid'] = true;
		}

		if($nome_controller == 'impressaocontratointer')
		{
		    $this->_restrict = "TIPO = 'P'";
		}

		if($nome_controller == 'locacaoparaenviarinter')
		{
		    $this->_restrict = "TIPO = 'P' AND  (BAIXA <> 'B' OR BAIXA IS NULL)";
		}

		if($nome_controller == 'locacaoparaenviarsemestoque')
		{
		    $this->_restrict = "TIPO = 'P' AND (SITUACAO = 'N') AND (BAIXA <> 'B' OR BAIXA IS NULL)";
		}

		if($nome_controller == 'locacaointergerenciar'){

		    $this->_restrict = NULL;

		    $this->_conf['CLIENTE']['edit']						= "S";
		    $this->_conf['DATA']['edit'] 						= "S";
		}

		if($nome_controller == 'locacaocontratointer'){

		    $this->_restrict = "TIPO = 'C'";
		    $this->_conf										= array();
		    $this->_conf['ID']['edit'] 							= "N";
		    $this->_conf['NUMERO']['edit'] 						= "N";
		    $this->_conf['NOME_CLI']['edit'] 					= "N";
		    $this->_conf['CNPJ_CLI']['edit'] 					= "N";
		    $this->_conf['IE_CLI']['edit'] 						= "N";
		    $this->_conf['DATA']['edit'] 						= "N";
		    $this->_conf['TOTAL']['edit'] 						= "N";
		    $this->_conf['FORMA_ENVIO']['edit'] 				= "N";
		    $this->_conf['TIPO']['edit'] 						= "N";
		    $this->_conf['REFERENCIA_CLIENTE']['edit'] 			= "N";
		    $this->_conf['PRAZO_LOCACAO']['edit'] 				= "N";
		    $this->_conf['TIPO_PRAZO_LOCACAO']['edit'] 			= "N";
		    $this->_conf['PRAZO_ENTREGA_DIAS']['edit'] 			= "N";
		    $this->_conf['TIPO_PAGAMENTO']['edit'] 				= "N";
		    $this->_conf['DIAVENC']['edit'] 					= "N";
		    $this->_conf['LOCAL_UTILIZACAO']['edit'] 			= "N";
		    $this->_conf['LOCAL_ENTREGA']['edit'] 				= "N";
		    $this->_conf['DATA_INICIO_CONTRATO']['edit'] 		= "N";
		    $this->_conf['DATA_FINAL_CONTRATO']['edit'] 		= "N";
		    $this->_conf['GRID'] 								= array('type' => 'itemGrid', 
															    		'model' => 'serv_Model_DbTable_Locacaocontratoitem', 
															    		'controller' => 'serv_LocacaocontratoitemController',
															    		'columns' => array('NUMERO','EMPRESA','ITEM','SERVICO','DESCRICAO'),
															    		'idWhere' => array('NUMERO','EMPRESA'));
		    if($nome_action == 'upd'){
		    	$this->_conf['EMPRESA']['edit']						= "N";
		    	$this->_conf['CLIENTE']['edit'] 					= "N";
		    	$this->_conf['VENDEDOR']['edit']					= "N";
		    }
		}
        
        if($nome_controller == 'pedidolocacaointer')
		{
            
            $this->_restrict = "TIPO = 'P' AND BAIXA IS NULL";
            $this->_conf['DEPARTAMENTO']['edit'] = 'N';
            $this->_conf['GRID']['buttons'] = array('insert' => 'N', 'edit' => 'N', 'rem' => 'N');
            
            $this->_conf['GRID2'] = array('type' 		=> 'itemGridAuto',
                                          'configitem' 	=> 'GRID2',
                                          'model'       => 'serv_Model_DbTable_Ordemservico',
                                          'columns'     => array('SERVICO', 'EMPRESA','ITEM','NUMERO_CHAMADO','DATA_I','DATA_ATENDIMENTO'),//serão mostradas na grid
                                          'idWhere'  	=> array('SERVICO', 'EMPRESA'),
                                          'buttons'		=> array('edit'=>'S', 'del' => 'S'));
            
            $this->_referenceMap['GRID2'] = array(
                'columns' 		=> 'NUMERO',
                'refTableClass' => 'serv_Model_DbTable_Ordemservico',
                'refColumns' 	=> 'NUMERO',
                'refTitle' 		=> 'ITEM'
            );
		}
        
        if($nome_controller == 'reprovaiteminter'){
            $this->_restrict = "TIPO = 'O'";
        }
	}

 	var $_conf = array(

 	        'ID'					=> array('edit'=>'N'),
 			'NUMERO' 				=> array("grid"=>true,'NULLABLE' => false,'edit'=>'N'),
        	'EMPRESA' 				=> array("grid"=>true, 'NULLABLE' => false,'edit'=>'N'),
            'DATA' 					=> array("grid"=>true,'edit'=>'N'),
            'CLIENTE' 				=> array('edit'=>'N','autocomplete'=>'Y',"grid"=>true, 'NULLABLE' => false,'help'=>'help_digite_para_pesquisar'),
            'CONTATO' 				=> array('NULLABLE' => false),
            'NOME_CLI'				=> array('edit'=>'N'),
            'CNPJ_CLI'				=> array('edit'=>'N'),
            'IE_CLI'				=> array('edit'=>'N'),
			'NFSPAPEL_MODELO'		=> array('NULLABLE' => false),
			'FATURA_MODELO'			=> array(),
 	        'VENDEDOR'				=> array('edit'=>'N'),
            'DATA_ORCAMENTO'		=> array(),
			'DATA_PEDIDO'			=> array(),
 	        'LOCAL_UTILIZACAO'		=> array(),
 	        'LOCAL_ENTREGA' 		=> array(),
            'DIAVENC'				=> array('VP' => array( '1'  => '1'  ,'2'  =>   '2','3'  =>  '3' ,'4'  =>  '4' ,'5'  =>  '5' ,'6'  =>  '6' ,'7'  =>  '7' ,'8'  =>  '8' ,'9'  =>  '9',
		            										        	'10' =>  '10','11' =>  '11','12' =>  '12','13' =>  '13','14' =>  '14','15' =>  '15','16' =>  '16','17' =>  '17','18' =>  '18',
		                    											'19' =>  '19','20' =>  '20','21' =>  '21','22' =>  '22','23' =>  '23','24' =>  '24','25' =>  '25','26' =>  '26','27' =>  '27','28' =>  '28','29' =>  '29','30' =>  '30','31' =>  '31'),'NULLABLE' => false),
            'FECHAR_ORCAMENTO'		=> array('edit'=>'N'),
            'TOTAL' 				=> array('edit'=>'N'),
            'IMPRESSAO'				=> array('edit'=>'N'),
            'SITUACAO'				=> array('edit'=>'N'),
            'TIPO'					=> array('edit'=>'N'),
 			'REFERENCIA_CLIENTE' 	=> array('grid'=>true),
 			'REFERENCIA_LOCACAO' 	=> array(),
 			'VENCIMENTO' 			=> array(),
            'FORMA_ENVIO' 			=> array('VP'=> array('C' => 'COB_CARTEIRA', 'S' => 'BOLETO_SEMREGISTRO','R' => 'BOLETO_COMREGISTRO'),'NULLABLE' => false),
          	'BANCO' 				=> array(),
 			'CONTRATO'				=> array('edit' => 'N'),
 			'DATA_INICIO_CONTRATO'	=> array('NULLABLE' => false),
 	        'DATA_FINAL_CONTRATO'	=> array('edit'=>'N'),
 			'APROVACAO'				=> array(),
 			'PRAZO_ENTREGA_DIAS'	=> array(),
 			'TIPO_PRAZO_LOCACAO'	=> array('VP' => array('MESES' => 'MESES', 'DIAS' => 'DIAS'), 'NULLABLE' => false),
 	        'PRAZO_LOCACAO'			=> array('NULLABLE' => false),
 			'OBSERVACAO_PRAZO_ENTREGA'=> array(),
 	        'BT_NF'					=> array(),
		 	'BT_FATURA'				=> array(),
		 	'BT_CONTRATO'			=> array(),
		 	'BT_DUPLI'				=> array(),
		 	'MES_ANO_ULTIMA_NFSPAPEL'	=> array(),
		 	'NUMERO_NF'				=> array(),
		 	'DATA_NF'				=> array(),
 			'TIPO_PAGAMENTO'		=> array('VP' => array('PREPAGO' => 'Pre-Pago', 'POSPAGO' => 'Pos-Pago'),'NULLABLE' => false),
 			'BAIXA' 				=> array('edit'=>'N'),
 			'DEPARTAMENTO' 			=> array('NULLABLE' => false),
 			'STATUS'		 		=> array('grid' => true),
 			'FUNC_ALTERACAO' 		=> array('edit'=>'N'),
           	'DATA_ALTERACAO' 		=> array('edit'=>'N'),
            'REVISAO' 				=> array('edit'=>'N'),
 			'DATASINC' 				=> array(),
            'GRID' 					=> array(
											'type' 			=> 'itemGridAuto', 
											'configitem'	=> 'GRID',
											'model' 		=> 'serv_Model_DbTable_Locacaointeritem', 
											'columns'		=> array('NUMERO','EMPRESA','ITEM','SERVICO','DESCRICAO'),
											'idWhere'		=> array('NUMERO','EMPRESA')
										)
            );

        var $_referenceMap = array(

        'EMPRESA' => array(
            'columns' 		=> 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'EMPRESA'
        ),

        'NFSPAPEL_MODELO' => array(
            'columns' 		=> 'NFSPAPEL_MODELO',
            'refTableClass' => 'serv_Model_DbTable_Nfspapelmodelo',
            'refColumns' 	=> 'ID_NFPAPEL',
            'refTitle' 		=> 'NFSPAPEL_MODELO'
        ),

        'CLIENTE' => array(
            'columns' 		=> 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'CLIENTE'
        ),

    	'CONTATO' => array(
            'columns'           => 'CONTATO',
            'refTableClass'     => 'core_Model_DbTable_Clientecontatoitem',
            'refColumns'        => 'ID',
            'refTitle'          => 'CONTATO',
    	    'semChave'			=> 'S'    //neste caso � quando temos uma chave primaria composta e incluimos o ID para poder fazer orelacionamento
										//porem o ID n�o � chave primaria e portanto no zsam form simple (linha +-103) desabilitamos o validador do zend para chave primaria
		),

        'BANCO' => array(
            'columns' 		=> 'BANCO',
            'refTableClass' => 'core_Model_DbTable_Banco',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'BANCO'
        ),

		'VENDEDOR' => array(
			'columns'           => 'VENDEDOR',
			'refTableClass'     => 'core_Model_DbTable_Usuario',
			'refColumns'        => 'ID',
			'refTitle'          => 'VENDEDOR'
		),

		'CONTRATO' => array(
			'columns' 		=> 'CONTRATO',
			'refTableClass' => 'serv_Model_DbTable_Locacaointer',
			'refColumns' 	=> 'ID',
			'refTitle' 		=> 'CONTRATO',
			'semChave'		=> 'S'
		),

        'OBSLOCACAOCORPO' => array(
            'columns' 		=> 'OBSLOCACAOCORPO',
            'refTableClass' => 'serv_Model_DbTable_Obsfatura',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'OBSLOCACAOCORPO'
        ),
        'OBSLOCACAO' => array(
            'columns' 		=> 'OBSLOCACAO',
            'refTableClass' => 'serv_Model_DbTable_Obsfatura',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'OBSLOCACAO'
        ),
        'OBSLOCACAORODAPE' => array(
            'columns' 		=> 'OBSLOCACAORODAPE',
            'refTableClass' => 'serv_Model_DbTable_Obsfatura',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'OBSLOCACAORODAPE'
        ),

        'DEPARTAMENTO' => array(
        	'columns'           => 'DEPARTAMENTO',
        	'refTableClass'     => 'core_Model_DbTable_Depto',
        	'refColumns'        => 'DEPARTAMENTO',
        	'refTitle'          => 'DEPARTAMENTO'
        ),

        'GRID' => array(
            'columns' 		=> 'NUMERO',
            'refTableClass' => 'serv_Model_DbTable_Locacaointeritem',
            'refColumns' 	=> 'NUMERO',
            'refTitle' 		=> 'ITEM'
        )

    );

    public function beforeInsert(array $data)
	{

	    $controller      = Zend_Controller_Front::getInstance()->getRequest();
	    $nome_controller = $controller->getControllerName(); //pegar a controladora

	    $table		= new core_Model_DbTable_Empresa();
		$where  	= "CODIGO = ".$data['EMPRESA'];
		$campos 	= $table->getAdapter()->fetchAll($table->select()->where($where));
		$soma 		= @$campos[0]['ULTIMA_LOCACAO_INTER']+1;
		$data_emp 	= array('ULTIMA_LOCACAO_INTER'=>$soma);

		$table->update($data_emp,$where); // atualiza a tabela empresa antes de inserir a fatura

		$data['NUMERO']	= $soma; // recebe o num da fatura da tabela empresa
		$date			= date('Y-m-d');
		$data['DATA'] 	= $date;

		if($nome_controller == 'locacaocontratointer'){
			$data['TIPO'] 	= 'C';
		}else{
		    $data['TIPO'] 	= 'O';
		}

		return parent::beforeInsert($data);
    }

    public function deleteCascade($id,$emp){

    	$controller 		= Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller 	= $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

    	$table 		= new serv_Model_DbTable_Locacaointeritem();
		$adapter 	= $table->getAdapter();
		$where 		= $adapter->quoteInto('NUMERO = ?', $id).' AND '.$adapter->quoteInto('EMPRESA = ?', $emp);
		$table->delete($where);
    }
	
    public function totalizaLocacaoInterGeral(){

    	$table  	  = new Cisweb_Db_Abstract("locacaointer");
    	$table_itens  = new Cisweb_Db_Abstract("locacaointeritens");

    	$select 	  = $table->select()->where("TIPO  = 'P'")
    	->where("FECHAR_ORCAMENTO = 'S'");

    	$dados  	  = $table->fetchAll($select)->toArray();


    	foreach($dados as $k => $v){

    		$empresa 		= $v['EMPRESA'];
    		$numero  		= $v['NUMERO'];

    		$select			= $table_itens->select()->where("NUMERO = ?",$numero)
													->where("EMPRESA = ?",$empresa)
													->from($table_itens,"SUM(TOTALITEM)");

    		$dados_itens    = $table_itens->fetchAll($select);
			if (count($dados_itens > 0)){
				$dados_itens = $dados_itens->toArray();
				$data['TOTAL'] = $dados_itens[0]['SUM(TOTALITEM)'];
			}else{
				$data['TOTAL'] = 0;
			}
			
			$where 		   = "NUMERO = '$numero' AND EMPRESA = '$empresa'";
			$table->update($data, $where);

    	}
    }
}

?>