<?php

class serv_Model_DbTable_Locacao extends Zsam_Db_Table {

	protected $_name = 'locacao';

	var  $_restrict 		= null;
	var  $_autocomplet  = array('NUMERO', 'EMPRESA', 'NOME_CLI');

	public function __construct()
	{
		$this->config  = Zend_Registry::get('Cisweb_Config');

		parent::__construct();

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action 	 = $controller->getActionName(); //pegar a controladora

	    $auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
			$level  = @$user['NIVEL'];
            $acessorestrito = @$user['ACESSORESTRITO'];
		}

		if ($level < 3 && $this->config[0]['VENDEDOR_POR_CLIENTE_RESTRICT'] != 'N') {
		    $this->_restrict = "(FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O') AND VENDEDOR = '$id'";
		} else {
		    $this->_restrict = " FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
		}

		$config_modulos = new Cisweb_Db_Abstract('config_modulos');
		$dados_modulos  = $config_modulos->fetchRow()->toArray();
		if ($acessorestrito == 'S' && $dados_modulos['USAR_ACESSO_RESTRITO'] == 'S' ){//neste caso tem o mesmo nível de um nivel 3
		    $this->_restrict = " FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
		}
		
		if($nome_controller == 'impressaoormclientelocacao')
		{
		    $this->_restrict = "(TIPO = 'O' OR TIPO = 'C') AND FECHAR_ORCAMENTO = 'S' ";
		    $this->_conf['DATA_ORCAMENTO']['grid'] = true;
		}

		if($nome_controller == 'impressaopedidoclientelocacao')
		{
		    $this->_restrict = "TIPO = 'P'";
		    $this->_conf['DATA_ORCAMENTO']['grid'] = true;
		}

		if($nome_controller == 'impressaocontrato')
		{
		    $this->_restrict = "TIPO = 'P'";
		}

		if($nome_controller == 'locacaoparaenviar')
		{
		    $this->_restrict = "TIPO = 'P' AND (locacao.SITUACAO = 'S' OR locacao.SITUACAO = 'K') AND (BAIXA <> 'B' OR BAIXA IS NULL)";
		    $this->_conf['STATUS']['grid']		= true;
		    $this->_conf['TOTAL']['grid']		= true;
		    $this->totalizaLocacaoGeral();
		}

		if($nome_controller == 'ativoentrada' || $nome_controller == 'ativoentradadivide')
		{
		    $this->_restrict 	= "TIPO = 'P'";
		    $this->_autocomplet = array("NUMERO","EMPRESA","NOME_CLI");
		}

		if($nome_controller == 'locacaoparaenviarsemestoque')
		{
		    $this->_restrict = "TIPO = 'P' AND (SITUACAO = 'N') AND (BAIXA <> 'B' OR BAIXA IS NULL)";
		    $this->_conf['STATUS']['grid']		= true;
		    $this->totalizaLocacaoGeral();
		}

		if($nome_controller == 'relatoriolocacao'){
			$this->totalizaLocacao();
		}

		if($nome_controller == 'locacaogerenciar'){


			$dia	  			= date("d");
			$mes 	  			= date("m");
			$ano 	  			= date("Y");
			$k = 6;
			$datahoje 	= date("Y-m-01",time()+(61*86400));// soma 61 dias pega o dia primeiro
			$this->_restrict = null;
//		    $this->_restrict = "BAIXA <> 'B' OR BAIXA IS NULL";

			$this->_conf['FATURA_MODELO']['edit']			= "S";
			$this->_conf['FATURA_MODELO']['editlevel']		= 3;
			$this->_conf['DATA_ORCAMENTO']['edit']			= "N";
			$this->_conf['LOCAL_UTILIZACAO']['edit']		= "S";
			$this->_conf['RESP_FREQUENCIA']['edit']			= "S";
			$this->_conf['LOCAL_ENTREGA']['edit']			= "N";
			$this->_conf['REPRESENTANTE']['edit']			= "N";
			$this->_conf['CODVENC']['edit']					= "N";
			$this->_conf['VENCIMENTO']['edit']				= "N";
			$this->_conf['FORMA_ENVIO']['edit']				= "S";
			$this->_conf['BANCO']['edit']					= "S";
			$this->_conf['BANCO']['editlevel']				= 3;
			$this->_conf['BANCO']['NULLABLE']				= false;
			$this->_conf['DATA_INICIO_CONTRATO']['edit']	= "N";
			$this->_conf['DATA_FINAL_CONTRATO']['edit']		= "S";
			$this->_conf['DATA_FINAL_CONTRATO']['grid']		= true;
	        $this->_conf['VENDEDOR']['edit'] 				= "S";
			$this->_conf['VENDEDOR']['editlevel']			= 3;
			$this->_conf['APROVACAO']['edit']				= "N";
			$this->_conf['TIPO_FRETE']['edit']				= "N";
			$this->_conf['VALOR_FRETE']['edit']				= "N";
			$this->_conf['VALOR_SEGURO']['edit']			= "N";
			$this->_conf['PRAZO_ENTREGA_DIAS']['edit']		= "N";
			$this->_conf['TIPO_PRAZO_LOCACAO']['edit']		= "S";
			$this->_conf['PRAZO_LOCACAO']['edit']			= "S";
			$this->_conf['OBSERVACAO_PRAZO_ENTREGA']['edit']= "N";
			$this->_conf['MES_ANO_ULTIMA_FATURA']['edit']	= "S";
			$this->_conf['MES_ANO_ULTIMA_FATURA']['editlevel']	= 3;
			$this->_conf['TIPO_PAGAMENTO']['edit']			= "S";
			$this->_conf['DEPARTAMENTO']['edit']			= "S";
 		}

		if($nome_controller == 'locacaocontrato'){

			$this->_restrict = "TIPO = 'C'";

		    $this->_conf										= array();
		    $this->_conf['ID']['edit'] 							= "N";
		    $this->_conf['NUMERO']['edit'] 						= "N";
		    $this->_conf['NUMERO']['edit'] 						= "N";
		    $this->_conf['CNPJ_CLI']['edit'] 					= "N";
		    $this->_conf['NOME_CLI']['edit'] 					= "N";
		    $this->_conf['IE_CLI']['edit'] 						= "N";
		    $this->_conf['DATA']['edit'] 						= "N";
		    $this->_conf['TOTAL']['edit'] 						= "N";
		    $this->_conf['FORMA_ENVIO']['edit'] 				= "N";
		    $this->_conf['TIPO']['edit'] 						= "N";
		    $this->_conf['TIPO_FRETE']['edit'] 					= "N";
		    $this->_conf['PRAZO_LOCACAO']['edit'] 				= "N";
		    $this->_conf['REFERENCIA_CLIENTE']['edit'] 			= "N";
		    $this->_conf['TIPO_PRAZO_LOCACAO']['edit'] 			= "N";
		    $this->_conf['PRAZO_ENTREGA_DIAS']['edit'] 			= "N";
		    $this->_conf['TIPO_PAGAMENTO']['edit'] 				= "N";
		    $this->_conf['DIAVENC']['edit'] 					= "N";
		    $this->_conf['LOCAL_UTILIZACAO']['edit'] 			= "N";
		    $this->_conf['LOCAL_ENTREGA']['edit'] 				= "N";
		    $this->_conf['RESP_FREQUENCIA']['edit'] 			= "N";
		    $this->_conf['DATA_INICIO_CONTRATO']['edit'] 		= "N";
		    $this->_conf['DATA_FINAL_CONTRATO']['edit'] 		= "N";
		    $this->_conf['GRID'] 								= array('type' => 'itemGrid',
															    		'model' => 'serv_Model_DbTable_Locacaocontratoitem',
															    		'controller' => 'serv_LocacaocontratoitemController',
															    		'columns' => array('NUMERO','EMPRESA','ITEM','PRODUTO','DESCRICAO'),
															    		'idWhere' => array('NUMERO','EMPRESA'));
		    if($nome_action == 'upd'){
			    $this->_conf['EMPRESA']['edit']						= "N";
			    $this->_conf['CLIENTE']['edit'] 					= "N";
			    $this->_conf['VENDEDOR']['edit']					= "N";
		    }
		}
        
        if($nome_controller == 'reprovaitemlocacao'){
            $this->_restrict = "TIPO = 'O'";
        }
	}

 	var $_conf = array(
 	        'ID'					=> array('edit'=>'N'),
 			'NUMERO' 				=> array("grid"=>true,'NULLABLE' => false,'edit'=>'N'),
        	'EMPRESA' 				=> array("grid"=>true, 'NULLABLE' => false,'edit'=>'N'),
            'DATA' 					=> array("grid"=>true,'edit'=>'N'),
            'CLIENTE' 				=> array('edit'=>'N','autocomplete'=>'Y',"grid"=>true, 'NULLABLE' => false,'help'=>'help_digite_para_pesquisar'),
            'CONTATO' 				=> array('NULLABLE' => false),
            'NOME_CLI'				=> array('edit'=>'N'),
            'CNPJ_CLI'				=> array('edit'=>'N'),
            'IE_CLI'				=> array('edit'=>'N'),
            'FATURA_MODELO'			=> array('NULLABLE' => false),
 	        'VENDEDOR'				=> array('edit'=>'N'),
            'DATA_ORCAMENTO'		=> array(),
 	        'LOCAL_UTILIZACAO'		=> array(),
 	        'LOCAL_ENTREGA' 		=> array(),
 	        /*Caso for preciso alterar o VP de Resp Frequencia, alterar tamb�m o Simple Cisweb no m�todo contratopadraoAction()*/
            'DIAVENC'				=> array('VP' => array( '1'  => '1'  ,'2'  =>   '2','3'  =>  '3' ,'4'  =>  '4' ,'5'  =>  '5' ,'6'  =>  '6' ,'7'  =>  '7' ,'8'  =>  '8' ,'9'  =>  '9',
           										        	'10' =>  '10','11' =>  '11','12' =>  '12','13' =>  '13','14' =>  '14','15' =>  '15','16' =>  '16','17' =>  '17','18' =>  '18',
		                    								'19' =>  '19','20' =>  '20','21' =>  '21','22' =>  '22','23' =>  '23','24' =>  '24','25' =>  '25','26' =>  '26','27' =>  '27','28' =>  '28','29' =>  '29','30' =>  '30','31' =>  '31')),
 	        'RESP_FREQUENCIA'		=> array('VP'=> array(1 => 'Aluguel com frequencia responsabilidade da Locadora',
 	                									  2 => 'Aluguel com frequencia responsabilidade do Locatario'
 	                						)),
            'FECHAR_ORCAMENTO'		=> array('edit'=>'N'),
            'TOTAL' 				=> array('edit'=>'N'),
            'IMPRESSAO'				=> array('edit'=>'N'),
            'SITUACAO'				=> array('edit'=>'N'),
			'TIPO'					=> array('edit'=>'N'),
            'REFERENCIA_CLIENTE'	=> array('edit'=>'N'),
            'REFERENCIA_LOCACAO'	=> array('edit'=>'N'),
 			'REPRESENTANTE'			=> array(),
 			'CODVENC' 				=> array('title'=>'VENC'),
 			'VENCIMENTO' 			=> array(),
            'FORMA_ENVIO' 			=> array('VP'=> array('C' => 'COB_CARTEIRA', 'S' => 'BOLETO_SEMREGISTRO','R' => 'BOLETO_COMREGISTRO'),'NULLABLE' => false),
          	'BANCO' 				=> array(),
 			'CONTRATO'				=> array('edit' => 'N'),
 			'DATA_INICIO_CONTRATO'	=> array('NULLABLE' => false),
 	        'DATA_FINAL_CONTRATO'	=> array('edit'=>'N'),
 			'APROVACAO'				=> array(),
			'TIPO_FRETE' 			=> array('VP' => array('CIF'=>'CIF','FOB'=>'FOB','EXW'=>'EXW'), 'NULLABLE' => false),
			'VALOR_FRETE' 			=> array(),
			'VALOR_SEGURO' 			=> array(),
 			'PRAZO_ENTREGA_DIAS'	=> array(),
 			'TIPO_PRAZO_LOCACAO'	=> array('VP' => array('MESES' => 'MESES', 'DIAS' => 'DIAS', "INDET" => "Indeterminado"), 'NULLABLE' => false),
 	        'PRAZO_LOCACAO'			=> array('NULLABLE' => false, 'help'=>'999 para Indeterminado'),
 			'OBSERVACAO_PRAZO_ENTREGA'=> array("grid"=>true,),
 	        'BT_NF'					=> array(),
 	        'BT_NFS'				=> array(),
		 	'BT_FATURA'				=> array(),
		 	'BT_CONTRATO'			=> array(),
		 	'BT_DUPLI'				=> array(),
 	        'MES_ANO_ULTIMA_FATURA'	=> array('edit'=>'N'),
 			'TIPO_PAGAMENTO'		=> array('VP' => array('PREPAGO' => 'Pre-Pago', 'POSPAGO' => 'Pos-Pago')),
 			'BAIXA' 				=> array('edit'=>'N'),
 			'NUMERO_NF' 			=> array("grid"=>true,'edit'=>'N'),
 			'DATA_NF' 				=> array('edit'=>'N'),
 			'NF_RETORNO' 			=> array('edit'=>'N'),
 			'DATA_RETORNO' 			=> array('edit'=>'N'),
 			'DEPARTAMENTO' 			=> array('NULLABLE' => false),
 			'FUNC_ALTERACAO' 		=> array('edit'=>'N'),
           	'DATA_ALTERACAO' 		=> array('edit'=>'N'),
            'REVISAO' 				=> array('edit'=>'N'),
 			'DATASINC' 				=> array(),
            'GRID' 					=> array(
										'type' 		=> 'itemGridAuto', 
										'configitem'=> 'GRID',
										'model' 	=> 'serv_Model_DbTable_Locacaoitem', 
										'controller'=> 'serv_LocacaoitemController',
										'columns'	=> array('NUMERO','EMPRESA','ITEM','PRODUTO','DESCRICAO'),
										'idWhere'	=> array('NUMERO','EMPRESA')
									),
            );

        var $_referenceMap = array(

        'EMPRESA' => array(
            'columns' 		=> 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'EMPRESA'
        ),

        'CLIENTE' => array(
            'columns' 		=> 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'CLIENTE'
        ),

        'FATURA_MODELO' => array(
            'columns' 		=> 'FATURA_MODELO',
            'refTableClass' => 'serv_Model_DbTable_Faturamodelo',
            'refColumns' 	=> 'ID_FATURA',
            'refTitle' 		=> 'FATURA_MODELO'
        ),

    	'CONTATO' => array(
            'columns'           => 'CONTATO',
            'refTableClass'     => 'core_Model_DbTable_Clientecontatoitem',
            'refColumns'        => 'ID',
            'refTitle'          => 'CONTATO',
    	    'semChave'			=> 'S'    //neste caso � quando temos uma chave primaria composta e incluimos o ID para poder fazer orelacionamento
										//porem o ID n�o � chave primaria e portanto no zsam form simple (linha +-103) desabilitamos o validador do zend para chave primaria
		),

        'BANCO' => array(
            'columns' 		=> 'BANCO',
            'refTableClass' => 'core_Model_DbTable_Banco',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'BANCO'
        ),

		'VENDEDOR' => array(
			'columns'           => 'VENDEDOR',
			'refTableClass'     => 'core_Model_DbTable_Usuario',
			'refColumns'        => 'ID',
			'refTitle'          => 'VENDEDOR'
		),

        'CODVENC' => array(
            'columns' 		=> 'CODVENC',
            'refTableClass' => 'core_Model_DbTable_Vencimento',
            'refColumns' 	=> 'ID',
            'refTitle' 		=> 'VENC'
        ),

		'CONTRATO' => array(
			'columns' 		=> 'CONTRATO',
			'refTableClass' => 'serv_Model_DbTable_Locacao',
			'refColumns' 	=> 'ID',
			'refTitle' 		=> 'CONTRATO',
			'semChave'		=> 'S'
		),

        'DEPARTAMENTO' => array(
        	'columns'           => 'DEPARTAMENTO',
        	'refTableClass'     => 'core_Model_DbTable_Depto',
        	'refColumns'        => 'DEPARTAMENTO',
        	'refTitle'          => 'DEPARTAMENTO'
        ),

        'GRID' => array(
            'columns' 		=> 'NUMERO',
            'refTableClass' => 'serv_Model_DbTable_Locacaoitem',
            'refColumns' 	=> 'NUMERO',
            'refTitle' 		=> 'ITEM'
        )

    );

    public function beforeInsert(array $data)
	{

	    $controller      = Zend_Controller_Front::getInstance()->getRequest();
	    $nome_controller = $controller->getControllerName(); //pegar a controladora

	    $table		= new core_Model_DbTable_Empresa();
		$where  	= "CODIGO = ".$data['EMPRESA'];
		$campos 	= $table->getAdapter()->fetchAll($table->select()->where($where));
		$soma 		= @$campos[0]['ULTIMA_LOCACAO']+1;
		$data_emp 	= array('ULTIMA_LOCACAO'=>$soma);

		$table->update($data_emp,$where); // atualiza a tabela empresa antes de inserir a fatura
		
		if($nome_controller != 'impressaoormclientemanut'){
			$data['NUMERO']	= $soma; // recebe o num da fatura da tabela empresa
		}
		
		$date			= date('Y-m-d');
		$data['DATA'] 	= $date;

		if($nome_controller == 'locacaocontrato'){
			$data['TIPO'] 	= 'C';
			$data['ID'] 	= null;
			
		}else if($nome_controller == 'impressaoormclientemanut'){
		    $data['TIPO'] 	= 'P';
		    
		}else{
			$data['TIPO'] 	= 'O';
		}

		return parent::beforeInsert($data);
    }

    public function deleteCascade($id,$emp){

    	$controller 		= Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller 	= $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

    	$table 		= new serv_Model_DbTable_Locacaoitem();
		$adapter 	= $table->getAdapter();
		$where 		= $adapter->quoteInto('NUMERO = ?', $id).' AND '.$adapter->quoteInto('EMPRESA = ?', $emp);
		$table->delete($where);
    }

    public function incluiitemLocacao($id){

        $cliente 		   = $id[0];
        $item	 		   = $id[1];

        $table			   = new Cisweb_Db_Abstract("locacao");
        $orm 			   = new Cisweb_Db_Orcamentoclientelocacao();
        $dados_orm_cliente = $orm->orcamentoDados($cliente.":".$item);
        $dados_empresa     = $orm->getEmpresa($dados_orm_cliente['EMPRESA']);
        $dados_cliente     = $orm->getCliente($dados_orm_cliente['CLIENTE']);
        $itens_orm         = $orm->itensOrcamento($dados_orm_cliente['NUMERO'], $dados_orm_cliente['EMPRESA'],1);
        $obs 			   = $orm->getObs();


        if(!is_null($dados_orm_cliente['CONTRATO'])){

	        $dados  = $table->fetchRow($table->select()->where("ID = ?", $dados_orm_cliente['CONTRATO']))->toArray();

	        $numero  = $dados['NUMERO'];
	        $empresa = $dados['EMPRESA'];

	        $tablei  = new Cisweb_Db_Abstract("locacaoitens");
	        $selecti = $tablei->select()->from($tablei,"MAX(ITEM)")->where("NUMERO  = '$numero' AND EMPRESA = '$empresa'");
	        $dadosi  = $tablei->fetchRow($selecti)->toArray();
	        $item	= $dadosi['MAX(ITEM)'] + 1;

	        foreach($itens_orm as $k => $v){

	            $data['ITEM'] 	 				= $item;
	            $data['EMPRESA'] 				= $empresa;
	            $data['NUMERO']	 				= $numero;
	            $data['DATA_INCLUSAO_CONTRATO'] = date('Y-m-d');

	            $where = "EMPRESA = '{$v['EMPRESA']}' AND NUMERO = '{$v['NUMERO']}' AND ITEM = '{$v['ITEM']}'";

	            $tablei->update($data, $where);
	            $item ++;
	        }

	        $where = "NUMERO = '{$dados_orm_cliente['NUMERO']}' AND EMPRESA = '{$dados_orm_cliente['EMPRESA']}'";
	        $table->delete($where);

	        $where_total_item		   = "NUMERO = '$numero' AND EMPRESA = '$empresa'";
	        $total_itens 			   = $tablei->fetchRow($tablei->select()->from($tablei,"SUM(TOTALITEM)")->where($where_total_item))->toArray();
	        $data_total_item ['TOTAL'] = $total_itens['SUM(TOTALITEM)'];
	        $table->update($data_total_item, $where_total_item);

	        $translate	= Zend_Registry::get('Zend_Translate');

	        echo "<script>alert('".$translate->translate("itens_agregados_pedido")."$numero/$empresa')</script>";

        }
    }

    public function totalizaLocacao(){

    	$hoje   	  = date("Y-m-d");
    	$table  	  = new Cisweb_Db_Abstract("locacao");
    	$table_itens  = new Cisweb_Db_Abstract("locacaoitens");

    	$select 	  = $table->select()->where("DATA_INICIO_CONTRATO <= '$hoje'")
								    	->where("DATA_FINAL_CONTRATO  >= '$hoje'")
								    	->where("TIPO  = 'P'")
								    	->where("FECHAR_ORCAMENTO = 'S'");

    	$dados  	  = $table->fetchAll($select)->toArray();


    	foreach($dados as $k => $v){

    		$empresa 		= $v['EMPRESA'];
    		$numero  		= $v['NUMERO'];

    		$select			= $table_itens->select()->where("NUMERO = ?",$numero)
										    		->where("EMPRESA = ?",$empresa)
										    		->where("NUMERO_NF IS NOT NULL")
										    		->where("NF_RETORNO IS NULL")
										    		->where("DATA_RETORNO IS NULL")
    												->from($table_itens,"SUM(TOTALITEM)");

    		$dados_itens    = $table_itens->fetchAll($select)->toArray();

    		$data['TOTAL'] = $dados_itens[0]['SUM(TOTALITEM)'];
    		$where 		   = "NUMERO = '$numero' AND EMPRESA = '$empresa'";

    		$table->update($data, $where);
    	}
    }

    public function totalizaLocacaoGeral(){

    	$table  	  = new Cisweb_Db_Abstract("locacao");
    	$table_itens  = new Cisweb_Db_Abstract("locacaoitens");

    	$select 	  = $table->select()->where("TIPO  = 'P'")
										->where("FECHAR_ORCAMENTO = 'S'"); 

    	$dados  	  = $table->fetchAll($select)->toArray();


    	foreach($dados as $k => $v){

    		$empresa 		= $v['EMPRESA'];
    		$numero  		= $v['NUMERO'];

    		$select			= $table_itens->select()->where("NUMERO = ?",$numero)
													->where("EMPRESA = ?",$empresa)
                                                    ->where("DATA_RETORNO is null")
													->from($table_itens,"SUM(TOTALITEM)");

    		$dados_itens    = $table_itens->fetchAll($select)->toArray();

    		$data['TOTAL'] = $dados_itens[0]['SUM(TOTALITEM)'];
    		$where 		   = "NUMERO = '$numero' AND EMPRESA = '$empresa'";

    		$table->update($data, $where);
    	}
    }
    
}

?>