<?php

class especial_Model_DbTable_Veiculo extends Zsam_Db_Table {

	protected $_name 	= 'veiculo';
	var $_autocomplet 	= array('ID','NOME_MARCA','NOME_MODELO') ;

 	var $_conf = array(
 			'ID' 					=> array("grid"=>true,'edit'=>'N'),
 			'EMPRESA' 				=> array("grid"=>true,'NULLABLE' => false),
 			'MARCA' 				=> array('edit'=>'N',"grid"=>true),
 			'NOME_MARCA' 			=> array('edit'=>'N'),
 			'MODELO' 				=> array('autocomplete'=>'Y','NULLABLE' => false,"grid"=>true),
 			'NOME_MODELO' 			=> array('edit'=>'N'),
 			'ANO_MODELO' 			=> array("grid"=>true,'NULLABLE' => false,"VP"=> array(2015=>'2015',2014=>'2014',2013=>'2013',2012=>'2012',2011=>'2011',2010=>'2010',2009=>'2009',2008=>'2008',2007=>'2007',2006=>'2006',2005=>'2005',2004=>'2004',2003=>'2003',2002=>'2002',2001=>'2001',2000=>'2000',1999=>'1999',1998=>'1998',1997=>'1997',1996=>'1996',1995=>'1995',1994=>'1994',1993=>'1993',1992=>'1992',1991=>'1991',1990=>'1990',1989=>'1989',1988=>'1988',1987=>'1987',1986=>'1986',1985=>'1985',1984=>'1984',1983=>'1983',1982=>'1982',1981=>'1981',1980=>'1980',1979=>'1979',1978=>'1978',1977=>'1977',1976=>'1976',1975=>'1975')),
 			'ANO_FABR' 				=> array('NULLABLE' => false,"VP"=> array(2015=>'2015',2014=>'2014',2013=>'2013',2012=>'2012',2011=>'2011',2010=>'2010',2009=>'2009',2008=>'2008',2007=>'2007',2006=>'2006',2005=>'2005',2004=>'2004',2003=>'2003',2002=>'2002',2001=>'2001',2000=>'2000',1999=>'1999',1998=>'1998',1997=>'1997',1996=>'1996',1995=>'1995',1994=>'1994',1993=>'1993',1992=>'1992',1991=>'1991',1990=>'1990',1989=>'1989',1988=>'1988',1987=>'1987',1986=>'1986',1985=>'1985',1984=>'1984',1983=>'1983',1982=>'1982',1981=>'1981',1980=>'1980',1979=>'1979',1978=>'1978',1977=>'1977',1976=>'1976',1975=>'1975')),
 			'ESTADO_CARRO' 			=> array("grid"=>true,'NULLABLE' => false,'VP' => array('Z' => 'Zero Km' , 'S' => 'Semi-Novo' , 'U' => 'Usado')),
 			'COMBUSTIVEL' 			=> array('NULLABLE' => false,'VP' => array('G'=>'Gasolina','A'=>'Alcool','F'=>'Flex','D'=>'Diesel','N'=>'GNV','O'=>'Outros')),
 			'COR' 					=> array(),
 			'PLACA' 				=> array(),
 			'CHASSI' 				=> array('case' => 'NONE'),
 			'RENAVAN' 				=> array(),
 			'VALOR' 				=> array('editlevel' => 3,'title' => 'VALOR_TABELA'),
 			'VALOR_MIN_VENDA' 		=> array('editlevel' => 3),
 			'VALOR_MAX_VENDA' 		=> array('editlevel' => 3),
 			'CUSTO' 				=> array('editlevel' => 3,'title' => 'CUSTO_CARRO'),
 			'FUNC_ALTERACAO' 		=> array('edit'=>'N'),
 			'DATA_ALTERACAO' 		=> array('edit'=>'N'),
 			'REVISAO' 				=> array('edit'=>'N')

 	);

 	protected $_referenceMap    = array(

 			'EMPRESA' => array(
 					'columns'           => 'EMPRESA',
 					'refTableClass'     => 'core_Model_DbTable_Empresa',
 					'refColumns'        => 'CODIGO',
 					'refTitle'          => 'EMPRESA'
 			),

 			'MARCA' => array(
 					'columns'           => 'MARCA',
 					'refTableClass'     => 'especial_Model_DbTable_Marca',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'MARCA'
 			),

 			'MODELO' => array(
 					'columns'           => 'MODELO',
 					'refTableClass'     => 'especial_Model_DbTable_Modelo',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'MODELO'
 			),
 			
 			'COR' => array(
 					'columns'           => 'COR',
 					'refTableClass'     => 'especial_Model_DbTable_Veiculocor',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'COR'
 			),

 	);


 	public function beforeInsert(array $data)
 	{
 		$table = new especial_Model_DbTable_Modelo();

 		if (isset($data['MODELO']) && @$data['MODELO'] != '')
 		{
 			$dado_marca 			= $table->find($data['MODELO']);
 			$data['MARCA'] 			= $dado_marca[0]['MARCA'];
 			$data['NOME_MARCA'] 	= $dado_marca[0]['NOME_MARCA'];
 			$data['NOME_MODELO'] 	= $dado_marca[0]['NOME'];
 		}

 		return parent::beforeInsert($data);
 	}
 	
 	public function beforeUpdate(array $data, $where)
 	{
 		$table = new especial_Model_DbTable_Modelo();
 	
 		if (isset($data['MODELO']) && @$data['MODELO'] != '')
 		{
 			$dado_marca 			= $table->find($data['MODELO']);
 			$data['MARCA'] 			= $dado_marca[0]['MARCA'];
 			$data['NOME_MARCA'] 	= $dado_marca[0]['NOME_MARCA'];
 			$data['NOME_MODELO'] 	= $dado_marca[0]['NOME'];
 		}
 	
 		return parent::beforeUpdate($data, $where);
 	}

}
?>