<?php

class especial_Model_DbTable_Foodpedidoitensgarcom extends Zsam_Db_Table {

    protected $_name 		= 'foodpedidoitens';
    var $_autocomplet 		= array('SOLICITANTE','ITEM','NUM_ITEM','FOOD');
    
    var $_conf = array(
        'ID_PEDIDO'				=> array('edit' => 'N'),
		'SOLICITANTE' 			=> array('edit' => 'N','grid' => true),
		'ITEM_PROGR'			=> array('edit' => 'N'),
		'NUM_ITEM' 				=> array('edit' => 'N'),
		'EMPRESA' 				=> array('edit' => 'N'),
		'FOOD' 					=> array('NULLABLE' => false,'grid' => true),
		'QUANTIDADE' 			=> array('NULLABLE' => false,'grid' => true),
		'PRECO_UNITARIO' 		=> array('NULLABLE' => false, 'edit' => 'N'),
		'TOTAL_ITEM'			=> array('edit' => 'N'),
		'QUANTIDADE_GERAL'		=> array('grid' => true),
		'BAIXA' 				=> array(),
		'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
        'DATA_ALTERACAO' 		=> array('edit' => 'N'),
        'REVISAO'        		=> array('edit' => 'N'),
        'DATASINC'       		=> array('edit' => 'N'),
	);
    var $_referenceMap = array(
        
		'SOLICITANTE' => array(
            'columns'       => 'SOLICITANTE',
            'refTableClass' => 'especial_Model_DbTable_Foodsolicitante',
            'refColumns'    => 'ID',
            'refTitle'      => 'SOLICITANTE'
        ),
		
		'EMPRESA' => array(
            'columns'       => 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'NOME'
        ),
       
    	'FOOD' => array(
    		'columns'           => 'FOOD',
    		'refTableClass'     => 'especial_Model_DbTable_Food',
    		'refColumns'        => 'CODIGO',
    		'refTitle'          => 'FOOD'
    	),
    );
	
	 public function __construct(){
        $controller 		= Zend_Controller_Front::getInstance()->getRequest();
	   	$nome_controller	= $controller->getControllerName();
		
		if($nome_controller == 'foodpedidocozinha'){
			
			$this->_conf['FOOD']['edit'] 		= 'N';
			$this->_conf['QUANTIDADE']['edit']  = 'N';
			$this->_conf['MESA']['grid']  		= true;
			
			$this->_restrict = "BAIXA IS NULL";
			
			$table = new Cisweb_Db_Abstract('foodpedidoitens');
			$dados = $table->select()->where('BAIXA IS NULL');
			$dados = $table->fetchAll($dados)->toArray();
			
			foreach($dados as $k => $v){
				
				$food = $v['FOOD'];
				$dados_food = $table->select()->from($table,"SUM(QUANTIDADE) AS SUM")->where("FOOD = ?", $food);
				$dados_food = $table->fetchAll($dados_food)->toArray();
				
				$quantidade = $dados_food[0]['SUM'];
				
				$data['QUANTIDADE_GERAL'] = $quantidade;
				$where = "ID_PEDIDO = '".$v['ID_PEDIDO']."' AND NUM_ITEM = '".$v['NUM_ITEM']."'";
				$table->update($data, $where);
			}
		}
	   
	    parent::__construct();
    }
	
	public function beforeInsert(array $data){
		
		$table_food = new Cisweb_Db_Abstract('food');
		$table_kit  = new Cisweb_Db_Abstract('foodkit');
		$table_item = new Cisweb_Db_Abstract('foodpedidoitens');
		$food 	    = $data['FOOD'];
		
		$dados_kit  = $table_kit->select()->where("FOOD = ?", $food);
		$dados_kit  = $table_kit->fetchAll($dados_kit)->toArray();
		
		if(count($dados_kit) > 0){
			
			$numero_item = $data['NUM_ITEM'] + 1;
			
			foreach($dados_kit as $k => $v){
			
				$componente = $v["COMP"];
				$quantidade = $v["QTD_COMP"];
					
				$dados_food = $table_food->find($componente)->toArray();
					
				$data_novo['ID_PEDIDO'] 			   	= $data['ID_PEDIDO'];
				$data_novo['SOLICITANTE'] 			    = $data['SOLICITANTE'];
				$data_novo['ITEM_PROGR'] 			    = NULL;
				$data_novo['NUM_ITEM'] 			        = $numero_item;
				$data_novo['EMPRESA'] 			        = NULL;
				$data_novo['FOOD'] 			            = $dados_food[0]['CODIGO'];
				$data_novo['QUANTIDADE'] 			    = $data['QUANTIDADE'] * $quantidade;
				$data_novo['PRECO_UNITARIO'] 			= $data['PRECO_UNITARIO'];
				$data_novo['TOTAL_ITEM'] 			    = ($quantidade * $data['QUANTIDADE']) *$data['PRECO_UNITARIO'];
				$data_novo['QUANTIDADE_GERAL'] 			= NULL;
				$data_novo['BAIXA'] 			       	= NULL;
				$data_novo['FUNC_ALTERACAO'] 			= NULL;
				$data_novo['DATA_ALTERACAO'] 			= NULL;
				$data_novo['REVISAO'] 			        = NULL;
					
				$table_item->insert($data_novo);
					
				$numero_item ++;
			}
		}
		
		
		return parent::beforeInsert($data);
	}

}
?>