<?php

class especial_Model_DbTable_Foodpedidogarcom extends Zsam_Db_Table {


    protected $_name 		= 'foodpedido';
    var $_autocomplet 		= array('SOLICITANTE','ITEM');
	var $_restrict 			= 'FECHAR_ORCAMENTO IS NULL';
    
    var $_conf = array(
        'SOLICITANTE' 			=> array("grid"=>true,'NULLABLE' => false,'validate'=>array('Cisweb_Validate_Foodpedidogarcom')),
		'ITEM' 					=> array('edit' => 'N'),
		'DATA_CHEGADA'			=> array("grid"=>true,'edit' => 'N'),
		'HORA_CHEGADA'			=> array("grid"=>true,'edit' => 'N'),
		'CONTATO' 				=> array(),
		'EMPRESA' 				=> array(),
		'DATA_PEDIDO' 			=> array(),
		'FECHAR_ORCAMENTO' 		=> array(),
		'VALOR_TOTAL' 			=> array(),
		'DATA_ENTREGA' 			=> array(),
		'OBS_ENTREGA' 			=> array(),
		'OBSERVACAO' 			=> array(),
		'BAIXA' 				=> array(),
		'ID' 					=> array('edit' => 'N'),
		'APROVACAO' 			=> array(),
		'DEPARTAMENTO' 			=> array(),
		'GRID'    		  		=> array( 'type' 		=> 'itemGridAutofood',
										  'configitem' 	=> 'GRID',
										  'model' 		=> 'especial_Model_DbTable_Foodpedidoitensgarcom',
										  'columns' 	=> array('SOLICITANTE','FOOD','QUANTIDADE','BAIXA'),
										  'idWhere' 	=> array('ID_PEDIDO'),
										  'buttons'		=> array('edit'=>'S', 'del' => 'S')),
										  
		'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
        'DATA_ALTERACAO' 		=> array('edit' => 'N'),
        'REVISAO'        		=> array('edit' => 'N'),
        'DATASINC'       		=> array('edit' => 'N'),
	);
    var $_referenceMap = array(
        
		'SOLICITANTE' => array(
            'columns'       => 'SOLICITANTE',
            'refTableClass' => 'especial_Model_DbTable_Foodsolicitante',
            'refColumns'    => 'ID',
            'refTitle'      => 'SOLICITANTE'
        ),
		
		'EMPRESA' => array(
            'columns'       => 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'NOME'
        ),
       
    	'DEPARTAMENTO' => array(
    		'columns'           => 'DEPARTAMENTO',
    		'refTableClass'     => 'core_Model_DbTable_Depto',
    		'refColumns'        => 'DEPARTAMENTO',
    		'refTitle'          => 'DEPARTAMENTO'
    	),

    	'GRID' => array(
    		'columns'           => 'GRID',
    		'refTableClass'     => 'especial_Model_DbTable_Foodpedidoitensgarcom',
    		'refColumns'        => 'ITEM_PROGR',
    		'refTitle'          => 'ITEM'
    	),
    );
	
	
	public function beforeValidade(&$form,$dados){
    	
	    $form->getElement("ID")->setRequired(false);
    }
	
	public function beforeInsert(array $data){
		
		$data['DATA_CHEGADA'] = date('Y-m-d');
		$data['HORA_CHEGADA'] = date('H:i:s');
		
		return parent::beforeInsert($data);
	}
	
	public function beforeDelete($where){
       
	   
	   $auth 	= Zend_Auth::getInstance();
	   $user 	= $auth->getStorage()->read();
	   $nivel 	= @$user['NIVEL'];
		
	   if($nivel >= 3){
		
    		parent::beforeDelete();
	   
	   }else{
		   $translate = Zend_Registry::get('Zend_Translate');
		   
		   $table = new Cisweb_Db_Abstract('foodpedidoitens');
		   $dados = $table->select()->where("ID_PEDIDO = ?", $where[" ID = ? "])->where('BAIXA IS NOT NULL');
		   $dados = $table->fetchAll($dados)->toArray();
		   
		   if(count($dados) == 0 ){
				parent::beforeDelete();
		   }else{
				echo "<script>alert('".$translate->translate('foodpedidogarcom_nao_pode_ser_deletado')."')</script>";
				echo "<script>location.reload(); </script>";
				die;
		   }
		}   
    }
	

}
?>