<?php

class especial_Model_DbTable_Escoladisc extends Zsam_Db_Table {

	protected $_name 	= 'escoladisc';
	var $_autocomplet 	= array('CURSO','NOME_CURSO','PERIODO','DISCIPLINA','CARGA_HORARIA_SEMANAL','HAE') ;

 	var $_conf = array(
 			'ID' 					=> array("grid"=>true,'edit'=>'N'),
 			'EMPRESA' 				=> array("grid"=>true,'NULLABLE' => false),
 			'CURSO' 				=> array("editlevel"=>3,"grid"=>true,'NULLABLE' => false),
 			'NOME_CURSO' 			=> array('edit'=>'N'),
 			'DISCIPLINA' 			=> array("grid"=>true,'NULLABLE' => false, 'case' => 'NONE'),
 			'PERIODO' 				=> array("editlevel"=>3,"grid"=>true,'NULLABLE' => false,"VP" => array(1=>'I periodo',2=>'II periodo',3=>'III periodo',4=>'IV periodo',5=>'V periodo',6=>'VI periodo')),
 			'CARGA_HORARIA_SEMANAL'	=> array("editlevel"=>3,"grid"=>true,'NULLABLE' => false,"VP" => array(1=>'1 hora semanal',2=>'2 horas semanais',4=>'4 horas semanais',6=>'6 horas semanais',8=>'8 horas semanais',10=>'10 horas semanais')),
 			'HAE'					=> array("title"=>'tipo_atividade',"editlevel"=>3,'NULLABLE' => false,"grid"=>true,"VP" => array('H-A'=>'Hora-Aula','HAE'=>'H.A.E.','RJI'=>'R.J.I.')),
 			'HORAS_PAGTO'			=> array("editlevel"=>3,"VP" => array('0.0'=>'Sem Hora Atividade','0.5'=>'0,5 horas aula')),
 			'FUNC_ALTERACAO' 		=> array('edit'=>'N'),
 			'DATA_ALTERACAO' 		=> array('edit'=>'N'),
 			'REVISAO' 				=> array('edit'=>'N'),
 	);

 	protected $_referenceMap    = array(

 			'EMPRESA' => array(
 					'columns'           => 'EMPRESA',
 					'refTableClass'     => 'core_Model_DbTable_Empresa',
 					'refColumns'        => 'CODIGO',
 					'refTitle'          => 'EMPRESA'
 			),

 			'CURSO' => array(
 					'columns'           => 'CURSO',
 					'refTableClass'     => 'especial_Model_DbTable_Escolacurso',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'CURSO'
 			),
 	);

    public function __construct()
    {
      parent::__construct();

        $controller 	 = Zend_Controller_Front::getInstance()->getRequest();
	    $nome_controller = $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

	  	if($nome_controller == 'relatoriozprofpresenca'||$nome_controller == 'relatoriozprofpresencapdf')
		{
			$this->_autocomplet = array('DISCIPLINA') ;
		}

	}

 	public function beforeInsert(array $data)
 	{

 		$curso = new especial_Model_DbTable_Escolacurso();

 		$dados_curso = $curso->find($data['CURSO']);

 		$data['NOME_CURSO'] = $dados_curso[0]['NOME'];
 
 		return parent::beforeInsert($data);

 	}

 	public function beforeUpdate(array $data, $where)
 	{

 		$curso = new especial_Model_DbTable_Escolacurso();

 		$dados_curso = $curso->find($data['CURSO']);

 		$data['NOME_CURSO'] = $dados_curso[0]['NOME'];

 		return parent::beforeUpdate($data, $where);

 	}


}
?>