<?php

class especial_Model_DbTable_Cotacaoforneorm extends Zsam_Db_Table {

    /**
     * The default table name
     */
    protected $_name 	= 'cotacaoforneorm';

    var $_autocomplet = array('ID','NUM_OPORTUNIDADE','NOME_FORNE','STATUS_ORM');

    var $status;

    var $_conf = array(
        'ID'			=> array("grid"=>true,'edit' => 'N'),
        'NUM_OPORTUNIDADE'	=> array('edit' => 'N',"grid"=>true,'NULLABLE' => false),
	'FORNE'                 => array('autocomplete' =>'Y'),
    	'CONTATO'        	=> array(),
    	'NOME_CONTATO'        	=> array('NULLABLE' => false),
    	'NOME_FORNE'        	=> array('NULLABLE' => false),
    	'EMAIL'        		=> array('NULLABLE' => false),
    	'TELEFONE'        	=> array(),
    	'STATUS_ORM' 		=> array('edit' => 'N'),
        'USUARIO_EMAIL' 	=> array('edit' => 'N'),
        'DATA_EMAIL'            => array('edit' => 'N'),
	);

    var $_referenceMap = array(

        'FORNE' => array(
            'columns'           => 'FORNE',
            'refTableClass'     => 'serv_Model_DbTable_Fornecedor',
            'refColumns'        => 'CODIGO',
            'refTitle'          => 'FORNE'
        ),

        'CONTATO' => array(
            'columns'           => 'CONTATO',
            'refTableClass'     => 'core_Model_DbTable_Fornecontatoitem',
            'refColumns'        => 'ID',
            'refTitle'          => 'CONTATO',
            'semChave'		=> 'S'    //neste caso � quando temos uma chave primaria composta e incluimos o ID para poder fazer orelacionamento
            //porem o ID n�o � chave primaria e portanto no zsam form simple (linha +-103) desabilitamos o validador do zend para chave primaria
        ),
        
        'USUARIO_EMAIL' => array(
            'columns' 		=> 'USUARIO_EMAIL',
            'refTableClass' 	=> 'core_Model_DbTable_Usuario',
            'refColumns' 	=> 'ID',
            'refTitle' 		=> 'USUARIO'
        ),
        
        'NUM_OPORTUNIDADE' => array(
            'columns' 		=> 'NUM_OPORTUNIDADE',
            'refTableClass' 	=> 'especial_Model_DbTable_Cotacaoforne',
            'refColumns' 	=> 'NUM_OPORTUNIDADE',
            'refTitle' 		=> 'NUM_OPORTUNIDADE'
        ),
    );

    public function __construct(){

        $controller      = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora

	    $auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
			$level  = @$user['NIVEL'];
		}

        parent::__construct();
    }


    public function beforeInsert(array $data)
    {

    	$tablecotacao 			= new Cisweb_Db_Abstract('cotacaoforne');
    	$status_cotacao 		= $this->verificaStatus($data['NUM_OPORTUNIDADE']);

    	if ($status_cotacao)
    	{
    		$num_oportunidade 		= $data['NUM_OPORTUNIDADE'];
    		$datacotacao['STATUS'] 	= $status_cotacao;
    		$wherecotacao 			= "NUM_OPORTUNIDADE = '$num_oportunidade'";
    		$tablecotacao->update($datacotacao, $wherecotacao);
    	}

    	$data['STATUS_ORM'] 	= 'Iniciado';

    	return parent::beforeInsert($data);

    }

    public function verificaStatus($num)
    {
    	$dados = $this->fetchAll($this->select()
    			->where("NUM_OPORTUNIDADE = '$num'"));

    	$soma = 0;

    	foreach ($dados as $k => $v)
    	{
    		if ($v['STATUS_ORM'] == 'Cotado' || $v['STATUS_ORM'] == 'Parcialmente Cotado')
    		{
    			$soma ++;
    		}
    	}

    	if ($soma <> 0)
    	{
    		return 'P'; //parcialmente cotado
    	}
    	else
    	{
    		return false;
    	}

    }



    public function getcotacaoorm($num)
    {
    	if ($num != '')
    	{
    		$dados = $this->find($num)->current();

    		return $dados;
    	}
    	else
    	{
    		return false;
    	}

    }


    public function getForne($num)
    {
    	$table = new serv_Model_DbTable_Fornecedor();

    	if ($num != '')
    	{
    		$dados = $table->find($num);

    		if ($dados[0]['CIDADE'] != '')
    		{
    			$cidade = $this->getCidade($dados[0]['CIDADE']);
    			$dados[0]['CIDADE'] = $cidade[0]['NOME'].' - ' .$cidade[0]['UF'];
    		}



			if(count($dados) != 0)
			{
				return $dados;
			}
			else
			{
				return false;
			}


    	}
    	else
    	{
    		return false;
    	}

    }

    public function getCidade($num)
    {
    	$table = new core_Model_DbTable_Cidade();

    	if ($num != '')
    	{
    		$dados = $table->find($num);

    		if(count($dados) != 0)
    		{
    			return $dados;
    		}
    		else
    		{
    			return false;
    		}
    	}
    	else
    	{
    		return false;
    	}

    }

}
?>