<?php

class Bootstrap extends Zend_Application_Bootstrap_Bootstrap {

    var $_acl = null;
	var $sessao;

	
	public function __construct($application) {
        parent::__construct($application);
		$this->sessao = new Zend_Session_Namespace('externo');//REGISTRA A SESSAO NA PAGINA
		
        $autoloader = Zend_Loader_Autoloader::getInstance();
        $autoloader->registerNamespace('Zsam_');
        $autoloader->registerNamespace('Cisweb_');

        //Zend_Loader::loadFile("fpdf.php", realpath(APPLICATION_PATH . '/../library/fpdf'), true); 

        $loader = Zend_Loader_Autoloader::getInstance();
        $loader->registerNamespace('Helper_');

        $view = new Zend_View();
        $view->addHelperPath("Zsam/View/helpers", "Zsam_View_Helper");
        $viewRenderer = new Zend_Controller_Action_Helper_ViewRenderer();
        $viewRenderer->setView($view);
        Zend_Controller_Action_HelperBroker::addHelper($viewRenderer);

        $frontend = array('lifetime' => 72000, 'automatic_serialization' => true);
        $backend = array('cache_dir' => APPLICATION_PATH . '/../cache/');

        $cache = Zend_Cache::factory('core', 'File', $frontend, $backend);

        Zend_Registry::set('cache', $cache);

    }

    public function _initPlugins() {

		$front = Zend_Controller_Front::getInstance();
		$front->registerPlugin(new Cisweb_Auth_Plugin($this->_acl));
    }

	
	public function _initConnection() {
        $this->bootstrap("multidb");
        $resource = $this->getPluginResource("multidb");
        $registry = Zend_Registry::getInstance();
//		print_r($resource->getDb());die('pppp');
		$registry->set('db1', $resource->getDb("db1"));
        $registry->set('db2', $resource->getDb("db2"));
        $registry->set('db3', $resource->getDb("db3"));
        if ($this->sessao->apoiosessao == 's88257') $registry->set('db99', $resource->getDb("db99"));
    }

	public function _initLocale() {
    	
		$localizacao = $this->sessao->apoiosessao1;

        $locale = new Zend_Locale($localizacao);
        Zend_Registry::set('Zend_Locale', $locale);

        Zend_Locale::setDefault($localizacao);
        Zend_Locale_Format::setOptions(array('precision' => 2, 'locale' => 'pt_BR'));
        
		$multidb = $this->getResource('multidb');
		$multidb instanceof Zend_Application_Resource_Multidb;
        $banco = $this->sessao->apoiosessao;
		
		$dados_traducao	=  $multidb->getDb()->select()->from('cliente')->where("CODIGO = '$banco' ");
		$dados_traducao	=  $multidb->getDb("db2")->fetchAll($dados_traducao);
		$pasta			=  0;//$dados_traducao[0]['TRADUCAO_PASTA'];
		 
        if($pasta == 0){
		    
        	$translate = new Zend_Translate(
	                        array(
	                            'adapter' => 'array',
	                            'content' => APPLICATION_PATH . '/configs/translate/'. $locale->getLanguage() . $locale->getRegion(). '.php',
	                            'locale' => $locale->getLanguage() . '_' . $locale->getRegion()
	                        )
	        );
	        Zend_Registry::set('Zend_Translate', $translate);
	        
        }else{
        	
        	$translate = new Zend_Translate(
        			array(
        					'adapter' => 'array',
        					'content' => APPLICATION_PATH . '/configs/translate/'.$pasta.'/'. $locale->getLanguage() . $locale->getRegion(). '.php',
        					'locale' => $locale->getLanguage() . '_' . $locale->getRegion()
        			)
        	);
        	Zend_Registry::set('Zend_Translate', $translate);
        	
        }    
    }


	
    protected static function _initNamespaces() {
        
    }

    public function _initAutoload() {
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'core',
                    'basePath' => APPLICATION_PATH . '/modules/core'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'serv',
                    'basePath' => APPLICATION_PATH . '/modules/serv'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'com',
                    'basePath' => APPLICATION_PATH . '/modules/com'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'ind',
                    'basePath' => APPLICATION_PATH . '/modules/ind'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'servcom',
                    'basePath' => APPLICATION_PATH . '/modules/servcom'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'servind',
                    'basePath' => APPLICATION_PATH . '/modules/servind'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'indcom',
                    'basePath' => APPLICATION_PATH . '/modules/indcom'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'revisao',
                    'basePath' => APPLICATION_PATH . '/modules/revisao'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'admin',
                    'basePath' => APPLICATION_PATH . '/modules/admin'));
        $autoloader[] = new Zend_Application_Module_Autoloader(array(
                    'namespace' => 'especial',
                    'basePath' => APPLICATION_PATH . '/modules/especial'));
    }


    public function _initConfig() {
        $this->bootstrap('multidb');
        $multidb = $this->getResource('multidb');
        $multidb instanceof Zend_Application_Resource_Multidb;
        $config = $multidb->getDb()
                ->fetchAll(
                $multidb->getDb()
                ->select()
                ->from('config'));
 
        $config[0]['TIMEOUT'] = ($config[0]['TIMEOUT'] > 0) ? $config[0]['TIMEOUT'] : $config[0]['TIMEOUT'] = 300;
        Zend_Registry::set('Cisweb_Config', $config);
		

		$banco = $this->sessao->apoiosessao;
		$cliente = $multidb->getDb("db2")
                ->fetchAll(
                $multidb->getDb()
                ->select()
                ->from('cliente')
				->where("CODIGO = '$banco' ")
				);

		if (!isset($cliente[0]['SITUACAO'])) $cliente[0]['SITUACAO']='KKKKKKKKK';
		Zend_Registry::set('Cliente', $cliente);	

	 
    }

    protected function _initHelpers() {
        Zend_Controller_Action_HelperBroker::addPath(APPLICATION_PATH . '/modules/core/controllers/helpers');
    }

    /**
     * 
     */
//    protected function _initComposerAutoloader()
//    {
//        $autoloader = Zend_Loader_Autoloader::getInstance();
//        $composerAutoloader = require_once APPLICATION_PATH. '/../vendor/autoload.php';
//    }
}