<?php
class Zsam_Db_Table extends Zend_Db_Table_Abstract
{
	var $_restrict;
	var $_conf;
	var $_criptkey;
	var $_autocomplet;
	var $_grid_records = 50;
	var $_tabela_revisao = null;

        public function init(){

        }
	public function getName(){
		return $this->_name;
	}
	public function getAutocompleteTitles(){
		if ($this->_autocomplet == null ){
			$cols = $this->info('cols');
			$this->_autocomplet = $cols[1];
		}


		return $this->_autocomplet;



	}
	public function printTitleFromId($id){
		return $this->printTitle($this->find($id)->current());

	}
	public function beforeValidade(&$form,$dados){


	}
    public function printTitle($row){
        $txt = "";
        $title = $this->getAutocompleteTitles();
        if (isset($row)){
            $row = $this->decrypt($row);
            $obj = new Zsam_Crypt_Cisweb;
            if ( is_array($title) ) {
              foreach ($title as $t){
                  $data = $row[$t];
                  if ( $txt != "")
                      $txt .= " - ";

                  $txt .=  $data;
              }
            } else{
               $data = $row[$title];

               $txt = $data;
            }
        }
		return $txt;
	}
    public function autocomplete($search=null,$order = null, $count = null, $offset = null)
    {
        if ( $search == null ) {
           return $this->fetchAll();

        } elseif (is_array($search ) ) {

        	if ( isset($search['where']) )
                return $this->fetchAll($search['where']);

            else {
                $where = "";
                $title = $this->getAutocompleteTitles();
                $cols = $this->info(Zend_Db_Table_Abstract::COLS);
//                 Zend_Debug::dump($title,'TITLE');
//                 Zend_Debug::dump($this->_conf['CNPJ'],'CONF');
//                 Zend_Debug::dump($search,'DUMP 1');
                $cripto = new Zsam_Crypt_Cisweb();
//                 $search['term'] = $obj->encode($search['term']);
//                 Zend_Debug::dump($search,'DUMP 2');

                $andWhere   = '';
                $assinatura = null;
                $ativo      = null;

              	if (in_array('ASSINATURA', $cols)){
                    $assinatura = 'ASSINATURA != "" ';
                }

               if (in_array('ESTA_ATIVO', $cols)){
                    $ativo = 'ESTA_ATIVO = "S" ';
               }

                if(!is_null($assinatura))
                {
                	if(!is_null($ativo))
                	{
                		$andWhere = "AND ($assinatura) AND ($ativo)";
                	}else{
                		$andWhere = "AND ($assinatura)";
                	}
                }else{
                	if(!is_null($ativo))
                	{
                		$andWhere = "AND ($ativo)";
                	}
                }


                if ( is_string($title) ){
                    //
//                  $where = " UCASE($title) like UCASE('%$search[term]%') ";
                    if(@isset($this->_conf["$title"]['cripto']) or @$this->_conf["$title"]['cripto'] != ''){
                        $search['term'] = $cripto->encode($search['term']);
                    }

                    $where = "( UCASE($title) like UCASE('%$search[term]%') )" . $andWhere;
                }

                if ( is_array($title) )
                {
                    foreach ($title as $t)
                    {
//                         Zend_Debug::dump($this->_conf["$t"]['cripto'],'TITLE T');
                        if(@isset($this->_conf["$t"]['cripto']) or @$this->_conf["$t"]['cripto'] != '')
                        {
                            $search['term'] = $cripto->encode($search['term']);
                        }

                        if ( $where != '')
                            $where.=' or ';
//                      $where.= " UCASE($t) like UCASE('%$search[term]%') ";
                        $where.= " UCASE($t) like UCASE('%$search[term]%') ";
                    }

                    $where = "( $where ) $andWhere";
                }
//                 Zend_Debug::dump($where,'WHERE');
//                 Zend_Debug::dump($this->fetchAll($where,$order,$count,$offset),'FETCHALL');die();
                return $this->fetchAll($where,$order,$count,$offset); // filtra termo
            }
        } else {
           return $this->fetchAll($search,$order,$count,$offset);
        }
	}
	public function encrypt_base64($text)
    {
    	$key = $this->getCriptkey();
        return trim(base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $key, $text, MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND))));
    }

    public function decrypt_base64($text)
    {
    	$key = $this->getCriptkey();
        return trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, base64_decode($text), MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND)));
    }

    public function decrypt($data){
        $obj = new Zsam_Crypt_Cisweb;
        if (is_object($data))
        	if (get_class($data)== "Zend_Db_Table_Rowset")
        	$data = $data->toArray();
        foreach (@$data as $col=>$v){
        	if (@$this->_conf[$col]['cripto']=='Base64')
        		$data[$col]= $this->decrypt_base64($v);
        	if (@$this->_conf[$col]['cripto']=='cisweb'){
        		$data[$col]=$obj->decode($v) ;
        	}
        }

        return $data;

        }

	public function insert(array $data)
    {
			$data = $this->beforeInsert($data);
    		$res = parent::insert($data);
    		$this->afterInsert($res);

    	return $res;
    }
    public function beforeInsert(array $data)
    {

    	foreach ($data as $col=>$v){
    		if (@$this->_conf[$col]['cripto']=='Base64')
    		   $data[$col]=$this->encrypt_base64($v) ;
    		if ( @$this->_conf[$col]['cripto']=='cisweb') {
    		   $obj = new Zsam_Crypt_Cisweb;
    		   $data[$col]=$obj->encode($v) ;
    		}
    		if (@$this->_conf[$col]['cripto']=='MD5')
    		   $data[$col]=md5($v) ;


    		if (isset($this->_conf['FUNC_ALTERACAO']) &&
    							@$this->_conf['FUNC_ALTERACAO']['edit'] == 'N') {
	    		$data['FUNC_ALTERACAO'] = Zsam_User::getId();
    		}
    		if (isset($this->_conf['DATA_ALTERACAO']) &&
    								@$this->_conf['DATA_ALTERACAO']['edit'] == 'N') {
	    		$data['DATA_ALTERACAO'] = date('Y-m-d');
    		}
    		if (array_key_exists('FUNC_ALTERACAO', $this->_conf) && array_key_exists('DATA_ALTERACAO', $this->_conf) && array_key_exists('REVISAO', $this->_conf)) {
  				$data['REVISAO'] = 1;
    		}

    		if (isset($this->_conf['FUNC_CRIACAO']) && @$this->_conf['FUNC_CRIACAO']['edit'] == 'N') {
    			$data['FUNC_CRIACAO'] = Zsam_User::getId();
    		}

    		if (isset($this->_conf['DATA_CRIACAO']) && @$this->_conf['DATA_CRIACAO']['edit'] == 'N') {
    			$data['DATA_CRIACAO'] = date('Y-m-d');
    		}
    	}
    	return $data;
    }
    public function afterInsert($id)
    {
    }

	public function update(array $data, $where)
    {
    	$data = $this->beforeUpdate($data, $where);
    	$res = parent::update($data, $where);
    	$this->afterUpdate($res,$where);
    	return $res;
    }

    public function beforeUpdate(array $data, $where)
    {
    	foreach ($data as $col=>$v){
    		if (@$this->_conf[$col]['cripto']=='Base64')
    		   $data[$col]=$this->encrypt_base64($v) ;
    		if ( @$this->_conf[$col]['cripto']=='cisweb') {
    		   $obj = new Zsam_Crypt_Cisweb;
    		   $data[$col]=$obj->encode($v) ;
    		}
            if (@$this->_conf[$col]['cripto']=='MD5')
    		   $data[$col]=md5($v) ;
    	}
		if ( !key_exists('ASSINATURA', $data) ){
			try {
				$data_old = array();
				$reg = $this->fetchAll($where)->current();
				if ( $reg != null )
					$data_old = $reg->toArray();

				$alteracao = false;
				foreach ($data as $col=>$v){
					if (@$data_old[$col]!=$v){
						$alteracao=true;
						break;
					}
				}
			} catch (Exception $e){
				$alteracao = false;
			}
			if ( $alteracao ) {
	    	    if (isset($this->_conf['FUNC_ALTERACAO']) &&
	    	    				@$this->_conf['FUNC_ALTERACAO']['edit'] == 'N') {
		    		$data['FUNC_ALTERACAO'] = Zsam_User::getId();
	    		}
	    		if (isset($this->_conf['DATA_ALTERACAO']) &&
	    							@$this->_conf['DATA_ALTERACAO']['edit'] == 'N') {
		    		$data['DATA_ALTERACAO'] = date('Y-m-d');
	    		}
                        if (array_key_exists('DATASINC', $data)){
                            //$data['DATASINC'] = null;
                        }
		    	if (array_key_exists('REVISAO', $this->_conf)) {
		    		if (empty($data['REVISAO'])) {
			    		$data['REVISAO'] = new Zend_Db_Expr('COALESCE(REVISAO,0)+1'); // Adiciona o valor 1 para entidades
			    																	 //	 que não tiverem esse campo setado
		    		} else {
			    		$data['REVISAO'] = new Zend_Db_Expr('REVISAO+1');
		    		}
	    		}
			}
    	}
    	return $data;
    }
    
    public function afterUpdate($id,$where)
    {
		/*Incluir nesse formato na Model:
		 * 	var $revisao	  		= 'S';
			var $quantidade_revisao	= 9;
		 */
    	
    	
    	try {

			$tabela 		 	= $this->_name;
			$tabela_revisao	 	= $tabela."rev";
			$quantidade_revisao	= $this->quantidade_revisao;
			
			$table		 		= new Cisweb_Db_Abstract($tabela);
			$table_describe		= $table->getDescribe();
			$table_adapter		= $table->getAdapter();
			
			/*Captura estrutura da tabela de revisao*/
			$table_rev		 	= new Cisweb_Db_Abstract($tabela_revisao);
			$table_rev_describe	= $table_rev->getDescribe();
			$table_rev_adapter	= $table_rev->getAdapter();
			
			//echo $numero_revisoes	= count($table_rev->fetchAll()->toArray());
			//echo "----------",$quantidade_revisao;
			
			/* Estrutura de comparao entre tabelas e suas tabelas de reviso*/
			$array	= array();
			foreach ($table_describe as $k => $v){
				$array[$k] = $k;
			}
			
			$array_rev			= array();
			foreach ($table_rev_describe as $k => $v){
				$array_rev[$k] = $k;
			}
			
			$array_campos_faltando = array();
			foreach ($array as $v){
				
				if(!array_key_exists($v, $array_rev)){
					$array_campos_faltando[$v] = $v;	
				}
			}
			/*Fim do bloco*/
			
			
			/*Busca e prepara os dados que vo pra tabela de reviso */
			
			$dados = $table->select();
			foreach ($where as $k => $v){
				$dados = $dados->where($k,$v);
			}
			
			$dados = $table->fetchRow($dados)->toArray();
			
			foreach ($table_describe as $k => $v){
				if($v['PRIMARY']){
					unset($dados[$k]);
				}
			}
			
			$dados['FUNC_ALTERACAO'] = 999;
			$dados['DATA_ALTERACAO'] = date("Y-m-d");
						
			Zend_Debug::dump($dados);
			$table_rev->insert($dados);
			
// 			$query 			 	= "SHOW CREATE TABLE `$tabela_revisao`";
// 			$create 		 	= $table_rev_adapter->query($query);
			
			
		 	
		} catch (Exception $e) {
		    //Zend_Debug::dump($e);
		}
		
		//die("End");
    }
    
    public function setAdaptador($banco = '')
    {
    	$db1 = new Zend_Db_Adapter_Pdo_Mysql(array(
    			'host'     => $this->config->Host,
    			'username' => $this->config->Username,
    			'password' => $this->config->Password,
    			'dbname'   => "$banco"
    	));
    
    	$this->registry = $db1;
    }
    
    
	public function getCriptkey(){
		if ($this->_criptkey == null)
		  $this->_criptkey = md5(get_class($this));

		return $this->_criptkey;
	}
	public function __construct($config = array())
    {
      parent::__construct($config);
      $this->confRestrict();
    }
	private function confRestrict(){
	  return;
	}

	public function fetchRow($where = null,
                            $order = null,
                            $restrict = true)
    {
      if ($restrict&&
          isset($this->_restrict)&&
          is_string($this->_restrict))
      {
         if (is_array($where))
         {
            $where[] = $this->_restrict;
         } else {
            $where = '('.$this->_restrict.') AND ('.$where.')';
         }
      } elseif ($restrict&&
                isset($this->_restrict)&&
                is_array($this->_restrict))
      {
         if (is_array($where))
         {
            $where = array_merge($where, $this->_restrict);
         } else {
            foreach ($this->_restrict as $contraint) {
               $where = '('.$contraint.') AND ('.$where.')';
            }
         }
      }
      $res = parent::fetchRow($where,$order);
      return $res;
   }
	public function fetchAll($where = null, $order = null, $count = null, $offset = null, $restrict = true)
    {

      if ($restrict&&
          isset($this->_restrict)&&
          is_string($this->_restrict))
      {
         if (is_array($where))
         {
            $where[] = $this->_restrict;
         } else {
         	   if ( $where != NULL )
                  $where = array($this->_restrict,$where);
               else
                  $where = array($this->_restrict);

         }
      } elseif ($restrict&&
                isset($this->_restrict)&&
                is_array($this->_restrict))
      {
         if (is_array($where))
         {
            $where = array_merge($where, $this->_restrict);
         } else {
            if ( $where != NULL )
                  $where = array_merge(array($where), $this->_restrict);
               else
                  $where = $this->_restrict;
            }

      }

      $res = parent::fetchAll($where, $order, $count, $offset);
      return $res;
   }


	public function fetchAllJson($where = null, $order = null, $count = null, $offset = null, $restrict = true)
    {
      if ($restrict && isset($this->_restrict) && is_string($this->_restrict))
      {
         if(!is_array($where) && !is_string($where))
         {
         	if ( $where != NULL )
         	{
         		  $where = $where->where($this->_restrict);
         	}else{
                 $where = $this->_restrict;
         	}
         }


         else
         {
            $where = $this->_restrict;
         }

      }

      elseif ($restrict && isset($this->_restrict) && is_array($this->_restrict))
      {
         if(!is_array($where) && !is_string($where))
         {
         	if ( $where != NULL )
         	{
         		foreach($this->_restrict as $k => $v)
         		{
         		  	$where = $where->where($this->_restrict[$k]);
         		}

         	}else{
                  $where = $this->_restrict;
         	}

         }

         else
         {
         	$where = $this->_restrict;
         }
     }

     

     
     
      $res = parent::fetchAll($where, $order, $count, $offset);
      return $res;
   }

   function getColsGrid(){
   	    $cols = $this->info('cols');
   	    $grid = array();
	   	if ( empty($this->_conf) || !is_array($this->_conf) ) {
	   		$grid = array_slice ($cols,0,10);
	   	} else {
	   	   foreach ($this->_conf as $f=>$v){
	   	   	  if (!in_array($f, $cols)) continue;
	   	   	  if (@$v['grid']==true && @$v['level'] <= Zsam_User::getLevel())
	   	   	     $grid[]=$f;
	   	   }
	   	   if (count($grid)==0)
	   	      $grid = array_slice ($cols,0,10);
	   	}
	   	return $grid;

   }
   function getDescribe(){
   	    $meta = $this->info('metadata');
   	    if ( !empty($this->_conf) && is_array($this->_conf) ) {
            $newmeta = array();
   	        foreach ($meta as $k=>$v){
   	           if ( is_array(@$this->_conf[$k]) )
   	             $newmeta[$k] = array_merge($v,$this->_conf[$k]);
   	           else
   	             $newmeta[$k] = $v;
   	        }
   	    	return $newmeta;
   	    } else {
   	      return $meta;
   	    }


   }
   function canUpd($row){
   	   if ( $row instanceof Zend_Db_Table_Row_Abstract )
   	      $row = $row->toArray();

   	   if ( !key_exists('ASSINATURA', $row))
   	     return true;
   	   elseif( $row['ASSINATURA'] == null )
   	     return true;
   	   else
   	     return false;
   }
   function salvaRevisao($row){
   		if ( $this->_tabela_revisao == null ) return;
        $key = $this->info('primary');
  		$revisao = new Zend_Db_Table($this->_tabela_revisao);
  		$cols = $revisao->info('metadata');

  		$data = array();
  		foreach( $cols as $k=>$v ){
  			if ( isset($row[$k]) )
  			   $data[$k] = $row[$k];
  		}

  		$tab = $revisao->fetchAll(array($key[1].'=?'=>$row[$key[1]]),'revisao desc',1);

  		if ( $tab->count() > 0 ){
  			$data['REVISAO'] = $tab->current()->REVISAO+1;
  		} else {
  			$data['REVISAO'] = 1;
  		}

  		foreach ($data as $col=>$v){
    		if (@$this->_conf[$col]['cripto']=='Base64')
    		   $data[$col]=$this->encrypt_base64($v) ;
    		if ( @$this->_conf[$col]['cripto']=='cisweb') {
    		   $obj = new Zsam_Crypt_Cisweb;
    		   $data[$col]=$obj->encode($v) ;
    		}
    		if (@$this->_conf[$col]['cripto']=='MD5')
    		   $data[$col]=md5($v) ;
  		}

  		$revisao->insert($data);
   }
   public function findMultipleKey($arr){
   	 if ( is_array($arr) ) {
   	 	if (count($arr)<=1)
   	 	   return $this->find(@$arr[0]);
   	 	else {
   	 		$key = $this->info('primary');
   	 		$select = $this->select(true);
   	 		$x=0;
   	 		foreach ($key as $k){
   	 			$select->where(" $k = ? ",@$arr[$x]);
   	 			$x++;
   	 		}
   	 		return $this->getAdapter()->fetchAll($select);
   	 	}
   	 } else {
   	 	return $this->find($arr);
   	 }
   }
	public function updateMultiplesKeys($data,$arr){
   	   $key = $this->info('primary');
 	   $where = array();
   	   $x=0;
   	   foreach ($key as $k){
   	 		$where[" $k = ? "]=@$arr[$x];
   	 	    $x++;
   	   }
  	   return $this->update($data,$where);

	}

    public function deleteMultipleKey ($arr){
	   $key = $this->info('primary');
 	   $where = array();
   	   $x=0;
 	   foreach ($key as $k){
 	 		$where[" $k = ? "]=@$arr[$x];
 	 	    $x++;
 	   }
       $this->beforeDelete($where);
  	   return $this->delete($where);

   }

	public function deleteMultipleKeyAss ($arr){
		$key = $this->info('primary');
		$where = array();
		foreach ($key as $k){
			$where[" $k = ? "]=@$arr[$k];
		}
		$this->beforeDelete($where);
		return $this->delete($where);

	}

    public function beforeDelete($where)
    {
//    	$model = $this->_model;

//    	$table  = new Cisweb_Db_Abstract("relacionamentos");

//    	$select = $table->select()->where("REF_TABLE_CLASS = ?", $model);
//		$campos = $table->fetchAll($select)->toArray();


//		$count = count($campos);


//		echo $count;



    	//var_dump($this->info("metadata"));


    	//var_dump($where);
//    	die();
    }


}

?>