<?php
class Zsam_Db_Table extends Zend_Db_Table_Abstract
{
	var $_restrict;
	var $_conf;
	var $_criptkey;
	var $_autocomplet;
	var $_grid_records = 50;
	var $_tabela_revisao = null;

        public function init(){

        }
	public function getName(){
		return $this->_name;
	}
	public function getAutocompleteTitles(){
		if ($this->_autocomplet == null ){
			$cols = $this->info('cols');
			$this->_autocomplet = $cols[1];
		}


		return $this->_autocomplet;



	}
	
	public function getReferencemap(){
		return $this->_referenceMap;
	}
	
	public function printTitleFromId($id){
		return $this->printTitle($this->find($id)->current());

	}
	public function beforeValidade($form,$dados){


	}
    public function printTitle($row){
        $txt = "";
        $title = $this->getAutocompleteTitles();
        if (isset($row)){
            $row = $this->decrypt($row);
            if ( is_array($title) ) {
              foreach ($title as $t){
                  $data = $row[$t];
                  if ( $txt != "")
                      $txt .= " - ";

                  $txt .=  $data;
              }
            } else{
               $data = $row[$title];

               $txt = $data;
            }
        }
		return $txt;
	}
    public function autocomplete($search=null,$order = null, $count = null, $offset = null)
    {
        if ( $search == null ) {
           return $this->fetchAll();

        } elseif (is_array($search ) ) {

        	if ( isset($search['where']) )
                return $this->fetchAll($search['where']);

            else {
                $where = "";
                $title = $this->getAutocompleteTitles();
				
                $cols = $this->info(Zend_Db_Table_Abstract::COLS);
//                 Zend_Debug::dump($title,'TITLE');
//                 Zend_Debug::dump($this->_conf['CNPJ'],'CONF');
//                 Zend_Debug::dump($search,'DUMP 1');
                $cripto = new Zsam_Crypt_Cisweb();
//                 $search['term'] = $obj->encode($search['term']);
//                 Zend_Debug::dump($search,'DUMP 2');

                $andWhere   = '';
                $assinatura = null;
                $ativo      = null;
				
              	if (in_array('ASSINATURA', $cols)){
                    $assinatura = 'ASSINATURA != "" ';
                }

               if (in_array('ESTA_ATIVO', $cols)){
                    $ativo = 'ESTA_ATIVO = "S" ';
               }

                if(!is_null($assinatura))
                {
                	if(!is_null($ativo))
                	{
                		$andWhere = "AND ($assinatura) AND ($ativo)";
                	}else{
                		$andWhere = "AND ($assinatura)";
                	}
                }else{
                	if(!is_null($ativo))
                	{
                		$andWhere = "AND ($ativo)";
                	}
                }

				/*if(!is_null($search['restrict'])){
					$andWhere .= "AND ({$search['restrict']})";
				}*/	
				
				if(!is_null(@$search['restrict_map'])){
					$andWhere .= "AND ({$search['restrict_map']})";
				}

                if ( is_string($title) ){
                    //
//                  $where = " UCASE($title) like UCASE('%$search[term]%') ";
                    if(@isset($this->_conf["$title"]['cripto']) or @$this->_conf["$title"]['cripto'] != ''){
                        $search['term'] = $cripto->encode($search['term']);
                    }

                    $where = "( UCASE($title) like UCASE('%$search[term]%') )" . $andWhere;
                }

                if ( is_array($title) )
                {
                    foreach ($title as $t)
                    {
//                         Zend_Debug::dump($this->_conf["$t"]['cripto'],'TITLE T');
                        $termo_busca = $search['term'];
						if(@isset($this->_conf["$t"]['cripto']) or @$this->_conf["$t"]['cripto'] != ''){
                            $termo_busca 	= $cripto->encode($search['term']);
                        }

                        if ( $where != '')
                            $where.=' or ';
//                      $where.= " UCASE($t) like UCASE('%$search[term]%') ";
                        $where.= " UCASE($t) like UCASE('%$termo_busca%') ";
                    }

                    $where = "( $where ) $andWhere";
					
                }
//                 Zend_Debug::dump($where,'WHERE');
//                 Zend_Debug::dump($this->fetchAll($where,$order,$count,$offset),'FETCHALL');die();
                
				return $this->fetchAll($where,$order,$count,$offset); // filtra termo
            }
        } else {
           return $this->fetchAll($search,$order,$count,$offset);
        }
	}
	public function encrypt_base64($text)
    {
    	$key = $this->getCriptkey();
        return trim(base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $key, $text, MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND))));
    }

    public function decrypt_base64($text)
    {
    	$key = $this->getCriptkey();
        return trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, base64_decode($text), MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND)));
    }

    public function decrypt($data){
       
	    $sessao  = new Zend_Session_Namespace('externo');
		$banco   = $sessao->apoiosessao;
		
        $obj = new Zsam_Crypt_Cisweb;
        if (is_object($data))
        	if (get_class($data)== "Zend_Db_Table_Rowset")
        	$data = $data->toArray();
		if($banco == 'sdemo' ){
//			ini_set('memory_limit', '356M');

//		    print_r($data);
			
		}
	   
        foreach (@$data as $col=>$v){
        	if (@$this->_conf[$col]['cripto']=='Base64')
        		$data[$col]= $this->decrypt_base64($v);
        	if (@$this->_conf[$col]['cripto']=='cisweb'){
        		$data[$col]=$obj->decode($v) ;
        	}
        }
		if($banco == 'sdemo' ){
//			die('manutencao');
		}
        return $data;

        }

		
	public function rollBack($data, $operacao, $where = null){
	
		$table			 = new Cisweb_Db_RollBack();
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller = $controller->getControllerName();
		$nome_modulo	 = $controller->getModuleName();
		
		$table_rollback  = new Cisweb_Db_Abstract('rollback');
		$table_rollbacki = new Cisweb_Db_Abstract('rollback_item');
		
		$dados_rollback  = $table_rollback->select()->where('NOME_CONTROLADORA = ?', $nome_modulo.'_'.$nome_controller.'_index');
		$dados_rollback  = $table_rollback->fetchAll($dados_rollback)->toArray();
		
		if(count($dados_rollback) > 0){
			$controladora    =  $dados_rollback[0]['CONTROLADORA'];
			$dados_rollbacki =  $table_rollbacki->select()->where('CONTROLADORA = ?', $controladora)->where('TIPO_OPERACAO = ?', $operacao);
			$dados_rollbacki =	$table_rollbacki->fetchAll($dados_rollbacki)->toArray();
			
			if(count($dados_rollbacki) > 0){
				$operacao_item = $dados_rollbacki[0]['OPERACAO'];
				
				try{
					if(is_null($where)){
						$data = $table->$operacao_item($data);
					}else{
						$data = $table->$operacao_item($data, $where);
					}
				}catch(Exception $e ){
					echo $e;
					die('erro_rollback');
				}
			}
		}
		
		return $data;
	}	
		
	public function insert(array $data)
    {
		//$data = $this->rollBack($data,'D');

		$data = $this->beforeInsert($data);
    	$res  = parent::insert($data);
    	$this->afterInsert($res);
			
		//$this->rollBack($res,'A');
		
    	return $res;
    }

    public function beforeInsert(array $data)
    {
		
    	foreach ($data as $col=>$v){
    		if (@$this->_conf[$col]['cripto']=='Base64')
    		   $data[$col]=$this->encrypt_base64($v) ;
    		if ( @$this->_conf[$col]['cripto']=='cisweb') {
    		   $obj = new Zsam_Crypt_Cisweb;
    		   $data[$col]=$obj->encode($v) ;
    		}
    		if (@$this->_conf[$col]['cripto']=='MD5')
    		   $data[$col]=md5($v) ;


    		if (isset($this->_conf['FUNC_ALTERACAO']) &&
    							@$this->_conf['FUNC_ALTERACAO']['edit'] == 'N') {
	    		$data['FUNC_ALTERACAO'] = Zsam_User::getId();
    		}
    		if (isset($this->_conf['DATA_ALTERACAO']) &&
    								@$this->_conf['DATA_ALTERACAO']['edit'] == 'N') {
	    		$data['DATA_ALTERACAO'] = date('Y-m-d');
    		}
    		if (array_key_exists('FUNC_ALTERACAO', $this->_conf) && array_key_exists('DATA_ALTERACAO', $this->_conf) && array_key_exists('REVISAO', $this->_conf)) {
  				$data['REVISAO'] = 1;
    		}

    		if (isset($this->_conf['FUNC_CRIACAO']) && @$this->_conf['FUNC_CRIACAO']['edit'] == 'N') {
    			$data['FUNC_CRIACAO'] = Zsam_User::getId();
    		}

    		if (isset($this->_conf['DATA_CRIACAO']) && @$this->_conf['DATA_CRIACAO']['edit'] == 'N') {
    			$data['DATA_CRIACAO'] = date('Y-m-d');
    		}
    	}
    	return $data;
    }

    public function afterInsert($id)
    {

    	/* Bloco usado na estrutura de revisao */
    	$where = array();

    	if ( is_array($id) ){

    		foreach($id as $k => $v){
    			$where[" $k = ? "] = $v;
    		}

    	} else {

    		$tabela 		 	= $this->_name;
    		$table		 		= new Cisweb_Db_Abstract($tabela);
    		$table_describe		= $table->getDescribe();

    		foreach ($table_describe as $k => $v){

				if($v['PRIMARY']){
					$where[" $k = ? "] = $id;
				}
			}
    	}

    	$this->criarRevisoes($where, "insert");
        $this->logins($where);//inserir dados de controle de inserção
    	/*Fim do bloco*/
    }

	public function update(array $data, $where)
    {
		//$data = $this->rollBack($data,'E', $where);
	
    	$data = $this->beforeUpdate($data, $where);
    	$res  = parent::update($data, $where);
    	$this->afterUpdate($res,$where);
//        $this->logupd($where);
    	return $res;
    }

    public function beforeUpdate(array $data, $where)
    {
    	$this->criarRevisoes($where, "edit");//irá criar a revisão antes de fazer a alteração

    	foreach ($data as $col=>$v){
    		if (@$this->_conf[$col]['cripto']=='Base64')
    		   $data[$col]=$this->encrypt_base64($v) ;
    		if ( @$this->_conf[$col]['cripto']=='cisweb') {
    		   $obj = new Zsam_Crypt_Cisweb;
    		   $data[$col]=$obj->encode($v) ;
    		}
            if (@$this->_conf[$col]['cripto']=='MD5')
    		   $data[$col]=md5($v) ;
    	}
		if ( !key_exists('ASSINATURA', $data) ){
			try {
				$data_old = array();
				$reg = $this->fetchAll($where)->current();
				if ( $reg != null )
					$data_old = $reg->toArray();

				$alteracao = false;
				foreach ($data as $col=>$v){
					if (@$data_old[$col]!=$v){
						$alteracao=true;
						break;
					}
				}
			} catch (Exception $e){
				$alteracao = false;
			}
			if ( $alteracao ) {
	    	    if (isset($this->_conf['FUNC_ALTERACAO']) &&
	    	    				@$this->_conf['FUNC_ALTERACAO']['edit'] == 'N') {
		    		$data['FUNC_ALTERACAO'] = Zsam_User::getId();
	    		}
	    		if (isset($this->_conf['DATA_ALTERACAO']) &&
	    							@$this->_conf['DATA_ALTERACAO']['edit'] == 'N') {
		    		$data['DATA_ALTERACAO'] = date('Y-m-d');
	    		}
                        if (array_key_exists('DATASINC', $data)){
                            //$data['DATASINC'] = null;
                        }
		    	if (array_key_exists('REVISAO', $this->_conf)) {
		    		if (empty($data['REVISAO'])) {
			    		$data['REVISAO'] = new Zend_Db_Expr('COALESCE(REVISAO,0)+1'); // Adiciona o valor 1 para entidades
			    																	 //	 que não tiverem esse campo setado
		    		} else {
			    		$data['REVISAO'] = new Zend_Db_Expr('REVISAO+1');
		    		}
	    		}
			}
    	}
    	return $data;
    }

    public function afterUpdate($id,$where)
    {
    }

    public function criarRevisoes($where, $operador){

    	/*  Controle de revis�es: Incluir nesse formato na Model:

    	 	var $revisao	  		= 'S';
    		var $quantidade_revisao	= 19 					 (caso n�o set esse atributo o padr�o = 10, para registrois ilimitados atribua 999);
    		var $_tabela_revisao	= "nome_tabela_revisao"  (caso n�o set esse atributo a tabela de revisao sera "nome_da_tabela" + rev

    		A tabela de revisao deve ser identica a original, sem as chaves (Remover somente as chaves, n�o os campos correspondentes)
    		com um campo AUTOINCREMENT como chave primaria e com nome diferente de REVISAO

    		==== Operador ====
    		Sera gravado no campo revisao, onde:
    		operador = 0    (quando esta inserindo)
    		operador = 9999 (quando esta deletando)
    		operador = 9998 (quando esta editando )

    	*/

    	if(@$this->revisao == 'S'){

    		try {

    			$tabela 		 	= $this->_name;
    			$quantidade_revisao	= @$this->quantidade_revisao;

    			if(is_null($this->_tabela_revisao)){
    				$tabela_revisao	 	= $tabela."rev";
    			}else{
    				$tabela_revisao	 	= $this->_tabela_revisao;
    			}

    			if($operador == "insert"){

    				$operador = 0;

    			}else if($operador == "delete"){
    				$operador = 9999;
    			}else{
    				$operador = 9998;
    			}

    			$table		 		= new Cisweb_Db_Abstract($tabela);
    			$table_describe		= $table->getDescribe();
    			$table_adapter		= $table->getAdapter();

    			/*Captura estrutura da tabela de revisao*/
    			$table_rev		 	= new Cisweb_Db_Abstract($tabela_revisao);
    			$table_rev_describe	= $table_rev->getDescribe();
    			$table_rev_adapter	= $table_rev->getAdapter();


    			/* Estrutura de compara��o entre tabelas e suas tabelas de revis�o, sera utilizado em proxima atualiza��o, n�o remover*/
    			/*$array	= array();
    			 foreach ($table_describe as $k => $v){
    				$array[$k] = $k;
    			}

    			$array_rev			= array();
    			foreach ($table_rev_describe as $k => $v){
    			$array_rev[$k] = $k;
    			}

    			$array_campos_faltando = array();
    			foreach ($array as $v){

    			if(!array_key_exists($v, $array_rev)){
    				$array_campos_faltando[$v] = $v;
    			}
    			}*/
    			/*Fim do bloco*/

    			/*Verifica se o numero de revis�es atingiu o maximo estipulado*/

    			if(is_null($quantidade_revisao)){
    				$quantidade_revisao = 10;
    			}

    			$chaves_primarias = array();
    			foreach ($table_rev_describe as $k => $v){
    				if($v['PRIMARY']){
    					$chaves_primarias[$k] = $k;
    				}
    			}

    			$order = array();

    			/*Monta o array de ordenamento de modo que a posi��o zero seja sempre o registro mais antigo da tabela de revis�o (o que vai ser deletado) */
    			foreach ($chaves_primarias as $k => $v){
    				$order[] = "$k";
    			}

    			$dados_numero_registros_revisoes = $table_rev->select()->order($order);

    			$dados_numero_registros_revisoes = $table_rev->fetchAll($dados_numero_registros_revisoes)->toArray();
    			$numero_registros_revisoes 		 = count($dados_numero_registros_revisoes);

    			if( $numero_registros_revisoes > 0 && $numero_registros_revisoes >= $quantidade_revisao && $quantidade_revisao != 999){

	    			$registro_deletar = $dados_numero_registros_revisoes[0];

	    			$numero_chaves_primarias = count($chaves_primarias);
	    			$count					 = 0;
	    			$where_registro_deletar  = "";

	    			foreach ($chaves_primarias as $k => $v){

		    			$count ++;

		    			if($count == 0 || $count == $numero_chaves_primarias){
		    			$where_registro_deletar .= "$k = '{$registro_deletar[$k]}'";
		    			}

		    				if($count > 0 && $count < $numero_chaves_primarias){
		    				$where_registro_deletar .= "$k = '{$registro_deletar[$k]}' AND ";
		    			}
	    			}

	    			$table_rev->delete($where_registro_deletar);
    			}

    			/*Busa e prepara os dados que v�o pra tabela de revis�o */
    			$dados = $table->select();


    			if(is_array($where)){

	    			foreach ($where as $k => $v){
	    				$dados = $dados->where($k,$v);
	    			}
    			}else{
    				$dados = $dados->where($where);
    			}

    			$dados = $table->fetchRow($dados)->toArray();

    			/*Usado como teste para verificar campos autoincrement na chave primaria (Retirar da vers�o final) */
    			// foreach ($table_describe as $k => $v){
    			// 		/*Limpa o campo referente a Chave primaria autoincrement*/
    			// 		if($v['PRIMARY'] && $v['IDENTITY']){
    			// 			unset($dados[$k]);
    			// 		}
    			// }

    			$auth 	= Zend_Auth::getInstance();
    			$user 	= $auth->getStorage()->read();
    			$funcao = @$user['FUNCAO'];
    			$id     = @$user['ID'];
    			$nome   = @$user['NOME'];
    			$nivel  = @$user['NIVEL'];

    			$dados['FUNC_ALTERACAO'] = $id;
    			$dados['DATA_ALTERACAO'] = date("Y-m-d");
    			$dados['REVISAO']		 = $operador;

    			$table_rev->insert($dados);

    			/*Sera utilizado em proxima autaliza��o n�o retirar*/
    			//$query  = "SHOW CREATE TABLE `$tabela_revisao`";
    			//$create = $table_rev_adapter->query($query);

    		} catch (Exception $e) {
    			Zend_Debug::dump($e);
    		}
    	}
		//die("End");
    }


    public function setAdaptador($banco = '')
    {
    	$db1 = new Zend_Db_Adapter_Pdo_Mysql(array(
    			'host'     => $this->config->Host,
    			'username' => $this->config->Username,
    			'password' => $this->config->Password,
    			'dbname'   => "$banco"
    	));

    	$this->registry = $db1;
    }


	public function getCriptkey(){
		if ($this->_criptkey == null)
		  $this->_criptkey = md5(get_class($this));

		return $this->_criptkey;
	}
	public function __construct($config = array())
    {
      parent::__construct($config);
      $this->confRestrict();
    }
	private function confRestrict(){
	  return;
	}

	public function fetchRow($where = null,
                            $order = null,
                            $restrict = true)
    {
      if ($restrict&&
          isset($this->_restrict)&&
          is_string($this->_restrict))
      {
         if (is_array($where))
         {
            $where[] = $this->_restrict;
         } else {
            $where = '('.$this->_restrict.') AND ('.$where.')';
         }
      } elseif ($restrict&&
                isset($this->_restrict)&&
                is_array($this->_restrict))
      {
         if (is_array($where))
         {
            $where = array_merge($where, $this->_restrict);
         } else {
            foreach ($this->_restrict as $contraint) {
               $where = '('.$contraint.') AND ('.$where.')';
            }
         }
      }
      $res = parent::fetchRow($where,$order);
      return $res;
   }

	public function fetchAll($where = null, $order = null, $count = null, $offset = null, $restrict = true)
    {	
		ini_set('memory_limit','384M');
        if ($restrict && isset($this->_restrict)&& is_string($this->_restrict)) {
            if (is_array($where)) {
                $where[] = $this->_restrict;
            } else {
            	if ($where instanceof Zend_Db_Table_Select) {
                    $where->where($this->_restrict);
                } elseif ($where != null) {
                    $where = array($this->_restrict, $where);
                } else { 
                    $where = array($this->_restrict);
                }
            }
        } elseif ($restrict && isset($this->_restrict) && is_array($this->_restrict)) {
            if (is_array($where)) {
                $where = array_merge($where, $this->_restrict);
            } else {
                if ($where instanceof Zend_Db_Table_Select) {
                    $where->where($this->_restrict);
                } elseif ($where != null) {
                    $where = array_merge(array($where), $this->_restrict);
                } else {
                    $where = $this->_restrict;
                }
            }
        }
        $res = parent::fetchAll($where, $order, $count, $offset);
        return $res;
    }


	public function fetchAllJson($where = null, $order = null, $count = null, $offset = null, $restrict = true)
    {
		ini_set('memory_limit','256M');
		 if ($restrict && isset($this->_restrict) && is_string($this->_restrict)) {
			 if(!is_array($where) && !is_string($where)) {
				if ( $where != NULL ) {
					  $where = $where->where($this->_restrict);
				}else {
					 $where = $this->_restrict;
				}
			 }else {
				$where = $this->_restrict;
			 }
		  }elseif ($restrict && isset($this->_restrict) && is_array($this->_restrict)) {
			 if(!is_array($where) && !is_string($where)) {
				if ( $where != NULL ) {
					foreach($this->_restrict as $k => $v) {
						$where = $where->where($this->_restrict[$k]);
					}
				}else {
					  $where = $this->_restrict;
				}
			 }else {
				$where = $this->_restrict;
			 }
		 }
//echo $where;die('ttttt');
      $res = parent::fetchAll($where, $order, $count, $offset);
      return $res;
   }

   function getColsGrid(){
   	    $cols = $this->info('cols');
   	    $grid = array();
	   	if ( empty($this->_conf) || !is_array($this->_conf) ) {
	   		$grid = array_slice ($cols,0,10);
	   	} else {
	   	   foreach ($this->_conf as $f=>$v){
	   	   	  if (!in_array($f, $cols)) continue;
	   	   	  if (@$v['grid']==true && @$v['level'] <= Zsam_User::getLevel())
	   	   	     $grid[]=$f;
	   	   }
	   	   if (count($grid)==0)
	   	      $grid = array_slice ($cols,0,10);
	   	}
	   	return $grid;

   }
   function getDescribe(){
   	    $meta = $this->info('metadata');
   	    if ( !empty($this->_conf) && is_array($this->_conf) ) {
            $newmeta = array();
   	        foreach ($meta as $k=>$v){
   	           if ( is_array(@$this->_conf[$k]) )
   	             $newmeta[$k] = array_merge($v,$this->_conf[$k]);
   	           else
   	             $newmeta[$k] = $v;
   	        }
   	    	return $newmeta;
   	    } else {
   	      return $meta;
   	    }


   }
   function canUpd($row){
   	   if ( $row instanceof Zend_Db_Table_Row_Abstract )
   	      $row = $row->toArray();

   	   if ( !key_exists('ASSINATURA', $row))
   	     return true;
   	   elseif( $row['ASSINATURA'] == null )
   	     return true;
   	   else
   	     return false;
   }
   function salvaRevisao($row){
   		if ( $this->_tabela_revisao == null ) return;
        $key = $this->info('primary');
  		$revisao = new Zend_Db_Table($this->_tabela_revisao);
  		$cols = $revisao->info('metadata');

  		$data = array();
  		foreach( $cols as $k=>$v ){
  			if ( isset($row[$k]) )
  			   $data[$k] = $row[$k];
  		}

  		$tab = $revisao->fetchAll(array($key[1].'=?'=>$row[$key[1]]),'revisao desc',1);

  		if ( $tab->count() > 0 ){
  			$data['REVISAO'] = $tab->current()->REVISAO+1;
  		} else {
  			$data['REVISAO'] = 1;
  		}

  		foreach ($data as $col=>$v){
    		if (@$this->_conf[$col]['cripto']=='Base64')
    		   $data[$col]=$this->encrypt_base64($v) ;
    		if ( @$this->_conf[$col]['cripto']=='cisweb') {
    		   $obj = new Zsam_Crypt_Cisweb;
    		   $data[$col]=$obj->encode($v) ;
    		}
    		if (@$this->_conf[$col]['cripto']=='MD5')
    		   $data[$col]=md5($v) ;
  		}

  		$revisao->insert($data);
   }
   public function findMultipleKey($arr){
   	 if ( is_array($arr) ) {
   	 	if (count($arr)<=1)
   	 	   return $this->find(@$arr[0]);
   	 	else {
   	 		$key = $this->info('primary');
   	 		$select = $this->select(true);
   	 		$x=0;
   	 		foreach ($key as $k){
   	 			$select->where(" $k = ? ",@$arr[$x]);
   	 			$x++;
   	 		}
   	 		return $this->getAdapter()->fetchAll($select);
   	 	}
   	 } else {
   	 	return $this->find($arr);
   	 }
   }
	public function updateMultiplesKeys($data,$arr){
   	   $key = $this->info('primary');
 	   $where = array();
   	   $x=0;
   	   foreach ($key as $k){
   	 		$where[" $k = ? "]=@$arr[$x];
   	 	    $x++;
   	   }
  	   return $this->update($data,$where);

	}

    public function deleteMultipleKey ($arr){
	   $key = $this->info('primary');
 	   $where = array();
   	   $x=0;
 	   foreach ($key as $k){
 	 		$where[" $k = ? "]=@$arr[$x];
 	 	    $x++;
 	   }
       
 	   $this->beforeDelete($where);
       
//       if($before){
       		return $this->delete($where);
//       }else{
       	
//       		echo '<script>alert("Impossível deletar o registro");</script>';//
//       		echo "<script>window.location.reload()</script>";
//       		die;
//       }
   }

	public function deleteMultipleKeyAss ($arr){
		$key = $this->info('primary');
		$where = array();
		foreach ($key as $k){
			$where[" $k = ? "]=@$arr[$k];
		}
		$this->beforeDelete($where);
		return $this->delete($where);

	}
	
	public function logdel($where){
		
		$tabela   = $this->_name;
		$usuario  = Zsam_User::getId();  
		$registro = '';
		$data_del = date('Y-m-d G:i:s');
		
//		print_r($where);die('Manutencao');
//		foreach ($where as $k => $v){
//			$registro .=  "$v  ";
//		}
        if(!is_string($where)) {
            foreach ($where as $k => $v){
                $registro .=  "$v  ";
            }
        }else{
			$registro = $where;
		}
        
		
		$data['TABELA']   = $tabela;
		$data['REGISTRO'] = $registro;
		$data['DATA_DEL'] = $data_del;
		$data['USUARIO']  = $usuario;
		
		$table_logdel 	  = new Cisweb_Db_Abstract('logdel');
		$table_logdel->insert($data); 
	}

    public function logupd($where){
        
        $tabela   = $this->_name;
        $usuario  = Zsam_User::getId();  
        $registro = '';
        $data_upd = date('Y-m-d G:i:s');
        
        if(!is_string($where)) {
            foreach ($where as $k => $v){
                $registro .=  "$v  ";
            }
        }else{
			$registro = $where;
		}
        
        if ($registro != '') {

            $data['TABELA']   = $tabela;
            $data['REGISTRO'] = $registro;
            $data['DATA_UPD'] = $data_upd;
            $data['USUARIO']  = $usuario;
            
            $table_logupd = new Cisweb_Db_Abstract('logupd');
            $table_logupd->insert($data); 
        }

    }

    public function logins($registro){

		$tabela   = $this->_name;
        $usuario  = Zsam_User::getId();  
        $data_ins = date('Y-m-d G:i:s');

        $reg = '';
        if(!is_string($registro)) {
            foreach ($registro as $k => $v){
                $reg .=  "$v  ";
            }
        }else{
			$reg = $registro;
		}
        

        $data['TABELA']   = $tabela;
        $data['REGISTRO'] = $reg;
        $data['DATA_INS'] = $data_ins;
        $data['USUARIO']  = $usuario;
        $lista			  = array('bancoextrato','cotacaoforneitens','cotacaoforneorm','cotacao_itemforne','logins','logdel','logupd','log');
        try {
			if (!in_array($tabela,$lista)){
				if ($tabela[0] <> 'z'){
					if (substr($tabela,0,4) <> 'erro'){
						$table_logins = new Cisweb_Db_Abstract('logins');
						$table_logins->insert($data);
					}
				}
			}
        } catch (\Exception $e) {

        }
    }

    public function beforeDelete($where)
    {
        $controller      = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action     = $controller->getActionName(); //pegar a controladora
        $nome_modulo     = $controller->getModuleName();

   	    $translate    = Zend_Registry::get('Zend_Translate');
    	$this->logdel($where);
       	// $this->criarRevisoes($where, "delete");
		
    	// Rotina que verifica os relacionamentos antes de deletar
		$model  = get_class($this);
		
		$table_1= new $model();
		
		$chave  = $table_1->info('primary');
		
   		$table  = new Cisweb_Db_Abstract("relacionamentos");
   		$select = $table->select()->where("REF_TABLE_CLASS = ?", $model);
		$campos = $table->fetchAll($select)->toArray();

		foreach($campos as $k => $v){
			
			$class   		= $v['CLASS'];
			$columns 		= $v['COLUMNS'];
			$ref_columns	= $v['REF_COLUMNS'];
			
			if (strpos($class, 'DbTable_Z')){
				continue;
			}
			
			$id_chave 		= 0;
			if (in_array($ref_columns, $chave)){
				$id_chave = 1;
			}
			
			$dados_chave = array();
			if ($id_chave == 0){
				foreach($where as $key => $value){
					$where_1[] = $value;
				}
				$dados_chave = $table_1->findMultipleKey($where_1);
				$value = $dados_chave[0][$ref_columns];
				$where_ref = "$columns = '$value'";
			}else{
				foreach($where as $key => $value){
					$where_ref = "$columns = '$value'";
				}
			}
			
			$class			= new $class();

			$tabela         = $class->getName();
			// $class			= new Cisweb_Db_Abstract($tabela);
			
			$dados_ref  = $class->select()->where($where_ref);
            try {
                $dados_ref  = $class->getAdapter()->fetchAll($dados_ref);
                if (!empty($dados_ref)) {
                    echo '<script>alert("'.$translate->translate('nao_pode_remover').'");</script>';
                    echo '<script>window.location="/cisweb/public/'.$nome_modulo.'/'.$nome_controller.'"</script>';
                    die();
                    return false;
                }

                
            } catch (\Exception $e) {

            }

    	}
        return true;
    }

    /* funcao criada para inserir o fornecedor como cliente ... usado na nfe
     * parametros codigo do fornecedor ou cnpj forne
     *
     */

    public function InsereForne_Cliente($cod_forne = null , $cnpj_forne = null)
    {
    	
    	if (is_null($cnpj_forne) && is_null($cod_forne))
    	{
    		return false;
    	}
    	
    	if (!is_null($cnpj_forne))
    	{
    		$table_forne 	 = new Cisweb_Db_Abstract("forne");
    		$dados_forne     = $table_forne->getAdapter()->fetchRow($table_forne->select()->where(("CNPJ = '$cnpj_forne'")));
    		$cnpj_forne      = $dados_forne['CNPJ'];
    	}

    	if (is_null($cnpj_forne))
    	{
    		$table_forne 	 = new Cisweb_Db_Abstract("forne");
    		$dados_forne     = $table_forne->getAdapter()->fetchRow($table_forne->select()->where(("CODIGO = '$cod_forne'")));
    		$cnpj_forne      = $dados_forne['CNPJ'];
    	}
    	
    	$table_cliente 	= new Cisweb_Db_Abstract("cliente");
    	$dados_cliente  = $table_cliente->getAdapter()->fetchRow($table_cliente->select()->where(("CNPJ = '$cnpj_forne'")));

    	if(count($dados_cliente)==1){
    		$data_cliente['NOME'] 		= $dados_forne['NOME'];
    		$data_cliente['CNPJ'] 		= $dados_forne['CNPJ'];
    		$data_cliente['FANTASIA']	= $dados_forne['FANTASIA'];
    		$data_cliente['IE'] 		= $dados_forne['IE'];
    		$table_cliente->insert($data_cliente);
    		$dados_cliente     	= $table_cliente->getAdapter()->fetchRow($table_cliente->select()->where(("CNPJ = '$cnpj_forne'")));
    	}

    	return $dados_cliente;
    }
	
	public function selectcheckbox($model,$attribs,$idItem = null)
    {
		
    	$table 			= new $model();
    	$controller 	= Zend_Controller_Front::getInstance()->getRequest();
    	$rowset 		= array();
    	$adapter 		= $table->getAdapter();
    	$var 			= $table->info();
        

        //@$idItem = $_SESSION['item']['id'];
        if (is_null($idItem))
        {
            $idItem = $controller->getParam('id');
        }
		

        if (isset ( $attribs ['idWhere'] ))
        {

            if(isset ( $attribs ['valueWhere'] ))
            {
                $idItem = $attribs ['valueWhere'];
            }

            $tipo_var = gettype($attribs ['idWhere']);


            $select = $table->select()
            ->setIntegrityCheck(false)
            ->from( $var ['name'], $attribs ['columns']);

            if ($tipo_var == 'array')
            {
                $idItem=$controller->getParam('id');
                $id_grid = explode(':',$idItem);

                if (isset($attribs ['restrict']))$select = $select->where($attribs['idWhere'][0] . "=?",$id_grid[0])->where($attribs['idWhere'][1] . "=?",$id_grid[1])->where($attribs['restrict']);

                if (isset($attribs ['order_item']))
                {
                    $select 	= $select->where($attribs['idWhere'][0] . "=?",$id_grid[0])->where($attribs['idWhere'][1] . "=?",$id_grid[1])->order($attribs['order_item']);
                }
                else
                {
                    $select 	= $select->where($attribs['idWhere'][0] . "=?",$id_grid[0])->where($attribs['idWhere'][1] . "=?",$id_grid[1]);
                }
            }
            else
            {

                $idItem = explode(':',$idItem);
                $idItem = $idItem[0];

                if (isset($attribs ['restrict']))$select = $select->where($attribs['idWhere'] . "=?",$idItem)->where($attribs['restrict']);

                if (isset($attribs['order_item']))
                {
                    $select 	= $select->where($attribs['idWhere'] . "=?",$idItem)->order($attribs['order_item']);
                }
                else
                {
                    $select 	= $select->where($attribs['idWhere']. "=?",$idItem);
                }
            }
        }
		
		$rowset = $adapter->fetchAll($select);
		
		//Formata valores double	
		foreach($rowset as $k => $v){
			
			foreach($v as $key => $value){
				
				$tipo_campo = @$var['metadata'][$key]['DATA_TYPE'];
				
				if(count(explode("double", $tipo_campo)) > 1){
				
					$precisao = explode(',', $tipo_campo);
					$precisao = substr($precisao[1],0,1);
					
					$rowset[$k][$key] = number_format($value,$precisao,',','.');
				}
			}
		}
		
		return $rowset;
    }
}

?>