<?php

class Zsam_Controller_Relatorio_bkpGeral extends Zsam_Controller {

		var $_campos   = array();  	// define os campos do relatorio
		var $_order = array();		// define os campos para odernar a pesquinsa
		var $_group = null;			// define os campos para agrupar a pesquinsa
		var $_layout = null;			// define o layout do relatorio
		var $_table = null;			// define a tabela para consulta do relatorio
		var $_de = Array();			// define o parametro DE para limitar a consulta
		var $_ate = Array();			// define o parametro AT para limitar a consulta
		var $_filtro = Array();		// define o parametro de FILTRO para limitar a consulta (Geralmente  o mesmo campo do $group)
	
	public $rowset;
	
	public function indexAction() {
		$this->_helper->layout->disableLayout();
		$this->view->addScriptPath(APPLICATION_PATH . '/views/scripts/relatorio');
		$this->_helper->viewRenderer->setRender("$this->_layout");
	
    }
    
	public function init()
	{	
		require_once ('mpdf'.DIRECTORY_SEPARATOR.'mpdf.php');
		
		Zend_Layout::getMvcInstance()->assign('nome_filtro',$this->_filtro[0]);
		$table = new $this->_table();
		$table instanceof Zsam_Db_Table;
		$ref_map = $table->info('referenceMap');
		$name = $table->getName();
		$where = "";
		$select = $table->select()->from( $table->getName(),$this->_filtro[0])->group($this->_filtro[0]);
		
		$adapter = $table->getAdapter();
		$this->rowset = $adapter->fetchAll($select);
		$this->rowset = $table->decrypt($this->rowset);
		
			foreach($this->rowset as $k => $v){
  			foreach ($v as $campo => $linha){
 				if (array_key_exists($campo, $ref_map)){
 					$this->rowset[$k]["$v[$campo]"]= $this->refMap($ref_map,$campo,$v[$campo]);
 					unset($this->rowset[$k]["$campo"]);
 				}
 			}	
		}
		
		Zend_Layout::getMvcInstance()->assign('table_filtro', $this->rowset);
		Zend_Layout::getMvcInstance()->assign('group', $this->_group);
	}
	

	public function relatorioAction(){

		$this->_helper->layout->disableLayout();
		$this->view->addScriptPath(APPLICATION_PATH . '/views/scripts/relatorio');
		$this->_helper->viewRenderer->setRender("$this->_layout");
		Zend_Layout::getMvcInstance()->assign('group', $this->_group);
		if ($this->getRequest()->isPost()) {
		
			$formData = $this->getRequest()->getPost();
			$this->_de[1] = $formData['de'];
			$this->_ate[1] =$formData['ate'];
			$this->_filtro[1] = $formData['filtro'];
			$this->view->table = $this->relatorio();
		}
	}		
		
	public function relatorio(){

		$form['de']=$this->_de[1];
		$form['ate']=$this->_ate[1];
		$form['filtro']=$this->_filtro[1];
		Zend_Layout::getMvcInstance()->assign('form', $form);
		$table = new $this->_table();
		$table instanceof Zsam_Db_Table;
		$name = $table->getName();
		$ref_map = $table->info('referenceMap');
		$table_prop = $table->getDescribe();
		$where = "";
		$select = $table->select()->setIntegrityCheck(false)->from($name,$this->_campos)->order($this->_order);
		if ((isset($this->_filtro[1]))&&(($this->_filtro[1])!= '')){
			$select = $select->where($this->_filtro[0]." =?", $this->_filtro[1]);
		}
		if ((isset($this->_de[1]))&& ($this->_de[1] != '')){
			$select = $select->where($this->_de[0]."<=?", $this->_de[1]);
		}
		if ((isset($this->_ate[1]))&&(($this->_ate[1] != ''))){
			$select = $select->where($this->_ate[0]." >=?", $this->_ate[1]);
		}
		$adapter = $table->getAdapter();
 		$this->rowset = $adapter->fetchAll($select);
		
			foreach($this->rowset as $k => $v){
  			foreach ($v as $campo => $linha){
 				if (array_key_exists($campo, $ref_map)){
 					$this->rowset[$k][$campo]= $this->refMap($ref_map,$campo,$v["$campo"]);
 				}
 				if (array_key_exists($campo, $table_prop)){
 					if ($table_prop[$campo]["DATA_TYPE"]=="date"){
//  						Zend_Debug::dump($linha);die();
 						$date= new DateTime($linha);
 						$this->rowset[$k][$campo] = date_format($date, 'd-m-Y');
 					}
 				}
  			}	
 		}
 					
		$this->rowset = $table->decrypt($this->rowset);
 		 return  $this->rowset;

		}
	
	public function refMap($ref_map,$campo,$valor){
		$map=($ref_map[$campo]);
		if (count($map["refTableClass"])==2){
			$table1 = ($this->table($map["refTableClass"]["table1"]));
			$table2 = ($this->table($map["refTableClass"]["table2"]));
			$array= array($table1,$table2);
			$array = array_unique($array);
			$array = array_shift($array);
			foreach ($array as $k=>$v){
				$key = array_search($valor, $v);
				if ($key!=null){
					$array = $array[$k];
					break;
				}
			}
			$descricao = ($array[$map['refTitle']]);
		}
		else{
	
			$table =  $this->table($map["refTableClass"]);
// 			Zend_Debug::dump($table);die();
			foreach ($table as $k=>$v){
				$key = array_search($valor, $v);
// 		Zend_Debug::dump($v);die();
				if ($key!=null){
					$table = $table[$k];
					break;
				}
			}
			$descricao = $table[$map['refTitle']];
		}
		return ($descricao);
	}
	
	public function table($table){
		$tbl = new $table();
		$tbl instanceof Zsam_Db_Table;
		$adapter = $tbl->getAdapter();
		$select = $tbl->select();
		$rowset = ($adapter->fetchAll($select));
		foreach($rowset as $k => $v){
			$rowset[$k] = $tbl->decrypt($v);
		}
		return $rowset;
	}
	
	public function pdfAction(){
		$formData = $this->getRequest()->getPost();
		$this->_de[1] = $formData['de'];
		$this->_ate[1] =$formData['ate'];
		$this->_filtro[1] = $formData['filtro'];
		$this->view->table  = $this->relatorio();
		$this->_helper->layout->disableLayout();
		$this->view->addScriptPath(APPLICATION_PATH . '/views/scripts/relatorio');
		$this->_helper->viewRenderer->setRender("$this->_layout");
		Zend_Layout::getMvcInstance()->assign('group', $this->_group);

		$html = $this->view->render("$this->_layout".'.phtml');
		$html = utf8_encode($html);
		$header = $this->view->render('header.phtml');
		$footer = $this->view->render('footer.phtml');
		$mpdf=new mPDF('','A4','','',20,15,30,25,10,10);
// 		$stylesheet = file_get_contents($_SERVER['DOCUMENT_ROOT'].'\css\relatorios.css');
// 		$mpdf->WriteHTML($stylesheet,1);
		$mpdf->SetHTMLHeader($header); 
     	$mpdf->autoMarginPadding = 1;	
   		$mpdf->SetHTMLFooter($footer);
		$mpdf->WriteHTML($html);

		$mpdf->Output();
		exit;

	}
	public function xlsAction(){
		$formData = $this->getRequest()->getPost();
		$this->_de[1] = $formData['de'];
		$this->_ate[1] =$formData['ate'];
		$this->_filtro[1] = $formData['filtro'];
		$this->view->table  = $this->relatorio();
		$this->_helper->layout->disableLayout();
		$this->view->addScriptPath(APPLICATION_PATH . '/views/scripts/relatorio');
		$this->_helper->viewRenderer->setRender("$this->_layout");
		Zend_Layout::getMvcInstance()->assign('group', $this->_group);
		
		$html = $this->view->render("$this->_layout".'.phtml');

		header("Content-type: application/x-msexcel; charset=utf");

		header("Content-Disposition: attachment; filename='planilha.xls'");
		header("Content-Description: PHP Generated Data");
		echo $html;
		
		exit;
	}
	
}

?>
