<?php

class Zsam_Controller_Form_SimpleDynamic extends Zsam_Controller_Form_Simple {

    var $view_controller = "simple-dynamic";

    public function getElementoAction() {
        $this->_helper->layout->disableLayout();
        $request = $this->getRequest();
        $elemento = $request->getParam('elemento', null);
        if ($elemento == null)
            die('Elemento não informado');
        $table_class = $this->zsam_table;
        $table = new $table_class();
        $result = $table->findMultipleKey(explode(':', $request->getParam('id')));
        if (0 == count($result)) {
            die('Registro não encontrado');
        }
        $row = $table->decrypt($result);
        $row = array_shift($row);
        $form = new Zsam_Form_Simple($this->zsam_table, $this->dependentes, $this->zsam_form_group, $this->zsam_form_ajax, $this->zsam_form_script, $defaultValues = null, $this->getRequest()->getParam('id'));
        $form->populate($table->decrypt($row));
        $elementoObj = $form->getElement($elemento);

        if ($elementoObj == null)
            die('Elemento "' . $elemento . '" não encontrado');

        $this->view->elemento = $elementoObj;
    }

    public function saveElementoAction() {

        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender(TRUE);
        $table_class = $this->zsam_table;
        $table = new $table_class();
        $request = $this->getRequest();
        $result = $table->findMultipleKey(explode(':', $request->getParam('id')));
        if (0 == count($result)) {
            echo json_encode(array("result" => 0, "message" => "Parametros Inválidos"));
            return;
        }
        $row = $table->decrypt($result);
        $row = array_shift($row);
        $form = new Zsam_Form_Simple($this->zsam_table, $this->dependentes, $this->zsam_form_group, $this->zsam_form_ajax, $this->zsam_form_script, $defaultValues = null, $this->getRequest()->getParam('id'));
        $form->setAction($this->getActionForm());
        $form->setRequiredPasswords(false);
        $canEdit = $table->canUpd($row);
        if (!$canEdit) {
            echo json_encode(array("result" => 0, "message" => "Registro não pode ser editado"));
            return;
        }

        if (!$this->getRequest()->isPost()){
            echo json_encode(array("result" => 0, "message" => "Dados não enviados"));
            return;
        }
        
        if ($this->getRequest()->isPost()) {

            $formData = $this->getRequest()->getPost();            
            $formValue = $formData; //incluido em 09/07/2013 por Reinaldo e Tiago para evitar problemas de apagar campos que não estão na controladora empresa
            $data = array();
            $fields = $table->getDescribe();

            $elemento = key($formData);
            foreach ($fields as $key => $f) {
                if ( $key != $elemento ) continue;
                
                if ($f['IDENTITY'] or $f['PRIMARY'])
                    continue;

                if (isset($f['type']) && $f['type'] == 'upload') {
                    if (!$form->$key->receive())
                        throw new Zend_Validate_Exception("Arquivo não pode ser enviado");
                    if ($form->$key->isUploaded()) {
                        $arquivo = $_FILES[$key]['tmp_name'];
                        $tamanho = $_FILES[$key]['size'];
                        $fp = fopen($form->$key->getFileName(), "rb");
                        $conteudo = fread($fp, $tamanho);
                        //$conteudo = addslashes($conteudo);
                        fclose($fp);
                        $nome = $form->$key->getFilenAME();

                        $imagem = base64_encode($conteudo);
                        //$img = new Zend_Form_Element_Image;
                        //$img->setImage($conteudo);
                        $data[$key] = $imagem;
                    }
                    continue;
                }
                if (isset($f['level']) && $f['level'] > Zsam_User::getLevel())
                    continue;
                if (isset($f['type']) && $f['type'] == 'password' && $formValue[$key] == '')
                    continue;
                if (isset($formValue[$key]))
                    if ($formValue[$key] != '') {

                        if ($f['DATA_TYPE'] == 'date') {
                            $data[$key] = Zsam_Util::dateSql($formValue[$key]);
                        } elseif ($f['DATA_TYPE'] == 'double')
                            $data[$key] = Zend_Locale_Format::getNumber($formValue[$key]);
                        // cis-erp alterado
                        elseif ($f['DATA_TYPE'] == 'double(13,2)' || $f['DATA_TYPE'] == 'double(4,2)' || $f['DATA_TYPE'] == 'double(8,2)' || $f['DATA_TYPE'] == 'double(8,3)' || $f['DATA_TYPE'] == 'double(6,2)' || $f['DATA_TYPE'] == 'double(6,3)' || $f['DATA_TYPE'] == 'double(16,8)') {// cis-erp alterado
                            //$verifica  = strripos($formValue[$key],'.');
                            //$double1 = array('.',',');
                            $double = substr_count($formValue[$key], '.');
                            $double1 = substr_count($formValue[$key], ',');
                            if ($double == 0) {
                                $data[$key] = Zend_Locale_Format::getNumber($formValue[$key]);
                            } elseif ($double > 0 && $double1 > 0) {
                                $data[$key] = Zend_Locale_Format::getNumber($formValue[$key]);
                            }

                            else
                                $data[$key] = $formValue[$key];
                            //echo $data['VALOR_ORM1'];
                            //die();
                        }// cis-erp alterado
                        else
                            $data[$key] = $formValue[$key];
                    } else {
                        $data[$key] = null;
                    }
            }
            
            if (!$form->isValid($data)) {
                //isset($form->getErrors()[$elemento]);
                $erros = $form->getErrors();
                if ( count($erros[$elemento])>0 ) {
                    echo json_encode(array("result" => 0, "message" => "Valor Inválido"));
                    die();
                }
            }
            try {

                $table->getAdapter()->beginTransaction();
                $table->updateMultiplesKeys($data, explode(':', $request->getParam('id')));
                $table->getAdapter()->commit();

                echo json_encode(array("result" => 1));
            } catch (Exception $e) {
                $table->getAdapter()->rollback();
                echo json_encode(array("result" => 0, "message" => Zsam_Util::showException($e, true, true)));
            }
        }
    }

    

    public function indexAction() {
        if (@$this->getRequest()->getParam('json') == 'yes') {
            if (!empty($this->zsam_ordena_grid))
                echo $this->json(@$this->getRequest()->getParam('page'), @$this->zsam_ordena_grid, @$this->getRequest()->getParam('campo', null), @$this->getRequest()->getParam('valor', null), @$this->getRequest()->getParam('filtro', null));
            else
                echo $this->json(@$this->getRequest()->getParam('page'), @$this->getRequest()->getParam('order'), @$this->getRequest()->getParam('campo', null), @$this->getRequest()->getParam('valor', null), @$this->getRequest()->getParam('filtro', null));
            exit;
        }
        if (@$this->getRequest()->getParam('acao') != '') {
            if (@$this->getRequest()->getParam('acao') == 'upd' || @$this->getRequest()->getParam('acao') == 'upd-modal') {
                $this->view->atualizar = 1;
            } else if (@$this->getRequest()->getParam('acao') == 'new') {
                // nada a fazer
            } else {
                $this->view->deletar = 1;
            }
            $this->view->idEntr = $this->getRequest()->getParam('id');
        }
        
        
        // incluido para verificar as permissoes do usuario
        $auth   = Zend_Auth::getInstance();
        if ($auth->hasIdentity()){
                $user = $auth->getStorage()->read();
        }

        if ($user['PERMITIDO_EXCEL'] == 'N') {
            $this->zsam_buttons['excel'] = 'N';
        }

        if ($user['PERMITIDO_PDF'] == 'N') {
            $this->zsam_buttons['pdf'] = 'N';
        }

        $this->view->zsam_form_ajax = $this->zsam_form_ajax;
        $table_class = $this->zsam_table;
        $table = new $table_class();
        $this->view->fields = isset($this->zsam_tbgrid_field)?$this->zsam_tbgrid_field:$table->getColsGrid();
        $this->view->fields_width = isset($this->zsam_tbgrid_fields_width)?$this->zsam_tbgrid_fields_width:array();
        $this->view->refs = $table->info('referenceMap');
        $this->view->model = $this->zsam_table;
        $this->view->tabela = $table->info('name');
        $this->view->filtro = $this->zsam_filtro;
        $this->view->agrupamento = $this->zsam_agrupamento;
        $this->view->ordenamento = $this->zsam_ordenamento;
        $this->view->reportpdf = $this->zsam_report_pdf;
        $this->view->reportexcel = $this->zsam_report_excel;
        $this->view->buttons = $this->zsam_buttons;

        $this->view->zsam_controller_relatorio = $this->zsam_controller_relatorio;
        $this->view->zsam_report_font = $this->zsam_report_font;

        /* var_dump($this->zsam_agrupamento);
          die("index_simple"); */

        Cisweb_Simple_SimpleCisweb::indexAction();
    }

}

?>