<?php

class Zsam_Controller_Base extends Zend_Controller_Action {

    protected $campos = array();
    protected $filtro;
    protected $charEncoding = 'UTF-8';
    protected $model;
    protected $titulo = array();
    protected $corpo = array();

    public function pdf($sql) {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();

        $pdf = new Zend_Pdf();


        $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
        $pdf->pages[] = $page;
        if (empty($titulo))
            $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
        else
            $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::$titulo['font']), $titulo['size']);

        /* Configuração das variáveis para controle de largura(x) e altura(y) da página */
        $x = 70;
        $y = 780;
        $tamanhoCampos = 510 / sizeof($this->campos['linha1']);
        #Contador de páginas

        for ($r = 0; $r < sizeof($sql); $r++) {
            foreach ($this->campos as $k => $v) {

                if ($y <= 0) {
                    $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
                    $pdf->pages[] = $page;
                    $x = 70;
                    $y = 750;
                }
                $tamanhoCampos = 510 / sizeof($v);
                
                $tCampoFixo = $tamanhoCampos;
                
                $aCampo = $tCampoFixo;

                for ($j = 0; $j < sizeof($v); $j++) {
                    /* Aqui eu monto a primeira linha, primeiro o nome de cada campo */
                    if (empty($titulo))
                        $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
                    else
                        $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::$titulo['font']), $titulo['size']);
                    if (is_numeric(key($v))){                                                
                        $linha = $this->_helper->getHelper('TratarTexto')->tratar($page, current($v) . ' :', 20, $aCampo * $j + 70, $y, 10);                        
                        $aCampo = $tCampoFixo;
                        next($v);                        
                    }else{                        
                        $linha = $this->_helper->getHelper('TratarTexto')->tratar($page, key($v) . ' :', 20, ($tamanhoCampos * $j) + 70, $y, 10);
                        $aCampo = $tamanhoCampos - current($v);
                        next($v);
                    }
                }
                
                reset($v);

                #  Aqui eu retiro 20 da variável y para que ele desça uma linha aproximadamente, lembrando que o zend pdf faz o cálculo do espaço página em pontos, não em pixels.
                $y -= 20;

                /* Verifco se existe a necessidade de criar uma nova página */
                if ($y <= 0) {
                    $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
                    $pdf->pages[] = $page;
                    $x = 70;
                    $y = 780;
                    $tamanhoCampos = 510 / sizeof($v);
                }

                /* Aqui eu imprimo o resultado da pesquisa referente a primeira linha */


                # a variável maiorLinha serve para cálcular qual foi a entrada que ocupou mais linhas.
                $maiorLinha = 0;
                for ($j = 0; $j <= sizeof($k); $j++) {
                    if (empty($titulo))
                        $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA), 10);
                    else
                        $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::$corpo['font']), $corpo['size']);
                    
                    if (is_numeric(key($v))){                                                
                        $linha = $this->_helper->getHelper('TratarTexto')->tratar($page, $sql[$r][current($v)], 20, ($aCampo * $j) + 70, $y, 10);
                        $aCampo = $tCampoFixo;
                        next($v);                        
                    }else{                        
                        $linha = $this->_helper->getHelper('TratarTexto')->tratar($page, $sql[$r][key($v)], 20, ($aCampo * $j) + 70, $y, 10);
                        $aCampo = $tamanhoCampos - current($v);
                        next($v);
                    }
                    $maiorLinha = ($linha['x'] > $maiorLinha) ? $linha['x'] : $maiorLinha;
                }

                #  Desço mais uma linha

                $y -= 20;

                $fim = array_diff($v, end($this->campos));
                if (empty($fim)) {
                    $page->drawLine(70, $y - (10 * $maiorLinha), 580, $y - (10 * $maiorLinha));
                    $y -= 65;
                }
            }
        }
        //$page->drawText($texto, 0, 842-10);842x595

        foreach ($pdf->pages as $k) {
            if (empty($titulo))
                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
            else
                $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::$titulo['font']), $titulo['size']);
            $this->_helper->getHelper('Header')->montaHeader($page, key($k) + 1, count($pdf->pages));
        }

        try {
            $pdfData = $pdf->render();
        } catch (Exception $e) {
            echo $e->message();
        }
        header("Content-Disposition: attachment; filename=relatorio.pdf");
        header("Content-type: application/x-pdf");
        echo $pdfData;
        exit;
    }

    public function setCampos($cam) {
        return $this->campos = $cam;
    }
    
    public function setTitulo($tit){
        $this->titulo = $tit;
    }
    
    public function setCorpo($corpo){
        $this->corpo = $corpo;
    }

    public function filtrarResultado($sql, $campo) {
        $resultados = array();
        foreach ($sql as $k => $v) {
            if (in_array($v, $campo)) {
                $resultados["$v"] = $v;
                next($campo);
            }
        }

        return $resultados;
    }

}
?>