<?php
// CRIADO CIS-ERP APOIO PARA INSERIR MULTIPLOS REGISTROS.
class Cisweb_Apoio_Duplicata extends Zend_Db_Table_Abstract
{
    protected $_name = 'dupli';
    
    public function Inserir($id)
    {
        $where  ="NUMERO = '$id'";
    
        $table  = new core_Model_DbTable_Duplicata();
        $info   = $table->getDescribe();// usado na cripto
        $campos = $table->getAdapter()->fetchAll($table->select()->where($where));
        $parcelas = $campos[0]['NUMERO_DA_PARCELA']; 
        
        $data['NUMERO_DA_PARCELA'] 	= 1;
	    $data['REGISTROGQ'] 		= 1000000;
        $data['DESCRICAO'] 			= $campos[0]['DESCRICAO'] . ' (1/' . $parcelas . ')';
		$data['NOVO_VALOR'] 		= $campos[0]['NOVO_VALOR'];
		$data['IMPRESSAO'] 			= NULL;
        
        $table = parent::update($data, $where);
        
        $ano = substr($campos[0]['VENCIMENTO'], 0, 4);
        $mes = substr($campos[0]['VENCIMENTO'], 5, 2);
        $dia = substr($campos[0]['VENCIMENTO'], 8, 2);
        
        for ($i = 1; $i < $parcelas; $i++) {
            $descricao 		= $campos[0]['DESCRICAO'] . ' ('. ($i+1) . '/' . $parcelas . ')';
			
            $mes_proximo 	= date('Y-m-d', mktime(0, 0, 0, $mes+$i, $dia, $ano));
			$mes_proximo30 	= date('Y-m-d', mktime(0, 0, 0, $mes,$dia+($i*30),$ano));

			$data['REGISTROGQ'] 		= 1000000;
            $data['EMPRESA1']           = $campos[0]['EMPRESA1'];
            $data['NUMERO_DA_PARCELA']  = $i+1;
            $data['DESCRICAO']          = $descricao;
            $data['PLANO_CONTA']        = $campos[0]['PLANO_CONTA'];
            $data['DATA_EMISSAO']       = $campos[0]['DATA_EMISSAO'];
            $data['DEPARTAMENTO']     	= $campos[0]['DEPARTAMENTO'];
            $data['CODIGO_CLIENTE']     = $campos[0]['CODIGO_CLIENTE'];

			if(is_null($campos[0]['IMPRESSAO'])){
				$data['VENCIMENTO'] 		= $mes_proximo;
				$data['NOVO_VENCIMENTO'] 	= $mes_proximo;
			}elseif ($campos[0]['IMPRESSAO'] == 0){
				$data['VENCIMENTO'] 		= $campos[0]['VENCIMENTO'];
				$data['NOVO_VENCIMENTO'] 	= $campos[0]['VENCIMENTO'];
			}elseif($campos[0]['IMPRESSAO'] == 1){
				$data['VENCIMENTO'] 		= $mes_proximo;
				$data['NOVO_VENCIMENTO'] 	= $mes_proximo;
			}else{
				$data['VENCIMENTO'] 		= $mes_proximo30;
				$data['NOVO_VENCIMENTO'] 	= $mes_proximo30;
			}

			if (isset($campos[0]['JUROS'])){
				$juros 	   			= $campos[0]['VALOR'] * pow((1+$campos[0]['JUROS']/100),$i); //juros sobre juros
				$data['VALOR'] 		= $juros;
				$data['NOVO_VALOR']	= $juros;
			}else{
				$data['VALOR'] 		= $campos[0]['VALOR'];
				$data['NOVO_VALOR'] = $campos[0]['NOVO_VALOR'];
			}

            $data['FORMA_ENVIO']        = $campos[0]['FORMA_ENVIO'];
            $data['BANCO']              = $campos[0]['BANCO'];
            $data['COB_OPERACAO']       = $campos[0]['COB_OPERACAO'];
            $data['FUNC_ALTERACAO']     = $campos[0]['FUNC_ALTERACAO'];
            $data['DATA_ALTERACAO']     = $campos[0]['DATA_ALTERACAO'];
            $data['REVISAO']            = $campos[0]['REVISAO'];
            $data['DATASINC']           = $campos[0]['DATASINC'];

            $table = parent::insert($data);
        }
    }
    
    public function InsCartao(array $data){
        
    	$date 				= date('Y-m-d');
		$recibo_cartao 		= null;
		if (isset($data['RECIBO_CARTAO'])){
			if (!is_null($data['RECIBO_CARTAO'])){
				$recibo_cartao = ' - Recibo Cartao: '. $data['RECIBO_CARTAO'];
			}
		}
		$data['DESCRICAO'] 	= 'CARTAO - '.$data['DESCRICAO'] . ' - Dupli: '. $data['NUMERO'] . $recibo_cartao;
		unset ($data['COB_OPERACAO']);
		unset ($data['REFERENCIA_BANCO']);
		unset ($data['IMPRESSAO']);
		unset ($data['REVISAO']);
		
		if (isset($data['NOVO_VALOR']) || $data['NOVO_VALOR'] != 0){
			$valor = $data['NOVO_VALOR'];
		}else{
			$valor = $data['VALOR'];
		}
		
		//neste caso sero juros simples, ou seja, o valor principal  reduzido do juro e dividido pelo total
		$soma 				= ($valor*(1-@$data['JUROS']/100))/$data['QTD_PARCELA'];
		$base_valor			= $data['VALOR']/$data['QTD_PARCELA'];
		$numero				= $data['NUMERO'];
		
		if (isset($data['DATA_VENC_PARCELA1_CARTAO']) && !is_null('DATA_VENC_PARCELA1_CARTAO')){
			$data_par_1		= $data['DATA_VENC_PARCELA1_CARTAO'];
		}else{
			$data_par_1		= $data['VENCIMENTO'];
		}
		for($i=1;$i<=$data['QTD_PARCELA'];$i++){

			$data['VALOR']  					= $base_valor;
			$data['NOVO_VALOR'] 				= $soma;
			$data['FORMA_ENVIO'] 				= 'C';
            $data['NUMERO_DA_PARCELA']  		= $i;
			$data['DUPLI_ORIGEM']				= $numero;
			$data['DEBITO_CARTAO']				= 'S';
			//$data['PAGSEGURO_NUMERO_PAGAMENTO']	= $data['PAGSEGURO_NUMERO_PAGAMENTO'];
			//$data['PAGSEGURO_NUMERO_RETORNO']	= $data['PAGSEGURO_NUMERO_RETORNO'];
			
			$ano=substr($data_par_1,0,4);
			$mes=substr($data_par_1,5,2);
			$dia=substr($data_par_1,8,2);

			$venc = date('Y-m-d',mktime(0, 0, 0, $mes,$dia+(($i-1)*30),$ano));

			$data['VENCIMENTO'] 		= $venc;
			$data['NOVO_VENCIMENTO'] 	= $venc;
            
            unset($data['NUMERO']);

			parent::insert($data);
		}
    }
}
