<?php

class serv_Model_DbTable_Zindicadoresvendas extends Zsam_Db_Table {

	protected $_name = 'zindicadoresvendas';

	var $_conf = array(
			'CLIENTE' 				=> array(),
			'ITEM_PROGR'			=> array(),
			'NUM_ITEM' 				=> array(),
			'USUARIO'				=> array(),
			'INDICADOR'				=> array( 'VP' => array(  '1'  => 'indicador_recebidos',
															  '2'  => 'indicador_aprovados',
															  '3'  => 'indicador_reprovados',
															  '4'  => 'indicador_declinados',
															  '5'  => 'indicador_fora_prazo',
															  '11' => 'indicador_pendente',
															  '12' => 'indicador_atendido',
											)),
			
			'DEPARTAMENTO'			=> array(),
			'DATA_ORCAMENTO'		=> array(),
			'EMPRESA' 				=> array(),
			'PRODUTO' 				=> array(),
	        'QUANTIDADE' 			=> array(),
	        'TIPO' 					=> array(),
	        'APROVACAO' 			=> array(),
	        'NUMERADOR' 			=> array(),
			"DATA_PREPARACAO" 		=> array(),
	);
	
	var $_referenceMap = array(
			
			'PRODUTO' => array(
					'columns' 	=> 'PRODUTO',
					'refTitle' 	=> 'DESCRICAO'
			),

			'EMPRESA' => array(
					'columns' 		=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'NOME'
			),

			'DEPARTAMENTO' => array(
					'columns' 		=> 'DEPARTAMENTO',
					'refTableClass' => 'core_Model_DbTable_Depto',
					'refColumns' 	=> 'DEPARTAMENTO',
					'refTitle' 		=> 'DEPARTAMENTO'
			),
	);
	
	public function __construct()
	{
		parent::__construct();
	
		$cliente = Zend_Registry::get('Cliente');
		
		if(@$cliente[0]['IND_COM_SERV'] == "I")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'ind_Model_DbTable_Produto','table2' => 'ind_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}
	
		else if(@$cliente[0]['IND_COM_SERV'] == "C")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'com_Model_DbTable_Produto','table2' => 'com_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}
	
		else
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = 'core_Model_DbTable_Ativoprodutos';
			$this->_referenceMap['PRODUTO']['refColumns'] = 'CODIGO';
		}
	}
}
?>