<?php
class serv_Model_DbTable_Fornecedordb2 extends Zsam_Db_Table {
	/**
	 * The default table name 
	 */

	protected $_name 	= 'forneapoio';
	var $_autocomplet 	= array('CODIGO','NOME','FANTASIA');
	
	var $_conf = array(
		'CODIGO' 			=> array('grid'=>true,'edit'=>'N','NULLABLE' => false),
    	'NOME' 				=> array('grid'=>true,'NULLABLE' => false,'title'=>'razao_social'),
		"FANTASIA"          => array("grid"=>true),
    	'CNPJ' 				=> array("grid"=>true,"help"=>"help_cnpj",'NULLABLE' =>true,'validate'=>array('Zsam_Validate_Cp')),
    	'IE' 				=> array("help"=>"help_cnpj"),
		"INSCRICAO_MUNICIPAL"=> array(),		 	 	 	 	  	 	 	 	 	 	
		"ISS"               => array(),
    	'ENDERECO' 			=> array('grid'=>true),
    	'COMPLEMENTO'		=> array(),
    	'NUMERO_ENDERECO' 	=> array(),
    	'BAIRRO' 			=> array(),
    	'CEP' 				=> array('help'=>'help_cep'),
    	'CEP1' 				=> array('help'=>'help_cep2'),
    	'CIDADE' 			=> array('grid'=>true,'alt' =>'alt_desc_cidade'),    	
    	'TIPO_FRETE'		=> array('VP' => 'FOB,CIF,EXW'),
    	'CONTATO' 			=> array(),
    	'FONE' 				=> array('help' => 'help_fone'),
		"ID_RADIO"          => array(),
    	'VENC' 				=> array("alt"=>"alt_desc_venc"),
    	'FORNECEDOR_MATERIAL'=> array('VP' =>array('P'=>'p_produtivo','I'=>'i_improdutivo','A'=>'a_ambos')),
		"EMAIL"          	=> array('case'=>'NONE'),
		"RAMOATIVIDADE"     => array("grid"=>true ),
    	'PONTUACAO_QUALIDADE'=> array('grid' => true,'level'=> 3,'VP' => '0,10,20,30,40,50,60,70,80,90,100'),
    	'ISO'	 			=> array('level'=> 3,'VP'=>array('S'=>'certificada_iso_9000','N'=>'nao_certificada_iso_9000')),
    	'GRUPO' 			=> array('level'=> 3,'VP'=>array('S'=>'pertence_ao_mesmo_grupo','N'=>'nao_pertence_ao_mesmo_grupo')),
    	'DATACONCESSAO'	 	=> array('grid' => true,'level'=> 3,'help'=>'help_data_limite_para_fornecimento_forne_nao_qualificados'),
    	'DATA_ALTERACAO' 	=> array('edit'=>'N'),
    	'FUNC_ALTERACAO' 	=> array('edit'=>'N'),
    	'REVISAO' 			=> array('edit'=>'N'),
        'DATASINC'          => array('edit'=>'N'),
	);    
 	
		public function __construct($config = array()) {
			parent::__construct($config);
			
			$registry = Zend_Registry::getInstance();
			$this->_setAdapter($registry->get('db1'));
			$this->_restrict = $this->seleciona_chave();
		}
		
		private function seleciona_chave(){
			$table_class 	= 'serv_Model_DbTable_Fornecedor';
			$tabela 		= new $table_class();
			$chave 			= $tabela->info('primary');
			
			$select 		= $tabela->select();
			$apoio 			= $tabela->fetchAll($select);
			
			$where 	= '1 = 1';
			$cont 	= 0;	
			foreach($apoio->toArray() as $dado => $conteudo){
				$cont ++;
				if ($cont == 1) $where = $chave[1]." <> '". $conteudo[$chave[1]] ."'";
				else $where .= " AND ". $chave[1]." <> '".$conteudo[$chave[1]]."'";
			}
			
			return $where;
		}
}
	?>