<?php

class especial_Model_DbTable_Programacompraveicitem extends Zsam_Db_Table {

	/**
	 * The default table name
	 */

	protected $_name = 'progrcompraveicitens';

	var $_autocomplet = array('ITEM_PROGR','NUM_ITEM','VEICULO');

	var $_conf = array(
			'CLIENTE' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'ITEM_PROGR'			=> array('edit' => 'N'),
			'NUM_ITEM' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
            'ID'					=> array('edit' => 'N'),
			'EMPRESA' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'VEICULO' 				=> array('autocomplete'=>'Y','NULLABLE' => false),
			'DESCRICAO_ITEM_NOVO'	=> array('edit' => 'N'),//nao esta sendo usado seria para cadastrar item novo
	        'CFOP' 					=> array(),
	        'QUANTIDADE' 			=> array('NULLABLE' => false),
			'DATANECESSIDADE' 		=> array('edit' => 'N'),
			'PRECO_UNITARIO' 		=> array('edit' => 'S','NULLABLE' => false),
			'PRECO_CUSTO' 			=> array('edit' => 'N','level'=>5),
			'PRECO_BASE' 			=> array('edit' => 'N'),
	        'PRECO_TOTAL_ITEM'		=> array('edit' => 'N'),
			'BAIXA' 				=> array('edit' => 'N'),
	        'UNI'					=> array('edit' => 'N'),
			'INFORMACAO_ADICIONAL'	=> array('help'=>'help_quebrar_linha_com_;'),
	        'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
			'DATA_ALTERACAO' 		=> array('edit' => 'N'),
			'REVISAO' 				=> array('edit' => 'N'),
			'DATASINC' 				=> array('edit' => 'N')
	);
	var $_referenceMap = array(
			'VEICULO' => array(
					'columns' 		=> 'VEICULO',
					'refTableClass' => 'especial_Model_DbTable_Veiculo',
					'refColumns' 	=> 'ID',
					'refTitle' 		=> 'VEICULO'
			),

			'EMPRESA' => array(
					'columns' 		=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'NOME'
			),

	        'CFOP' => array(
	                'columns' 		=> 'CFOP',
	                'refTableClass' => 'core_Model_DbTable_Cfop',
	                'refColumns' 	=> 'CODIGO',
	                'refTitle' 		=> 'CFOP'
	        ),
	);
	public function __construct()
	{
		parent::__construct();

		//$this->_restrict = "CODIGO_CLIENTE = ".$id;

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora




	}

	public function atualizar($id1,$id2,$id3)
	{
		$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
		$sql->execute();

	}

	

	public function beforeDelete($where)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if ($nome_controller == 'programaitem')
		{

			$table_progr 		= new serv_Model_DbTable_Programa();
			$table_progritem 	= new Cisweb_Db_Abstract('progritens');

			$cliente 			= $where[' CLIENTE = ? '];
			$item_progr 		= $where[' ITEM_PROGR = ? '];
			$item 	 			= $where[' NUM_ITEM = ? '];

			$dados_progr 		= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));

			$dados_item 		= $this->getAdapter()->fetchAll($this->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr' AND NUM_ITEM <> '$item'"));

			if (count($dados_progr) != 0);// calcula o rateio ...
			{

				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;

				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];

				$total 					= $this->calcula_total($dados_item);

				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;

					if ($frete != '')
					{

						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);

						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}

					if ($seguro != '')
					{

						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);

						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}

					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;

					$data['BASE_DE_CALCULO_ICMS'] 		=  $value['PRECO_TOTAL_ITEM']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_IPI'] 		=  $value['PRECO_TOTAL_ITEM']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_PIS'] 		=  $value['PRECO_TOTAL_ITEM']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_COFINS'] 	=  $value['PRECO_TOTAL_ITEM']	+ ($valor_frete + $valor_seguro);

					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem'";
					$table_progritem->update($data,$whereitens);

				}

			}

		}

		return parent::beforeDelete($where);
	}


	public function getEmpresa($emp)
	{

		$table = new core_Model_DbTable_Empresa();
		$dados = $table->find($emp)->toArray();

		return $dados[0];
	}
}
?>