<?php

class especial_Model_DbTable_Nfspapel extends Zsam_Db_Table {

	protected $_name = 'nfspapel';

	var $_restrict = null;

	public function __construct()
	{
		parent::__construct();

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

		if($nome_controller == 'nfspapelcancelar')
		{
			$tipo= "CANCELAMENTO = '' OR CANCELAMENTO IS NULL";
			$this->_restrict = $tipo;

			$this->_conf['CANCELAMENTO']['NULLABLE']= false;
			$this->_conf['CANCELAMENTO']['grid']	= true;
			$this->_conf['EMPRESA']['edit'] 		= 'N';
			$this->_conf['DATA']['edit'] 			= 'N';
			$this->_conf['CLIENTE']['edit'] 		= 'N';
			$this->_conf['TOTAL']['edit'] 			= 'N';

		}

		if($nome_controller == 'nfspapelgerenciar')
		{

			$this->_conf['CANCELAMENTO']['grid']	= true;
			$this->_conf['CANCELAMENTO']['edit'] 	= 'N';
			$this->_conf['EMPRESA']['edit'] 		= 'N';
			$this->_conf['DATA']['edit'] 			= 'N';
			$this->_conf['CLIENTE']['edit'] 		= 'N';
			$this->_conf['TOTAL']['edit'] 			= 'N';
			$this->_conf['PLANO_CONTA']['edit'] 	= 'N';
			$this->_conf['VENCIMENTO']['edit'] 		= 'N';
			$this->_conf['FORMA_ENVIO']['edit'] 	= 'N';
		}

		if($nome_controller == 'nfspapel')
		{
			//$this->_restrict = "IMPRESSAO IS NULL";

			$action = $controller->getActionName();

			if ($action == 'upd')
			{
				$cod 	= $controller->getParam('id');
				$cod    = explode(':', $cod);

				$id 	= $cod[0];
				$emp 	= $cod[1];

				$campos = $this->getAdapter()->fetchAll($this->select()->where("NUMERO = '$id' AND EMPRESA = '$emp' "));

				if ($campos[0]['IMPRESSAO'] == 'D' || $campos[0]['IMPRESSAO'] == 'S')
				{

					$this->_conf['CFOP']['edit']   						= 'N';
					$this->_conf['EMPRESA']['edit'] 					= 'N';
					$this->_conf['CLIENTE']['edit']  					= 'N';
					$this->_conf['DATA']['edit']   						= 'N';
					$this->_conf['VENCIMENTO']['edit'] 					= 'N';
					$this->_conf['ALIQ_ISS_NAO_RETIDO']['edit']  		= 'N';
					$this->_conf['ALIQ_IRRF']['edit']  					= 'N';
					$this->_conf['ALIQ_COFINS_PIS_CSLL_RETIDO']['edit'] = 'N';
					$this->_conf['ALIQ_INSS_RETIDO']['edit']  			= 'N';
					$this->_conf['BASE_ISS']['edit']  					= 'N';
					$this->_conf['ALIQ_ISS_RETIDO_FONTE']['edit']  		= 'N';
					$this->_conf['GRID']['buttons']  					= 'N';

				}
			}
		}

		if($nome_controller == 'faturamensalinterimprimir'){

		    $this->_conf['CFOP']['edit']   						= 'N';
		    $this->_conf['EMPRESA']['edit'] 					= 'N';
		    $this->_conf['CLIENTE']['edit']  					= 'N';
		    $this->_conf['DATA']['editlevel']					= 4;
		    $this->_conf['TOTAL']['editlevel'] 					= 4;
		    $this->_conf['VENCIMENTO']['editlevel'] 			= 4;
		    $this->_conf['ALIQ_ISS_NAO_RETIDO']['edit']  		= 'N';
		    $this->_conf['ALIQ_IRRF']['edit']  					= 'N';
		    $this->_conf['ALIQ_COFINS_PIS_CSLL_RETIDO']['edit'] = 'N';
		    $this->_conf['ALIQ_INSS_RETIDO']['edit']  			= 'N';
		    $this->_conf['BASE_ISS']['edit']  					= 'N';
		    $this->_conf['ALIQ_ISS_RETIDO_FONTE']['edit']  		= 'N';
		    $this->_conf['GRID']['buttons']  					= 'N';
		}
	}

 	var $_conf = array(


        	'NUMERO' 						=> array("grid"=>true,'NULLABLE' => false,'edit'=>'N'),
        	'EMPRESA' 						=> array("grid"=>true, 'NULLABLE' => false),
            'DATA' 							=> array("grid"=>true,'edit'=>'N','NULLABLE' => false),
 			'CFOP' 							=> array('RESTRICT_MAP'=>"TIPONF = 'V'"),// para fazer restrict no refmap.....
 			'DESCR_CFOP'					=> array('edit'=>'N'),
 			'CLIENTE' 						=> array('autocomplete'=>'Y',"grid"=>true, 'NULLABLE' => false,'help'=>'help_digite_para_pesquisar'),
            'NOME_CLI'						=> array('edit'=>'N'),
            'CNPJ_CLI'						=> array('edit'=>'N'),
            'IE_CLI'						=> array('edit'=>'N'),
            'TOTAL' 						=> array('editlevel'=>4),
 	        'PLANO_CONTA' 					=> array('edit'=>'N'),
 	        'DUPLI' 						=> array('edit'=>'N'),
 	        'ALIQUOTA_ICMS' 				=> array('edit'=>'N'),
 	        'BASE_CALCULO_ICMS' 			=> array('edit'=>'N'),
 	        'VALOR_ICMS' 					=> array('edit'=>'N'),
 			'IMPRESSAO'						=> array('edit'=>'N'),
			'FORMA_ENVIO'					=> array('VP' => array('C' => 'COB_CARTEIRA', 'S' => 'BOLETO_SEMREGISTRO','R' => 'BOLETO_COMREGISTRO')),
 	        'BANCO' 						=> array('edit'=>'N'),
 	        'PERIODO_NFSPAPEL' 				=> array('edit'=>'N'),
 	        'CONTRATO'		 				=> array('edit'=>'N'),
 	        'NFSPAPEL_MODELO' 				=> array('edit'=>'N'),
          	'VENCIMENTO' 					=> array('NULLABLE' => false),
            'CANCELAMENTO' 					=> array('editlevel'=>3,'char_spec'=>'NONE','case'=>'NONE','title'=>'motivo_cancelamento','help'=>'deletar_dupli'),
 	        'FUNC_ALTERACAO' 				=> array('edit' => 'N'),
 	        'DATA_ALTERACAO'				=> array('edit' => 'N'),
 	        'REVISAO'						=> array('edit' => 'N'),
 	        'DATASINC'						=> array('edit' => 'N'),
            'GRID' 							=> array('type' => 'itemGrid', 'model' => 'especial_Model_DbTable_Nfspapelitem', 'controller' => 'especial_nfspapelitemController','columns' => array('NF','EMPRESA','ITEM','DESCRICAO','PRECO','TOTALITEM'),'idWhere' => array('NF','EMPRESA'))
 			);

        protected $_referenceMap = array(
        'EMPRESA' => array(
            'columns' 		=> 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'EMPRESA'
        ),
        'CLIENTE' => array(
            'columns' 		=> 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'CLIENTE'
        ),

        'CFOP' => array(
        	'columns' 		=> 'CFOP',
        	'refTableClass' => 'core_Model_DbTable_Cfop',
        	'refColumns' 	=> 'CODIGO',
        	'refTitle' 		=> 'CFOP'
        ),

	    'PLANO_CONTA' => array(
            'columns'           => 'PLANO_CONTA',
            'refTableClass'     => 'core_Model_DbTable_Planoc',
            'refColumns'        => 'PLANO_CONTA',
            'refTitle'          => 'PLANO_CONTA_CREDITO'
	    ),

       'BANCO' => array(
        	'columns' 		=> 'BANCO',
        	'refTableClass' => 'core_Model_DbTable_Banco',
        	'refColumns' 	=> 'CODIGO',
        	'refTitle' 		=> 'BANCO'
        ),

        'NFSPAPEL_MODELO' => array(
        	'columns' 		=> 'NFSPAPEL_MODELO',
        	'refTableClass' => 'serv_Model_DbTable_Nfspapelmodelo',
        	'refColumns' 	=> 'ID_NFPAPEL',
        	'refTitle' 		=> 'ID_NFPAPEL'
        ),

        'GRID' => array(
            'columns' 		=> 'NF',
            'refTableClass' => 'especial_Model_DbTable_Nfspapelitem',
            'refColumns' 	=> 'NF',
            'refTitle' 		=> 'ITEM'
        )

    );

    public function beforeInsert(array $data)
	{

		$table	= new core_Model_DbTable_Empresa();

		$where  = "CODIGO = ".$data['EMPRESA'];
		$campos = $table->getAdapter()->fetchAll($table->select()->where($where));

		$soma 		= @$campos[0]['ULTIMA_NF_SERVICO']+1;
		$data_emp 	= array('ULTIMA_NF_SERVICO'=>$soma);
		$table->update($data_emp,$where); // atualiza a tabela empresa antes de inserir a fatura

		$data['NUMERO']=$soma; // recebe o num da fatura da tabela empresa

		//die();
		$date= date('Y-m-d');
		$data['DATA']= $date;
		return parent::beforeInsert($data);
    }

	public function beforeUpdate(array $data,$where)
	{
    	$controller = Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

		$id		 = $where[" NUMERO = ? "];
		$emp	 = $where[" EMPRESA = ? "];
		$dataemi = $data["DATA"];
		$cancel	 = $data["CANCELAMENTO"];

		if($nome_controller == 'nfspapelcancelar')
		{
		    if (!is_null($cancel) && $cancel <> ''){
				$table2 		= new core_Model_DbTable_Duplicata();
				$adapter2 		= $table2->getAdapter();
				$where2 		= "NF = '$id' AND EMPRESA1 = '$emp' AND DATA_EMISSAO = '$dataemi'";
				$table2->delete($where2);
			}
		}

		return parent::beforeUpdate($data,$where);
    }

    public function deleteCascade($id,$emp){

    	$controller = Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

    	$table 		= new especial_Model_DbTable_Nfspapelitem();
		$adapter 	= $table->getAdapter();
		$where 		= $adapter->quoteInto('NF = ?', $id).' AND '.$adapter->quoteInto('EMPRESA = ?', $emp);
		$table->delete($where);

    }

}

?>