<?php

class Zend_View_Helper_FormAutocomplet extends Zend_View_Helper_FormElement
{
    /**
     * Generates a 'text' element.
     *
     * @access public
     *
     * @param string|array $name If a string, the element name.  If an
     * array, all other parameters are ignored, and the array elements
     * are used in place of added parameters.
     *
     * @param mixed $value The element value.
     *
     * @param array $attribs Attributes for the element tag.
     *
     * @return string The element XHTML.
     */
    public function formAutocomplet($name, $value = null, $attribs = null)
    {
    	$translate = Zend_Registry::get('Zend_Translate');

        $info = $this->_getInfo($name, $value, $attribs);
        extract($info); // name, value, attribs, options, listsep, disable

        // build the element
        $disabled = '';
        if (@$attribs['readOnly']) {
            // disabled
            $disabled = ' readOnly="readonly"';
        }

        // XHTML or HTML end tag?
        $endTag = ' />';
        if (($this->view instanceof Zend_View_Abstract) && !$this->view->doctype()->isXhtml()) {
            $endTag= '>';
        }

        if ( isset($attribs['table']) && $value != '') {
        	$tab_class = $attribs['table'];
        	$tab = new $tab_class();
        	$attribs['title'] = $tab->printTitleFromId($value);
        }
	    $xhtml = '<input type="hidden" '
	                . ' name="' . $this->view->escape($name) . '"'
	                . ' id="' . $this->view->escape($id) . '"'
	                . ' value="' . $this->view->escape($value) . '"'
	                . $endTag;
            $xhtml .= '<input type="text" class="zsam_componente_form_element_autocomplete" '
	    		. ' json="'.$this->view->baseUrl().'/json/search/" '
	                . ' idhidden="' . $this->view->escape($id) . '"'
	                . ' id="' . $this->view->escape($id) . '"'
	                . ' value="' . $this->view->escape($translate->_(@$attribs['title'])) . '"'
	                . $disabled
	                . $this->_htmlAttribs($attribs)
	                . $endTag ;
/*
	    if ( $attribs['table'] == '') $xhtml.= "Falta declarar parametro table em \$dependentes ";
	    else {
	        $table_class =  $attribs['table'];
		    $table = new $table_class();
			$fields = $table->info('metadata');
			$refs   = $table->info('referenceMap');
			$primary =$table->info('primary');

			$table_class_orig =  $attribs['table_orig'];
			$ref_orig = null;
			foreach($refs as $ref){
				if ($ref['refTableClass']==$table_class_orig){
				   $ref_orig = $ref;
				   break;
			     }
			}
			if ( $ref_orig == null ) $xhtml.= "Falta \$_referenceMap em $table_class para $table_class_orig";
			else {
				$chave = array_diff($primary, array($ref_orig["columns"]));
				if ( count($chave) != 1) $xhtml.= "Chave primaria incorreta para NxN na tabela $table_class (".implode(',',$chave).")";
				else {
					$table_class_consulta = $refs[implode('',$chave)]['refTableClass'];
					if ( $table_class_consulta == '') $xhtml.= "Não encontrao referencia para o campo ".implode('',$chave)." em $table_class";
					else {
						$title_consulta = $refs[implode('',$chave)]['refTitle'];
						$table_consulta = new $table_class_consulta();

						$keys = explode(',',$value);
						$xhtml.="<div id='opts_$table_class'>";
						foreach ( $keys as $reg){
							if ( trim($reg) == '') continue;
							$k = $table_consulta->find($reg)->current();
							$xhtml.="<div class='zsam_componente_form_element_nxn'><input type='checkbox' value='$reg' table='$table_class' onclick='zsam_NxN_click(this)' checked> ".$reg.' : '.$k[$title_consulta]."</div>";
						}
						$xhtml.="<input type=text class='zsam_componente_form_element_autocomplete' table='$table_class_consulta' opts='$table_class' json='/json/search/' func='zsam_selNxN' >";
						$xhtml.="</div>";
					}

				}
			}
	    }
*/

        return $xhtml;
    }
}
