<?php

class Zsam_Validate_Imagem extends Zend_Validate_Abstract
{
	
    const TAMANHO   = 'imageSizeInvalid';
    const FORMATO   = 'stringLengthInvalid';

    /**
     * @var array
     */
    protected $_messageTemplates = array(
        self::TAMANHO   => "Imagem deve ter menos de %max%kb",
        self::FORMATO   => "Formato de imagem não permitido"
    );
    
    protected $_messageVariables = array(
        'max' => '_max',
    );	
    
        /**
     * Minimum length
     *
     * @var integer
     */
    protected $_max;
    
    protected $_opts;

    public function __construct($options = array())
    {
    	$this->_opts = $options;
    }

    public function isValid($value, $context = null)
    {        
        $this->_max = $this->_opts['tamanho']/1000;
        if ($_FILES[$this->_opts['campo']]['size'] > $this->_opts['tamanho'] ) {
            $this->_error(self::TAMANHO,  $this->_max);
            //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
            return false;
        }        
        $nome = substr(strtoupper($_FILES[$this->_opts['campo']]['name']),-3);
        $nome = strtolower($nome);
        
        if (!in_array($nome, $this->_opts['ext']) ) {
            $this->_error(self::FORMATO);
            //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
            return false;
        }
        return true;
    }
}
