<?php

class Zsam_Controller_Form_Simple extends Cisweb_Simple_SimpleCisweb {

    var $dependentes = array();
    var $view_controller = "simple";
    var $zsam_filter;
    var $zsam_form_group = array();
    var $zsam_form_script = null;
    var $zsam_report = null;
    var $zsam_filtro = null;
    var $zsam_ordenamento = null;
    var $zsam_agrupamento = null;
    var $zsam_report_pdf = null;
    var $zsam_report_excel = null;
    var $zsam_buttons = array();
    var $zsam_ordena_grid = null;
    var $zsam_controller_relatorio = null;
    var $zsam_report_font = null;
    var $default_values = null;
    
    public function init(){
    	parent::init();
    }

    private function groupTraduction() {
        $new = array();
        $translate = Zend_Registry::get('Zend_Translate');
        foreach ($this->zsam_form_group as $nome => $array) {
            $new[$translate->_($nome)] = $array;
        }
        $this->zsam_form_group = $new;
    }

    public function indexAction() {
        if (@$this->getRequest()->getParam('json') == 'yes') {
            echo $this->json(@$this->getRequest()->getParam('page'), @$this->zsam_ordena_grid, @$this->getRequest()->getParam('campo'), @$this->getRequest()->getParam('valor'));
            exit;
        }
        if (@$this->getRequest()->getParam('acao') != '') {
            if (@$this->getRequest()->getParam('acao') == 'upd' || @$this->getRequest()->getParam('acao') == 'upd-modal') {
                $this->view->atualizar = 1;
            } else if (@$this->getRequest()->getParam('acao') == 'new') {
                // nada a fazer
            } else {
                $this->view->deletar = 1;
            }
            $this->view->idEntr = $this->getRequest()->getParam('id');
        }
        $this->view->zsam_form_ajax = $this->zsam_form_ajax;
        $table_class = $this->zsam_table;
        $table = new $table_class();
        $this->view->fields = $table->getColsGrid();
        $this->view->refs = $table->info('referenceMap');
        $this->view->model = $this->zsam_table;
        $this->view->tabela = $table->info('name');
        $this->view->filtro = $this->zsam_filtro;
        $this->view->agrupamento = $this->zsam_agrupamento;
        $this->view->ordenamento = $this->zsam_ordenamento;
        $this->view->reportpdf = $this->zsam_report_pdf;
        $this->view->reportexcel = $this->zsam_report_excel;
        $this->view->buttons = $this->zsam_buttons;
        $this->view->zsam_controller_relatorio = $this->zsam_controller_relatorio;
        $this->view->zsam_report_font = $this->zsam_report_font;
		parent::indexAction();

    }

    public function newAction() {
        $this->groupTraduction();
        if ($this->zsam_form_ajax)
            $this->_helper->layout->disableLayout();
//        $sessao = new Zend_Session_Namespace('Update');
        
        $form = new Zsam_Form_Simple($this->zsam_table, $this->dependentes, $this->zsam_form_group, $this->zsam_form_ajax, $this->zsam_form_script, $this->default_values, $this->getRequest()->getParam('id'));
        $form->setAction($this->getActionForm());

        if ($this->getRequest()->isPost()) {

            $formData = $this->getRequest()->getPost();
            $table_class = $this->zsam_table;
            $table = new $table_class();
            $select = $table->select();
            $adapter = $table->getAdapter();
            $rowset = $adapter->fetchAll($select);
            $total = count($rowset);
            $table->beforeValidade($form, $formData);

            if ($form->isValid($formData)) {
                $formValue = $form->getValues();
                $data = array();
                $fields = $table->getDescribe();

                foreach ($fields as $key => $f) {
                    if ($f['IDENTITY'])
                        continue;

//                    if ($f["COLUMN_NAME"]=="ITEM"){
//          
//                        $formValue['ITEM'] = $table->getValorItem($formData);                       
//                       // exit;    
//                    }

                    if (isset($f['type']) && $f['type'] == 'upload') {
                        if (!$form->$key->receive())
                            throw new Zend_Validate_Exception("Arquivo não pode ser enviado");
                        if ($form->$key->isUploaded()) {
                            $arquivo = $_FILES[$key]['tmp_name'];
                            $tamanho = $_FILES[$key]['size'];
                            $fp = fopen($form->$key->getFileName(), "rb");
                            $conteudo = fread($fp, $tamanho);
                            //$conteudo = addslashes($conteudo);
                            fclose($fp);
                            $nome = $form->$key->getFilenAME();

                            $imagem = base64_encode($conteudo);
                            //$img = new Zend_Form_Element_Image;
                            //$img->setImage($conteudo);
                            $data[$key] = $imagem;
                        }
                        continue;
                    }
                    if (isset($f['level']) && $f['level'] > Zsam_User::getLevel())
                        continue;


                    if (isset($formValue[$key]))
                        if ($formValue[$key] != '') {
                            if ($f['DATA_TYPE'] == 'date')
                                $data[$key] = Zsam_Util::dateSql($formValue[$key]);
                            elseif ($f['DATA_TYPE'] == 'double')
                                $data[$key] = Zend_Locale_Format::getNumber($formValue[$key]);
                            else
                                $data[$key] = $formValue[$key];
                        }
                    //Verifica se o reference map é um array, se ele for, ele pula para o proximo item do reference map.
                    foreach ($table->info('referenceMap') as $deps) {
                        $table_ref_class = $deps['refTableClass'];
                        if (!is_array($table_ref_class) && !isset($refs[$f]['records'])) {
                            $table_ref = new $table_ref_class();
                            $select = $table_ref->fetchAll(
                                    $table_ref->select()
                            );
                            $ar = $select->toArray();
                            if (!empty($ar)) {
                                if (!empty($data[$key][$deps['columns']])) {
                                    if (key_exists('ASSINATURA', $ar[0]) && empty($ar[0]['ASSINATURA'])) {
                                        $this->view->error = 'Este registro não pode ser utilizado pois não está assinado. Solicite a assinatura';
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                try {
                    $table->getAdapter()->beginTransaction();

                    $newid = $table->insert($data);
                    foreach ($this->dependentes as $dep) {
                        if ($dep['type'] == 'NxN' || $dep['type'] == 'multicheck') {
                            $table_ref_class = $dep['table'];
                            $table_ref = new $table_ref_class();
                            $refs = $table_ref->info('referenceMap');
                            $refs_cols = $table_ref->info('primary');

                            if (count($refs_cols) != 2)
                                throw new Zend_Validate_Exception("O modelo $table_ref_class tem que ter apenas 2 colunas (NxN).");

                            $ref_orig = null;
                            foreach ($refs as $ref) {
                                if ($ref['refTableClass'] == $table_class) {
                                    $ref_orig = $ref;
                                    break;
                                }
                            }
                            if ($ref_orig == null)
                                throw new Zend_Validate_Exception("Referencia $table_class em $table_ref_class nao localizada.");

                            $chave = $ref_orig['columns'];

                            $diff = array_diff($refs_cols, array($chave));
                            if (count($diff) != 1)
                                throw new Zend_Validate_Exception("Problema com a chave no modelo $table_ref_class (NxN).");

                            if ($dep['type'] == 'multicheck')
                                $vls = $formValue[$table_ref_class];
                            else
                                $vls = explode(',', $formValue[$table_ref_class]);

                            foreach ($vls as $vl) {
                                if (trim($vl) != '') {
                                    $data = array();
                                    $data[$chave] = $newid;
                                    $data[implode('', $diff)] = $vl;
                                    $table_ref->insert($data);
                                }
                            }
                        }
                    }

                    $table->getAdapter()->commit();
	               $this->_helper->redirector("sucess", $this->getRequest()->getControllerName(), $this->getRequest()->getModuleName(), array("id" => $this->getRequest()->getParam('id')));
                } catch (Exception $e) {
                    $table->getAdapter()->rollBack();
                    $this->view->error = Zsam_Util::showException($e, true, true);
                }
            }
        }

        $this->view->zsam_form_ajax = $this->zsam_form_ajax;
        $this->view->form = $form;
    }

    
    public function beforeSucess(){
        $this->_helper->layout->disableLayout();
    }

    public function sucessAction() {
        
        $this->beforeSucess();
        $request = $this->getRequest();
        $this->view->idreg = $request->getParam('id');
        $this->afterSucess();
    }
    
    public function afterSucess(){
        $this->view->zsam_form_ajax = $this->zsam_form_ajax;
        $this->view->url = array('action'=>'index');
    }

    public function delAction() {
        $this->groupTraduction();
        if ($this->zsam_form_ajax)
            $this->_helper->layout->disableLayout();

        if (Zsam_User::getLevel() <= 2) {
            $this->_helper->redirector('deny', 'auth', 'default');
            return;
        }

        $table_class = $this->zsam_table;
        $table = new $table_class();
        $descricao = $table->getDescribe();
        $primaryKey = $table->info('primary');
        $loadEntity = $table->findMultipleKey(explode(':', $this->getRequest()->getParam('id')));
        $form = new Zsam_Form_Simple($this->zsam_table, $this->dependentes, $this->zsam_form_group, $this->zsam_form_ajax, $this->zsam_form_script, $defaultValues = null, $this->getRequest()->getParam('id'));
        $form->setAction($this->getActionForm());
        $row = $table->decrypt($loadEntity);
        $row = array_shift($row);
        $form->populate($table->decrypt($row));


        if ($this->getRequest()->isPost()) {
            try {
                $table->deleteMultipleKey(explode(':', $this->getRequest()->getParam('id')));
                
                if (key_exists('ITEM', $row)) {
                	return 1;

                }
                
                $this->_helper->redirector("sucess", $this->getRequest()->getControllerName(), $this->getRequest()->getModuleName(), array("id" => $this->getRequest()->getParam('id')));
            } catch (Exception $e) {
                $this->view->error = Zsam_Util::showException($e, true, true);
            }
        }

        $this->view->form = $form;
        $this->view->zsam_form_ajax = $this->zsam_form_ajax;
    }

    /*     * **************************************************************************************************************** */

    public function updAction() {
        $this->groupTraduction();
        if ($this->zsam_form_ajax)
            $this->_helper->layout->disableLayout();
        //Sessão para receber os valores    
//        $sessao = new Zend_Session_Namespace('Update');

        $table_class = $this->zsam_table;
        $table = new $table_class();
        $request = $this->getRequest();
        $result = $table->findMultipleKey(explode(':', $request->getParam('id')));
        if (0 == count($result)) {
            $this->_helper->redirector('index');
            return;
        }
        $row = $table->decrypt($result);
        $row = array_shift($row);
        $form = new Zsam_Form_Simple($this->zsam_table, $this->dependentes, $this->zsam_form_group, $this->zsam_form_ajax, $this->zsam_form_script, $defaultValues = null, $this->getRequest()->getParam('id'));
        $form->setAction($this->getActionForm());
        $form->setRequiredPasswords(false);
        $canEdit = $table->canUpd($row);
        $adapter = $table->getAdapter();

//        @$sessao->__set('numero', $row["NUMERO"]);
//        @$sessao->__set('empresa', $row["EMPRESA"]);


        $canAssinar = 0;
        if (key_exists('ASSINATURA', $row) && Zsam_User::getLevel() >= 4) {
            if ($row['ASSINATURA'] == null)
                $canAssinar = 1;
            else
                $canAssinar = 2;
        }


        if ($this->getRequest()->isPost() && $canEdit) {

            $formData = $this->getRequest()->getPost();
            $table->beforeValidade($form, $formData);
            if ($form->isValid($formData)) {
                $formValue = $form->getValues();
                $data = array();
                $fields = $table->getDescribe();
                foreach ($fields as $key => $f) {
                    if ($f['IDENTITY'] or $f['PRIMARY'])
                        continue;

                    if (isset($f['type']) && $f['type'] == 'upload') {
                        if (!$form->$key->receive())
                            throw new Zend_Validate_Exception("Arquivo não pode ser enviado");
                        if ($form->$key->isUploaded()) {
                            $arquivo = $_FILES[$key]['tmp_name'];
                            $tamanho = $_FILES[$key]['size'];
                            $fp = fopen($form->$key->getFileName(), "rb");
                            $conteudo = fread($fp, $tamanho);
                            //$conteudo = addslashes($conteudo);
                            fclose($fp);
                            $nome = $form->$key->getFilenAME();

                            $imagem = base64_encode($conteudo);
                            //$img = new Zend_Form_Element_Image;
                            //$img->setImage($conteudo);
                            $data[$key] = $imagem;
                        }
                        continue;
                    }
                    if (isset($f['level']) && $f['level'] > Zsam_User::getLevel())
                        continue;
                    if (isset($f['type']) && $f['type'] == 'password' && $formValue[$key] == '')
                        continue;
                    if (isset($formValue[$key]))
                        if ($formValue[$key] != '') {
                            if ($f['DATA_TYPE'] == 'date') {
                                $data[$key] = Zsam_Util::dateSql($formValue[$key]);
                            } elseif ($f['DATA_TYPE'] == 'double')
                                $data[$key] = Zend_Locale_Format::getNumber($formValue[$key]);
                            else
                                $data[$key] = $formValue[$key];
                        } else {
                            $data[$key] = null;
                        }
                }
                try {
                    $table->getAdapter()->beginTransaction();
                    $newid = $table->updateMultiplesKeys($data, explode(':', $request->getParam('id')));


                    foreach ($this->dependentes as $dep) {
                        if ($dep['type'] == 'NxN' || $dep['type'] == 'multicheck') {
                            $table_ref_class = $dep['table'];
                            $table_ref = new $table_ref_class();
                            $refs = $table_ref->info('referenceMap');
                            $refs_cols = $table_ref->info('primary');

                            if (count($refs_cols) != 2)
                                throw new Zend_Validate_Exception("O modelo $table_ref_class tem que ter apenas 2 colunas (NxN).");

                            $ref_orig = null;
                            foreach ($refs as $ref) {
                                if ($ref['refTableClass'] == $table_class) {
                                    $ref_orig = $ref;
                                    break;
                                }
                            }
                            if ($ref_orig == null)
                                throw new Zend_Validate_Exception("Referencia $table_class em $table_ref_class nao localizada.");

                            $chave = $ref_orig['columns'];
                            $diff = array_diff($refs_cols, array($chave));
                            if (count($diff) != 1)
                                throw new Zend_Validate_Exception("Problema com a chave no modelo $table_ref_class (NxN).");


                            $table_ref->delete(array("$chave = ?" => $request->getParam('id')));

                            if ($dep['type'] == 'multicheck')
                                $vls = $formValue[$table_ref_class];
                            else
                                $vls = explode(',', $formValue[$table_ref_class]);

                            foreach ($vls as $vl) {
                                if (trim($vl) != '') {
                                    $data = array();
                                    $data[$chave] = $request->getParam('id');
                                    $data[implode('', $diff)] = $vl;
                                    $table_ref->insert($data);
                                }
                            }
                        }
                    }


                    $table->getAdapter()->commit();
                    $this->_helper->redirector("sucess", $this->getRequest()->getControllerName(), $this->getRequest()->getModuleName(), array("id" => $request->getParam('id')));
                } catch (Exception $e) {
                    $table->getAdapter()->rollback();
                    $this->view->error = Zsam_Util::showException($e, true, true);
                }
            }
        } else {

            foreach ($this->dependentes as $dep) {
                if ($dep['type'] == 'NxN' || $dep['type'] == 'multicheck') {
                    $table_ref_class = $dep['table'];
                    $table_ref = new $table_ref_class();
                    $refs = $table_ref->info('referenceMap');
                    $refs_cols = $table_ref->info('primary');


                    if (count($refs_cols) != 2)
                        throw new Zend_Validate_Exception("O modelo $table_ref_class tem que ter apenas 2 colunas (NxN).");

                    $ref_orig = null;
                    foreach ($refs as $ref) {
                        if ($ref['refTableClass'] == $table_class) {
                            $ref_orig = $ref;
                            break;
                        }
                    }
                    if ($ref_orig == null)
                        throw new Zend_Validate_Exception("Referencia $table_class em $table_ref_class nao localizada.");

                    $chave = $ref_orig['columns'];
                    $diff = array_diff($refs_cols, array($chave));
                    if (count($diff) != 1)
                        throw new Zend_Validate_Exception("Problema com a chave no modelo $table_ref_class (NxN).");

                    $res_refs = $table_ref->fetchAll(array("$chave = ?" => $request->getParam('id')));
                    $vls = array();
                    foreach ($res_refs as $m) {
                        $m = $m->toArray();
                        $vls[] = $m[implode('', $diff)];
                    }
                    if ($dep['type'] == 'multicheck')
                        $row[$table_ref_class] = $vls;
                    else
                        $row[$table_ref_class] = implode(',', $vls);
                }
            }
            $form->populate($table->decrypt($row));
        }
        /* ATIVE ESSE BLOCO PARA DESCOBRIR QUAL ELEMENTO ESTA RETORNANDO ERRO 
          foreach ($form->getElements() as $k=>$e )
          {
          echo "$k - ".$e->getLabel();
          $err = $e->getErrors();
          Zend_Debug::dump($err);
          }
         */


        $this->view->id = $request->getParam('id');
        $this->view->form = $form;
        $this->view->zsam_form_ajax = $this->zsam_form_ajax;
        $this->view->canEdit = $canEdit;
        $this->view->canAssinar = $canAssinar;
    }

    private function json($page=1, $order='', $campo=null, $valor=null) {
        if ($page == '' || $page == null)
            $page = 1;
        $table_class = $this->zsam_table;
        $table = new $table_class();
        $cripto = new Zsam_Crypt_Cisweb();
        $select = $table->select();

        $descricao = $table->getDescribe();

        $where = null;
        if (!empty($this->zsam_filter) || $this->zsam_filter != 'undefined')
            $where = $this->zsam_filter;
        if (!empty($campo) && !empty($valor) && $campo != 'undefined' && $valor != 'undefined') {

            if (!empty($descricao[$campo]['cripto'])) {
                $valor = $cripto->encode($valor);
            }

                $where = $table->getAdapter()->quoteInto($campo.' LIKE ?','%'.urldecode($valor).'%');
                $select->where($where);
        }
        
        $data['grid_records'] = 25; //$table->_grid_records;

        $offset = null;
        if ($page > 1)
            $offset = $data['grid_records'] * ( $page - 1 );

        $select->order($order);
        
        $tab = $table->fetchAll($where, $order, $data['grid_records'], $offset);
        $paginator = Zend_Paginator::factory($select);
        $paginator->setCurrentPageNumber($page);
        $paginator->setItemCountPerPage($data['grid_records']);
        //$tab = $paginator->getCurrentItems();

        $data['pages_total'] = $paginator->count();

        $fields = $table->getColsGrid();
        $key = $table->info('primary');
        $refs = $table->info('referenceMap');


        $data['page'] = $page;

        $x = 0;
        $rows = array();
        foreach ($tab as $id => $row) {
            $row = $table->decrypt($row);
            $v = array();
            foreach ($fields as $f) {
                if (isset($refs[$f])) {
                    if (!isset($refs[$f]['records'])) {
                        $rel_class = $refs[$f]['refTableClass'];
                        $rel_obj = new $rel_class();
                        $tab_ref = $rel_obj->fetchAll();
                        foreach ($tab_ref as $l) {
                            $l = $l->toArray();
                            $refs[$f]['records'][$l[$refs[$f]['refColumns']]] = $rel_obj->printTitle($l);
                        }
                    }
                    if (@$refs[$f]['records'][$row[$f]] == null)
                        $v[] = '';
                    else
                        $v[] = @$refs[$f]['records'][$row[$f]];
                }
                else {
                    if ($row[$f] == null)
                        $v[] = '';
                    else
                        $v[] = $row[$f];
                }
            }
            $k_array = array();
            $y = 1;
            foreach ($key as $k) {
                $k_array[] = $row[$key[$y]];
                $y++;
            }
            $rows[] = array(
                "id" => implode(':', $k_array),
                "cell" => $v
            );
            $x++;
        }
        $data['rows'] = $rows;
        return json_encode($data);
    }

    public function assinarAction() {
        $this->_helper->layout->disableLayout();
        $table_class = $this->zsam_table;
        $table = new $table_class();
        $request = $this->getRequest();
        $result = $table->findMultipleKey(explode(':', $request->getParam('id'))); //$table->find($request->getParam('id'));

        if (0 == count($result)) {
            $this->_helper->redirector('index');
            return;
        }
        $row = $table->decrypt($result->current()->toArray());

        $msg = "Assinatura nao realizada. Verifique com o supervisor.";
        if (key_exists('ASSINATURA', $row) && Zsam_User::getLevel() >= 4) {
            if ($row['ASSINATURA'] == null) {
                $data = array("ASSINATURA" => Zsam_User::getId(), 'DATA_ASSINATURA' => date('Y-m-d'));
                $key = $table->info('primary');
                //$table->update($data, array(" $key[1] = ? " => $request->getParam('id')));
                $table->updateMultiplesKeys($data, explode(':', $request->getParam('id')));
                $msg = "Registro " . $request->getParam('id') . " assinado!";
            }
        }

        $this->view->msg = $msg;
    }

    public function retirarassinaturaAction() {
        $this->_helper->layout->disableLayout();
        $table_class = $this->zsam_table;
        $table = new $table_class();
        $request = $this->getRequest();
        $result = $table->findMultipleKey(explode(':', $request->getParam('id'))); //$table->find($request->getParam('id'));

        if (0 == count($result)) {
            die('A');
            $this->_helper->redirector('index');
            return;
        }
        $row = $table->decrypt($result->current()->toArray());
        $msg = "Assinatura nao realizada. Verifique com o supervisor.";
        if (key_exists('ASSINATURA', $row) && Zsam_User::getLevel() >= 4) {
            if ($row['ASSINATURA'] != null) {
                $table->salvaRevisao($row);
                $data = array("ASSINATURA" => null, 'DATA_ASSINATURA' => null);
                if (key_exists('REVISAO', $row))
                    $data['REVISAO'] = new Zend_Db_Expr('REVISAO+1');
                $key = $table->info('primary');
                $table->updateMultiplesKeys($data, explode(':', $request->getParam('id')));
                //$table->update($data, array(" $key[1] = ? " => $request->getParam('id')));
                $msg = " Assinatura retirada do registro " . $request->getParam('id') . "!";
            }
        }
        $this->view->msg = $msg;
    }

    public function gerarNfeAction() {
        $campos = $this->campos;
        $table_class = new $this->zsam_table;

        $table = new $table_class();

        $select = $table->select($campos);

        $dados = $table->fetchAll($select);
        var_dump($dados);
        die();
    }

    public function exportToExcelAction() {

        $translate = Zend_Registry::get('Zend_Translate');
        $request = $this->getRequest();
        $tabela = $request->getParam("tabela");

        $table_class = $this->zsam_table;
        $table = new $table_class();
        $select = $table->select();

        if (is_array(@$this->zsam_report_geral))
            $campos = $this->zsam_report_geral;
        else {
            $config = $table->getDescribe();
            $x = 0;
            foreach ($config as $k => $c) {
                $campos[] = $k;
            }
        }

        $rows = $table->getAdapter()->fetchAll($select);

        // Definimos o nome do arquivo que será exportado
        $arquivo = 'planilha.xls';

        // Criamos uma tabela HTML com o formato da planilha
        $html = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
        $html .= '<table>';
        $html .= '<tr>';
        $html .= '<td colspan="3">' . $translate->_("report_title_" . $table_class) . '</tr>'; //
        $html .= '</tr>';
        $html .= '<tr>';
        foreach ($campos as $c) {
            if (is_array($c)) {
                if (isset($config[$c]['title']))
                    $html .= '<td><b>' . $translate->_($config[$c]['title']) . '</b></td>';
                else
                    $html .= '<td><b>' . $translate->_($c) . '</b></td>';
            }else {
                if (isset($config[$c]['title']))
                    $html .= '<td><b>' . $translate->_($config[$c]['title']) . '</b></td>';
                else
                    $html .= '<td><b>' . $translate->_($c) . '</b></td>';
            }
        }
        $html .= '</tr>';

        foreach ($rows as $row):
            $row = $table->decrypt($row);

            $html .= '<tr>';
            foreach ($campos as $c) {
                $html .= '<td>' . $row[$c] . '</td>';
            }
            $html .= '</tr>';
        endforeach;


        $html .= '</table>';

        // Configurações header para forçar o download
        header("Content-type: application/x-msexcel; charset=utf");
        //header('Content-Type: application/vnd.ms-excel; charset=utf-8');
        header("Content-Disposition: attachment; filename=\"{$arquivo}\"");
        header("Content-Description: PHP Generated Data");

        // Envia o conteúdo do arquivo
        echo $html;

        exit;
    }

    public function exportToPdfAction() {
        $translate = Zend_Registry::get('Zend_Translate');
        $request = $this->getRequest();
        $tabela = $request->getParam("tabela");
        $tipo_relatorio = $request->getParam("relatorio");
        $filtro_inicio = $request->getParam("filtroi");
        $filtro_fim = $request->getParam("filtrof");
        $agrupamento = $request->getParam("agrupamento");
        $ordenamento = $request->getParam("ordenamento");

        $table_class = $this->zsam_table;
        $table = new $table_class();
        $primary = $table->info('primary');
        if (!empty($filtro_inicio) && $filtro_inicio != 'undefined')
            $select = $table->select()->where($this->zsam_filtro . " BETWEEN '" . $filtro_inicio . "%' AND '" . $filtro_fim . "%'");
        else
            $select = $table->select();

        if ($agrupamento != 'nao' && !empty($agupamento) && $agrupamento != 'undefined')
            $select = $select->order($this->view->agrupamento . ' ASC');

        if (!empty($ordenamento) && $ordenamento != 'undefined')
            $select = $select->order($ordenamento);

        if ($tipo_relatorio == 'lista') {
            if (is_array($this->zsam_report)) {
                $campos = $this->zsam_report;
                $config = $table->getDescribe();
                foreach ($campos as $k => $c) {
                    if (isset($config[$c]['level']) && Zsam_User::getLevel() < $config[$c]['level'])
                        unset($campos[$k]);
                    if (isset($config[$c]['title']))
                        $campos[$k] = array('name' => $c, 'title' => $config[$c]['title']);
                }
            }else {
                $config = $table->getDescribe();
                $x = 0;
                foreach ($config as $k => $c) {
                    $campos[] = $k;
                    if ($x++ >= 3)
                        break;
                }
            }
        }else {
            if (is_array($this->zsam_report_geral)) {
                if (!empty($this->zsam_report_geral))
                    $campos = $this->zsam_report_geral;
                else
                    $campos = $table->getDescribe();

                $config = $table->getDescribe();
                foreach ($campos as $k => $c) {
                    if (isset($config[$c]['level']) && Zsam_User::getLevel() < $config[$c]['level'])
                        unset($campos[$k]);
                }
            }else {
                $config = $table->getDescribe();
                $x = 0;
                foreach ($config as $k => $c) {
                    $campos[] = $k;
                    if ($x++ >= 3)
                        break;
                }
            }
        }

        $rows = $table->getAdapter()->fetchAll($select);


        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            // yes ! we get his role
            $user = $auth->getStorage()->read();
            $nome = @$user['NOME'];
        }

        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();

        // Draw text 
        $x = 20;
        $y = 740;
        $pagina = 1;

        //PARA PEGAR A QUANTIDADE DE PAGINAS
        $numero = round(count($rows) / 32 + 0.49999);
        // Create new PDF 
        $pdf = new Zend_Pdf();

        // Add new page to the document 
        $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
        $pdf->pages[] = $page;

        $x = 20;
        $y = 740;
        $pagina = 1;


        //ESCREVE
        $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
        $this->_helper->getHelper('Cabecalho')->cabecalho($page, $pagina, $numero, $translate->_("report_title_" . $table_class), '/' . $request->getModuleName() . '/' . $request->getControllerName());
        $l = $x;
        foreach ($campos as $c => $v) {
            if (is_array($v)) {
                if (isset($config[$v['name']]['title']))
                    $page->drawText($translate->_($config[$v['name']]['title']), $l, $y, 'UTF-8');
            }else {
                $page->drawText($translate->_($v), $l, $y, 'UTF-8');
            }
            $l += (isset($v['size']) && is_array($v)) ? $v['size'] : 200;
        }
        $cont = 1;
        foreach ($rows as $row):
            $cont++;
            $row = $table->decrypt($row);
            $l = $x;
            $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_TIMES), 10);
            foreach ($campos as $c => $k) {
                if (is_array($k)) {
                    if (isset($k['size']))
                        $this->_helper->getHelper('QuebraLinha')->quebraLinha($page, $row[$k['name']], $l, $y - 20, $k['size']);
                    else
                        $this->_helper->getHelper('QuebraLinha')->quebraLinha($page, $row[$k['name']], $l, $y - 20, 50);
                } else {
                    if (is_array($k))
                        $this->_helper->getHelper('QuebraLinha')->quebraLinha($page, $row[$k['name']], $l, $y - 20, 50);
                    else
                        $this->_helper->getHelper('QuebraLinha')->quebraLinha($page, $row[$k], $l, $y - 20, 50);
                }

                $l += (isset($k['size']) && is_array($k)) ? $k['size'] : 200;
            }

            $imagem = Zend_Pdf_Image::imageWithPath('img/ciserp_semfundo.png');
            //Colocando imagem no PDF
            $page->drawImage($imagem, 30, 30, 70, 70);

            $rodape = "Data da criação do formulários: " . date('d/m/Y') . "     Usuário:" . $nome . "\n";
            $cont_pag = "Página " . $pagina . " de " . $numero;

            //ESCREVE
            if ($y > 100) {
                $page->drawText($rodape, $x + 80, 40, 'UTF-8');
                $page->drawText($cont_pag, 250, 30, 'UTF-8');
            }

            if ($y <= 100) {


                $page->drawText($rodape, $x + 80, 40, 'UTF-8');
                $page->drawText($cont_pag, 250, 30, 'UTF-8');
                $pagina += 1;
                $y = 740;

                // Add new page to the document 
                $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
                $pdf->pages[] = $page;

                $this->_helper->getHelper('Cabecalho')->cabecalho($page, $pagina, $numero, $translate->_("report_title_" . $table_class), '/' . $request->getModuleName() . '/' . $request->getControllerName());


                //ESCREVE
                $l = $x;
                foreach ($campos as $c => $k) {
                    if (is_array($k)) {
                        if (!isset($config[$c]['title']))
                            $page->drawText($translate->_($c), $l, $y, 'UTF-8');
                        else
                            $page->drawText($translate->_($config[$c]['title']), $l, $y, 'UTF-8');
                    }else {
                        if (!isset($config[$c]['title']))
                            $page->drawText($translate->_($k), $l, $y, 'UTF-8');
                        else
                            $page->drawText($translate->_($config[$k]['title']), $l, $y, 'UTF-8');
                    }
                    $l += (is_array($k)) ? $k['size'] : 200;
                    ;
                }
            }

            $y -= 20;

        endforeach;

        // Get PDF document as a string 
        $pdfData = $pdf->render();

        header("Content-Disposition: attachment; filename=relatorio.pdf");
        header("Content-type: application/x-pdf");
        echo $pdfData;
        exit;
    }

}

?>
