<?php

class serv_Model_DbTable_Servproduto extends Zsam_Db_Table {

	protected $_name  = 'servprodutos';

	var $_autocomplet = array('ITEM_PROGR','NUM_ITEM','PRODUTO');

	protected $model;

	var $_conf = array(			
			'CLIENTE' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'NUMERO'                => array('edit' => 'N'),
			'NUM_ITEM'              => array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
            'ID'					=> array('edit' => 'N'),
			'EMPRESA' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'PRODUTO' 				=> array('autocomplete'=>'Y','NULLABLE' => false),
            'PROPRIEDADE'           => array('edit' => 'N'),      
            'DESCRICAO_PROBLEMA'    => array('edit' => 'N'),      
            'QUANTIDADE'            => array('NULLABLE' => false),
            'PRECO_CUSTO'           => array('edit' => 'N'),      
            'TOTAL_SERVICO'         => array('edit' => 'N'),
			'NUMERO_NF'             => array('edit' => 'N'),      
            'DATA_NF'               => array('edit' => 'N'),      
            'NUM_NF_RETORNO'        => array('edit' => 'N'),      
            'DATA_RETORNO'          => array('edit' => 'N'),      
			'BAIXA' 				=> array('edit' => 'N'),              
			'INFORMACAO_ADICIONAL'  => array('help'=>'help_quebrar_linha_com_;'),
            'FUNC_ALTERACAO'        => array('edit' => 'N'),
			'DATA_ALTERACAO'        => array('edit' => 'N'),
			'REVISAO' 				=> array('edit' => 'N'),
			'DATASINC' 				=> array('edit' => 'N')
	);
	
	var $_referenceMap = array(
			'PRODUTO' => array(
					'columns' 	=> 'PRODUTO',
					'refTitle' 	=> 'DESCRICAO'
			),

			'EMPRESA' => array(
					'columns' 	=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 	=> 'NOME'
			),
	);
	
	public function __construct(){
		
		parent::__construct();

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		$cliente = Zend_Registry::get('Cliente');
		if($cliente[0]['IND_COM_SERV'] == "I")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'ind_Model_DbTable_Produto','table2' => 'ind_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}

		else if($cliente[0]['IND_COM_SERV'] == "C")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'com_Model_DbTable_Produto','table2' => 'com_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}

		else
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = 'core_Model_DbTable_Ativoprodutos';
			$this->_referenceMap['PRODUTO']['refColumns'] = 'CODIGO';
		}

		$this->model = new serv_Model_Manutitem();
	}
	
	
	public function atualizar($id1,$id2,$id3)
	{
		$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
		$sql->execute();
	
	}

	
}
?>