<?php

class serv_Model_DbTable_Ordemservico extends Zsam_Db_Table
{
    protected $_name = 'ordemservico';

    public $_autocomplet = array('ID');

	public $_restrict = null;

    public $_conf = array(
        'ID'               	=> array('edit' => 'N', "grid"=>true),
        'SERVICO'          	=> array('edit' => 'N', "grid"=>true),
        'SERV_ITEM'         => array('NULLABLE' => false),
        'EMPRESA' 			=> array('edit' => 'N', "grid"=>true, 'NULLABLE' => false),
        'ITEM'              => array('edit' => 'N', "grid"=>true),
        'CLIENTE' 			=> array('edit' => 'N', "grid"=>true, 'NULLABLE' => false),
        'TIPO_ORDEM'        => array('NULLABLE' => false,'grid' => true,'VP' => array('S' => 'SUPORTE', 'I' => 'INSTALACAO', 'E' => 'EMBARQUE')),
        'NUMERO_CHAMADO'	=> array('grid' => true),
        'PRIORIDADE'        => array('VP' => array('B' => 'Baixa', 'M' => 'Media', 'A' => 'Alta', 'R' => 'Melhoria'), 'NULLABLE' => false),
        'HORA_INICIO'		=> array('validate' => array('Cisweb_Validate_Horasitesurvey')),
        'HORA_FIM'			=> array(),
        'HORA_INICIO2'		=> array(),
        'HORA_FIM2'			=> array(),
		'DATA_I' 			=> array('title' =>'DATA','NULLABLE' => false),
        'DATA_ATENDIMENTO'	=> array(),
        'STATUS' 			=> array('VP' => array('C' => 'Concluido', 'P' => 'Pendente')),
        'NOME_CLIENTE'		=> array(),
        'FECHADO'			=> array('edit' => 'N'),
        'MODELO'            => array(),
        'INFORMACAO_ADICIONAL'=> array('help'=>'help_quebrar_linha_com_;'),
        'FUNC_ALTERACAO' 	=> array('edit' => 'N'),
        'DATA_ALTERACAO' 	=> array('edit' => 'N'),
        'REVISAO' 			=> array('edit' => 'N'),
        'DATASINC'			=> array('edit' => 'N'),
        'GRID'              => array('type' => 'itemGridAuto', //Padrão, indica o helper que monta a grid
                                    'configitem'    => 'GRID', //Indica qual campo do atributo $zsam_form_item da controladora deve ser usado             
                                    'model'     => 'serv_Model_DbTable_Ordemservicotecnico', //Model do filho
                                    //Colunas que aparecerão na grid
                                    'columns'   => array('NUM_ITEM','SERVICO','EMPRESA','OS','TECNICO'),
                                    'idWhere'   => array('SERVICO','EMPRESA','OS'),//Chave primária sem o campo "auto increment"
                                    'buttons'   => array('edit'=>'S', 'del' => 'S')),//Configuração dos botões da grid
        'GRID1'             => array('type' => 'itemGridAuto', //Padrão, indica o helper que monta a grid
                                    'configitem'    => 'GRID1', //Indica qual campo do atributo $zsam_form_item da controladora deve ser usado             
                                    'model'     => 'serv_Model_DbTable_Ordemservicorecurso', //Model do filho
                                    //Colunas que aparecerão na grid
                                    'columns'   => array('NUM_ITEM','SERVICO','EMPRESA','OS','RECURSO'),
                                    'idWhere'   => array('SERVICO','EMPRESA','OS'),//Chave primária sem o campo "auto increment"
                                    'buttons'   => array('edit'=>'S', 'del' => 'S')),//Configuração dos botões da grid

    );

    public $_referenceMap = array(
        'EMPRESA' => array(
            'columns' 		=> 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'EMPRESA'
        ),

        'CLIENTE' => array(
            'columns' 		=> 'CLIENTE',
            'refTableClass'     => 'serv_Model_DbTable_Cliente',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'CLIENTE'
        ),
        
        'SERV_ITEM' => array(
            'columns' 		=> 'SERV_ITEM',
            'refTableClass' => 'serv_Model_DbTable_Servico',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'NUMERO'
        ),

        'GRID' => array(
            'columns'       => 'ID',
            'refTableClass' => 'serv_Model_DbTable_Ordemservicotecnico',
            'refColumns'    => 'ID',
            'refTitle'      => 'ITEM'
        ),
        'GRID1' => array(
            'columns'       => 'ID',
            'refTableClass' => 'serv_Model_DbTable_Ordemservicorecurso',
            'refColumns'    => 'ID',
            'refTitle'      => 'ITEM'
        ),

        /*'MODELO' => array(
            'columns'       => 'MODELO',
            'refTableClass' => 'serv_Model_DbTable_Modeloordemservico',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'DESCRICAO'
        ),*/
    );

    public function __construct()
    {
        parent::__construct();

        $controller = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action = $controller->getActionName(); //pegar a controladora
        
        
        if ($nome_controller == 'ordemservico') {
			$this->_restrict = 'FECHADO IS NULL';
        }

        if($nome_action == 'upd'){
            
            $this->_conf['NOME_CLIENTE']['NULLABLE']    = false;
            $this->_conf['HORA_INICIO']['NULLABLE']     = false;
            $this->_conf['DATA_I']['NULLABLE']     		= false;
            $this->_conf['HORA_FIM']['NULLABLE']        = false;
        }
    }
    
    
    public function beforeValidade(&$form,$dados){
    	
        if ($dados['STATUS'] == 'C'){
            
            $form->getElement("NOME_CLIENTE")->setRequired(true);
            $form->getElement("DATA_ATENDIMENTO")->setRequired(true);
            $form->getElement("DATA_I")->setRequired(true);
        }
        
        if ($dados['STATUS'] == 'P'){
            
            $form->getElement("NOME_CLIENTE")->setRequired(true);
            $form->getElement("DATA_ATENDIMENTO")->setRequired(true);
            $form->getElement("DATA_I")->setRequired(true);
        }
    }

    public function beforeUpdate(array $data,$where)
    {
        $status = $data['STATUS'];
        
        if ($status == 'C') {
            $data['FECHADO'] = 'S';
        }
        
        //Gera um nova ordemservico
        if($status == 'P') {
                        
            $table   = new serv_Model_DbTable_Ordemservico();
            $select_os = $table->select()
                            ->from('ordemservico', array('MAX(ITEM) AS ITEM'))
                            ->where('SERVICO = ?', $where[' SERVICO = ? '])
                            ->where('EMPRESA = ?', $where[' EMPRESA = ? ']);

            $select = $table->getAdapter()->fetchRow($select_os);

            $data_apoio['ITEM']             = $select['ITEM']+1;
            $data_apoio['EMPRESA']          = $where[' EMPRESA = ? '];
            $data_apoio['SERVICO']          = $where[' SERVICO = ? '];
            $data_apoio['CLIENTE']          = $data['CLIENTE'];
            $data_apoio['DATA_I']		        = null;
            $data_apoio['TIPO_ORDEM']       = $data['TIPO_ORDEM'];
            $data_apoio['NUMERO_CHAMADO']   = $data['NUMERO_CHAMADO'];
    		$data_apoio['NOME_CLIENTE'] 	= null;
            $data_apoio['HORA_INICIO']      = null;
            $data_apoio['HORA_FIM']         = null;
    		$data_apoio['DATA_ATENDIMENTO'] = null;
    		$data_apoio['HORA_INICIO2'] 	= null;
    		$data_apoio['HORA_FIM2'] 		= null;
    		$data_apoio['STATUS'] 			= null;

            $data['FECHADO']                = 'S';

            $table->insert($data_apoio);            
        }
        
        return parent::beforeUpdate($data,$where);
    }

    public function atualizar($id1, $id2, $id3)
    {
        $sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
        $sql->execute();
    }

    public function calcula_total($dados_item)
    {
        $total = 0;

        foreach ($dados_item as $key => $value) {
            $total 		+= $value['PRECO_TOTAL_ITEM'];
        }

        return $total;
    }

    public function getEmpresa($emp)
    {

        $table = new core_Model_DbTable_Empresa();
        $dados = $table->find($emp)->toArray();

        return $dados[0];
    }
    
    public function Buscaservitem($serv, $emp){
        
        $table_servico = new serv_Model_DbTable_Servico();
        $table = new serv_Model_DbTable_Servitem();
		$dados = $table->select()->from($table, array('SERVICO'))->where("NUMERO = '$serv' AND EMPRESA = '$emp'")->group("SERVICO"); //die($dados);
        $dados = $table->getAdapter()->fetchAll($dados); 
        
        //$serv_item = array();
        
        foreach($dados as $k => $v){
            
            $dados_servico = $table_servico->find($v['SERVICO'])->toArray(); 
            
            $serv_item[] = $dados_servico[0];
            //$serv_item = $dados_servico[0]['DESCRICAO'];
        }
        return $serv_item;
        //return $dados[0]['DESCRICAO_DETALHADA'];
        
    }
    
    
}
