<?php

class serv_Model_DbTable_Manutauto extends Zsam_Db_Table {

    /**
     * The default table name
     */
    protected $_name 		= 'manut';
    var $_autocomplet 		= array('CLIENTE','ITEM');
    //var $regime 			= null;

    
    var $_conf = array(
        'ID'					=> array("grid"=>true,'edit' => 'N'),
        'ITEM'	         		=> array("grid"=>true,'NULLABLE' => false,'edit' => 'N'),
	    'EMPRESA'        		=> array("grid"=>true,'NULLABLE' => false,'edit' => 'N'),
    	'CLIENTE' 		 		=> array('autocomplete'=>'Y',"grid"=>true,'NULLABLE' => false,'edit' => 'N'),
        'CONTATO'         		=> array('NULLABLE' => false),
        'VENDEDOR'   			=> array('editlevel' => '3'),
        'DATA_ORCAMENTO'		=> array('edit' => 'N'),
		'FECHAR_ORCAMENTO'  	=> array(),
    	'DATA_PREV_ENTREGA' 	=> array(),	
    	'OBS_PREV_ENTREGA' 		=> array(),
    	'DATA_ENTREGA' 			=> array(),
    	'OBS_ENTREGA' 			=> array(),
        'VALOR_TOTAL'    		=> array('edit' => 'N'),
		'DATA_EXECUCAO_SERV'	=> array('title' => 'DATANECESSIDADE', 'NULLABLE' => false),
        'NUMERO_NF'				=> array('edit' => 'N'),
        'DATA_NF'				=> array('edit' => 'N'),
		'VENCIMENTO'			=> array('title' => 'VENC'),
		'JUROS'					=> array(),
		'ULTIMO_ITEM'    		=> array('edit' => 'N'),
		'TIPO'					=> array(),
        'TIPO_R_L'				=> array(),
		'TIPO_FRETE' 			=> array('VP' => 'FOB,CIF,EXW', 'NULLABLE' => false),
		'VALOR_FRETE' 			=> array(),
		'VALOR_SEGURO' 			=> array(),
        'PRAZO_ENTREGA_DIAS'	=> array('NULLABLE' => false),
        'OBSERVACAO'			=> array(),
        'REFERENCIA_CLIENTE'	=> array("grid"=>true),
        'REFERENCIA_PEDIDO'		=> array(),
		'BAIXA'          		=> array(),
		'DEPARTAMENTO' 			=> array(),
		'STATUS' 				=> array(),
		'STATUS_PADRAO'			=> array(),
		'SITUACAO'        		=> array('title' => 'tem_estoque_S_sim_N_nao_K_falta_num_serie'),
        'APROVACAO'				=> array('edit' => 'N'),
    	

        'GRID'    				=> array('type' 				=> 'itemGridAuto', //Padrão, indica o helper que monta a grid
        											'configitem' 	=> 'GRID', //Indica qual campo do atributo $zsam_form_item da controladora deve ser usado			  
									        		'model' 			=> 'serv_Model_DbTable_Manutitem', //Model do filho
									        		//Colunas que aparecerão na grid
									        		'columns' 		=> array('NUM_ITEM','PRODUTO','QUANTIDADE','PRECO_UNITARIO','PRECO_TOTAL_ITEM'),
									        		'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),//Chave primária sem o campo "auto increment"
									        		'buttons'			=> array('edit'=>'S', 'del' => 'S')),//Configuração dos botões da grid
         
        'GRID1'    				=> array('type' 				=> 'itemGridAuto',
        												'configitem' 	=> 'GRID1',
										        		'model' 			=> 'serv_Model_DbTable_Manuthoras',
										        		'columns' 		=> array('NUM_ITEM','SERVICO','QUANTIDADE','PRECO','TOTALITEM'),
										        		'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),
										        		'buttons'			=> array('edit'=>'S', 'del' => 'S')),
						        		
		'GRID2'    				=> array('type' 				=> 'itemGridAuto',
														'configitem' 	=> 'GRID2',
										        		'model' 			=> 'serv_Model_DbTable_Manutsitesurvey',
										        		'columns' 		=> array('CLIENTE','ITEM_PROGR','NUM_ITEM','DATA','NUMERO_CHAMADO'),
										        		'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),
										        		'buttons'			=> array('edit'=>'S', 'del' => 'S')),
						        
        'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
        'DATA_ALTERACAO' 		=> array('edit' => 'N'),
        'REVISAO'        		=> array('edit' => 'N'),
        'DATASINC'       		=> array('edit' => 'N'),
	);
    var $_referenceMap = array(
        'EMPRESA' => array(
            'columns'       => 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'NOME'
        ),
        'CLIENTE' => array(
            'columns'       => 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'CLIENTE'
        ),
        'CONDICOES_GERAIS' => array(
            'columns'       => 'CONDICOES_GERAIS',
            'refTableClass' => 'core_Model_DbTable_Obsvendas',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'CONDICOES_GERAIS'
        ),

		'VENDEDOR' => array(
            'columns'           => 'VENDEDOR',
            'refTableClass'     => 'core_Model_DbTable_Usuario',
            'refColumns'        => 'ID',
            'refTitle'          => 'VENDEDOR'
    	),

    	'VENCIMENTO' => array(
            'columns'           => 'VENCIMENTO',
            'refTableClass'     => 'core_Model_DbTable_Vencimento',
            'refColumns'        => 'ID',
            'refTitle'          => 'VENC'
    	),

    	'CONTATO' => array(
            'columns'           => 'CONTATO',
            'refTableClass'     => 'core_Model_DbTable_Clientecontatoitem',
            'refColumns'        => 'ID',
            'refTitle'          => 'CONTATO',
    	    'semChave'			=> 'S'    //neste caso � quando temos uma chave primaria composta e incluimos o ID para poder fazer orelacionamento
										//porem o ID n�o � chave primaria e portanto no zsam form simple (linha +-103) desabilitamos o validador do zend para chave primaria
		),

    	'DEPARTAMENTO' => array(
    		'columns'           => 'DEPARTAMENTO',
    		'refTableClass'     => 'core_Model_DbTable_Depto',
    		'refColumns'        => 'DEPARTAMENTO',
    		'refTitle'          => 'DEPARTAMENTO'
    	),

    	'STATUS_PADRAO' => array(
    		'columns'           => 'STATUS_PADRAO',
    		'refTableClass'     => 'core_Model_DbTable_Obsprogr',
    		'refColumns'        => 'CODIGO',
    		'refTitle'          => 'STATUS_PADRAO'
    	),

   		
    	'GRID' =>  array(
    				'columns' 		=> 'ITEM_PROGR',
    				'refTableClass' => 'serv_Model_DbTable_Manutitem',
    				'refColumns' 	=> 'ITEM_PROGR',
    				'refTitle' 			=> 'ITEM'
    	),
    		 
    	'GRID1' =>  array(
    				'columns' 			=> 'ITEM_PROGR',
    				'refTableClass' 	=> 'serv_Model_DbTable_Manuthoras',
    				'refColumns' 		=> 'ITEM_PROGR',
    				'refTitle' 				=> 'ITEM'
    		),
    		
    	'GRID2' =>  array(
    			'columns' 			=> 'ITEM_PROGR',
    			'refTableClass' 	=> 'serv_Model_DbTable_Manutsitesurvey',
    			'refColumns' 		=> 'ITEM_PROGR',
    			'refTitle' 				=> 'ITEM'
    	)

    );
    public function __construct()
    {
        $this->config  = Zend_Registry::get('Cisweb_Config');
        $controller      = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action 	 = $controller->getActionName(); //pegar a controladora

	    $auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
			$level  = @$user['NIVEL'];
            $acessorestrito = @$user['ACESSORESTRITO'];
		}

        if ($level < 3 && $this->config[0]['VENDEDOR_POR_CLIENTE_RESTRICT'] != 'N') {
            $this->_restrict = "(FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O') AND VENDEDOR =" .$id;
        } else {
            $this->_restrict = "FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
        }

		$config_modulos = new Cisweb_Db_Abstract('config_modulos');
		$dados_modulos  = $config_modulos->fetchRow()->toArray();
		if ($acessorestrito == 'S' && $dados_modulos['USAR_ACESSO_RESTRITO'] == 'S' ){//neste caso tem o mesmo nível de um nivel 3
		    $this->_restrict = " FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
		}

        if($nome_controller == 'manut')
        {
            $this->_conf['DEPARTAMENTO']['NULLABLE'] = FALSE;
            
            if ($nome_action == 'upd')
            {
            	$table  = new Cisweb_Db_Abstract("manut");
            	$venc 	= new Cisweb_Db_Abstract("venc");
            	
            	$id 	= $controller->getParam("id");
            	$id 	= explode(":", $id);
            	$id1 	= $id[0];
            	$id2 	= $id[1];
            	$dados 	= $table->getAdapter()->fetchRow($table->select()->where("CLIENTE = '$id1' AND ITEM = '$id2'"));
     
            	if ($dados['VENCIMENTO'] != '')
            	{
            		$this->_conf['VENCIMENTO']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S' or ID = '{$dados['VENCIMENTO']}'";
            	}
            	else
            	{
            		$this->_conf['VENCIMENTO']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S'";
            	}	 	
        
            	
            }		
        
        }
        
        if($nome_controller == 'impressaoormclientemanut')
        {
            $this->_restrict = "TIPO = 'O' AND FECHAR_ORCAMENTO = 'S' ";
            $this->_conf['DATA_ORCAMENTO']['grid'] = true;
        }
        
        if($nome_controller == 'impressaopedidoclientemanut')
        {
        	$this->_restrict = "TIPO = 'P'";
        	$this->_conf['DATA_ORCAMENTO']['grid'] 		= true;
        	$this->_conf['REFERENCIA_CLIENTE']['grid'] 	= false;
        	$this->_conf['REFERENCIA_PEDIDO']['grid'] 	= true;
        	$this->_conf['NUMERO_NF']['grid'] 			= true;
        	$this->_conf['DATA_NF']['grid'] 			= true;
        }

        if($nome_controller == 'reprovaitemmanut')
        {
            $this->_restrict = "TIPO = 'O'";
        }

        if($nome_controller == 'pedidosparafaturarmanut')
        {
            $this->_restrict = "(SITUACAO = 'S' OR SITUACAO = 'K')  AND TIPO = 'P' AND (BAIXA <> 'B' OR BAIXA IS NULL)";
            $this->_conf['VALOR_TOTAL']['grid'] 		= TRUE;
            $this->_conf['REFERENCIA_CLIENTE']['grid']	= FALSE;
            $this->_conf['STATUS']['grid'] 				= TRUE;
            $this->_conf['STATUS_PADRAO']['grid'] 		= TRUE;
        }

        if($nome_controller == 'pedidosparafaturarmanutsemestoque')
        {
            $this->_restrict = "SITUACAO = 'N' AND TIPO = 'P'";
            $this->_conf['VALOR_TOTAL']['grid'] 		= TRUE;
            $this->_conf['REFERENCIA_CLIENTE']['grid']	= FALSE;
            $this->_conf['STATUS']['grid'] 				= TRUE;
            $this->_conf['STATUS_PADRAO']['grid'] 		= TRUE;
        }

        parent::__construct();
    }
    
    
    public function calcula_total($id)
    {
    
    	$table 		= new serv_Model_DbTable_Manutitem();
    	$table2 	= new serv_Model_DbTable_Manut();
    	$cli 		= $id[0];
    	$item 		= $id[1];
    	
    	$dados_item = $table->getAdapter()->fetchAll($table->select()->where("CLIENTE = '$cli' AND ITEM_PROGR = '$item'"));
    	 
      	$total = 0;
    
    	foreach ($dados_item as $key => $value)
    	{
    		$total 		+= $value['PRECO_TOTAL_ITEM'];
    	}
    
    	$data['VALOR_TOTAL'] = $total;
    	
    	$where = "CLIENTE = '$cli' AND ITEM = '$item'";
    	
    	$table2->update($data,$where);
    }
    
    public function GeraPedidos($id, $data_p)
    {

    	$table 						= new serv_Model_DbTable_Manutitem();
    	$table_horas 			= new serv_Model_DbTable_Manuthoras();
    	
    	$table_serv 			 = new serv_Model_DbTable_Serv();
    	$table_servitem		 = new serv_Model_DbTable_Servitem();
    	
    	$table_progr 			= new serv_Model_DbTable_Programa();
    	$tableitem 				= new serv_Model_DbTable_Programaitem();
    	
    	$tableitemloc 			= new Cisweb_Db_Abstract("locacaoitens");
    	$table_loc				= new serv_Model_DbTable_Locacao();
    	
    	$tableitemlocserv 	= new Cisweb_Db_Abstract("locacaoservitens");
    	$table_locserv			= new serv_Model_DbTable_Locacaoserv();
    	
    	$row 		= $this->decrypt(array_shift($this->findMultipleKey($id)));
    	$cli 			= $row['CLIENTE'];
    	$item 		= $row['ITEM'];
    	
    	$dados_item 	= $table->getAdapter()->fetchAll($table->select()->where("CLIENTE = '$cli' AND ITEM_PROGR = '$item'"));
    	$dados_horas 	= $table_horas->getAdapter()->fetchAll($table_horas->select()->where("CLIENTE = '$cli' AND ITEM_PROGR = '$item'"));
    	 
    	$psim 			= false;
    	$lsim 			= false;
    	
    	/*Atualiza ManutHoras*/
    	/*$data_horas['FECHADO'] 					= 'S';
    	$data_horas['DATANECESSIDADE']  	= $data_p;
    	$where = "CLIENTE = '$cli' AND ITEM_PROGR = '$item'";
    	$table_horas->update($data_horas, $where);*/
    	
    	foreach ($dados_item as $key => $value){
    		
    		if (@$value['NATUREZA_OPERACAO'] == 'L'){
    			$lsim = true;
    			
    		}elseif (@$value['NATUREZA_OPERACAO'] == 'V'){
    			$psim = true;
    		}
    	}
    	
    	
    	if ($psim){
    		
    		$tablecli			= new serv_Model_DbTable_Cliente();
    		$cod_cli 			= $row['CLIENTE'];
    		
    		$camposcli 			= $tablecli->find($row['CLIENTE'])->current()->toArray();
    		$soma 				= @$camposcli['ULTIMO_PROSPEC'] + 1;
    		$data_cli 			= array('ULTIMO_PROSPEC'=>$soma);
    		$where          	= "CODIGO = '$cod_cli'";
    		$tablecli->update($data_cli,$where);
    		
    		$data_orm['CLIENTE'] 			= $row['CLIENTE'];
    		$data_orm['ITEM'] 				= $soma;
    		$data_orm['EMPRESA'] 			= $row['EMPRESA'];
    		$data_orm['VENDEDOR'] 			= $row['VENDEDOR'];
    		$data_orm['DATA_ORCAMENTO'] 	= $row['DATA_ORCAMENTO'];
    		$data_orm['CONTATO'] 			= $row['CONTATO'];
    		$data_orm['VENCIMENTO'] 		= $row['VENCIMENTO'];
    		$data_orm['VALOR_TOTAL'] 		= $row['VALOR_TOTAL'];
    		$data_orm['DATA_PREV_ENTREGA'] 	= $row['DATA_PREV_ENTREGA'];
    		$data_orm['OBS_PREV_ENTREGA'] 	= $row['OBS_PREV_ENTREGA'];
    		$data_orm['JUROS'] 				= $row['JUROS'];
    		$data_orm['TIPO_FRETE'] 		= $row['TIPO_FRETE'];
    		$data_orm['VALOR_FRETE'] 		= $row['VALOR_FRETE'];
    		$data_orm['VALOR_SEGURO'] 		= $row['VALOR_SEGURO'];
    		$data_orm['PRAZO_ENTREGA_DIAS'] = $row['PRAZO_ENTREGA_DIAS'];
    		$data_orm['OBSERVACAO'] 		= $row['OBSERVACAO'];
    		$data_orm['REFERENCIA_CLIENTE'] = $row['REFERENCIA_CLIENTE'];
    		$data_orm['REFERENCIA_PEDIDO'] 	= $row['REFERENCIA_PEDIDO'];
    		$data_orm['SITUACAO'] 			= $row['SITUACAO'];
    		$data_orm['DEPARTAMENTO'] 		= $row['DEPARTAMENTO'];
    		$data_orm['NUM_PROJETO'] 		= $row['ID'];

    		$data_orm['FECHAR_ORCAMENTO']	= 'S';
    		$data_orm['TIPO']				= 'P';
    		$data_orm['TIPO_R_L']			= 'R';
    		 
    		
    		$table_progr->insert($data_orm);

    		$v = 0;
    		foreach ($dados_item as $key => $value)
    		{
    		
    			if ($value['NATUREZA_OPERACAO'] == 'V')
    			{
    				$v ++;
    				
    				$dataprogitem['CLIENTE'] 				= $value['CLIENTE'];
    				$dataprogitem['EMPRESA']				= $value['EMPRESA'];
    				$dataprogitem['NUM_ITEM']				= $v;
    				$dataprogitem['ITEM_PROGR']				= $soma;
    				
    				$dataprogitem['PRODUTO'] 				= $value['PRODUTO'];
    				$dataprogitem['QUANTIDADE']				= $value['QUANTIDADE'];
    				$dataprogitem['PRECO_UNITARIO']			= $value['PRECO_UNITARIO'];
    				$dataprogitem['UNI'] 					= $value['UNI'];
    				$dataprogitem['NCM']					= $value['NCM'];
    				$dataprogitem['CFOP']					= $value['CFOP'];
    				$dataprogitem['PRECO_TOTAL_ITEM']		= $value['PRECO_TOTAL_ITEM'];
    				$dataprogitem['ORIGEM_SIT_TRIBUTARIA']	= $value['ORIGEM_SIT_TRIBUTARIA'];
    				
    				$dataprogitem['STICMS'] 				= $value['STICMS'];
    				$dataprogitem['ALIQUOTA_ICMS']			= $value['ALIQUOTA_ICMS'];
    				$dataprogitem['BASE_DE_CALCULO_ICMS']	= $value['BASE_DE_CALCULO_ICMS'];
    				$dataprogitem['TOTAL_ICMS']				= $value['TOTAL_ICMS'];
    				
    				$dataprogitem['STIPI'] 					= $value['STIPI'];
    				$dataprogitem['BASE_DE_CALCULO_IPI']	= $value['BASE_DE_CALCULO_IPI'];
    				$dataprogitem['ALIQUOTA_IPI']			= $value['ALIQUOTA_IPI'];
    				$dataprogitem['TOTAL_IPI']				= $value['TOTAL_IPI'];
    				
    				$dataprogitem['STPIS'] 					= $value['STPIS'];
    				$dataprogitem['BASE_DE_CALCULO_PIS']	= $value['BASE_DE_CALCULO_PIS'];
    				$dataprogitem['ALIQUOTA_PIS']			= $value['ALIQUOTA_PIS'];
    				$dataprogitem['TOTAL_PIS']				= $value['TOTAL_PIS'];
    				
    				$dataprogitem['STCOFINS'] 				= $value['STCOFINS'];
    				$dataprogitem['BASE_DE_CALCULO_COFINS']	= $value['BASE_DE_CALCULO_COFINS'];
    				$dataprogitem['ALIQUOTA_COFINS']		= $value['ALIQUOTA_COFINS'];
    				$dataprogitem['TOTAL_COFINS']			= $value['TOTAL_COFINS'];
    				
    				$tableitem->insert($dataprogitem);
    			}	
    		}
    	}

    	if ($lsim)
    	{

    		$table			= new core_Model_DbTable_Empresa();
    		$where  		= "CODIGO = ".$row['CLIENTE'];
    		$campos 		= $table->getAdapter()->fetchAll($table->select()->where($where));
    		$soma 			= @$campos[0]['ULTIMA_LOCACAO']+1;
    		
    		$data_ormloc['CLIENTE'] 			= $row['CLIENTE'];
    		$data_ormloc['NUMERO'] 				= $soma;
    		$data_ormloc['EMPRESA'] 			= $row['EMPRESA'];
    		$data_ormloc['VENDEDOR'] 			= $row['VENDEDOR'];
    		$data_ormloc['DATA_ORCAMENTO'] 		= $row['DATA_ORCAMENTO'];
    		$data_ormloc['CONTATO'] 			= $row['CONTATO'];
    		$data_ormloc['VENCIMENTO'] 			= $row['VENCIMENTO'];
    		$data_ormloc['TOTAL'] 				= $row['VALOR_TOTAL'];
    		$data_ormloc['DEPARTAMENTO'] 		= $row['DEPARTAMENTO'];
    		$data_ormloc['NUM_PROJETO'] 		= $row['ID'];
    		
    		$data_ormloc['FECHAR_ORCAMENTO']	= 'S';
    		$data_ormloc['TIPO']				= 'P';
    		 
    		$table_loc->insert($data_ormloc);
    	
    		$l = 0;
    		foreach ($dados_item as $key => $value)
    		{
    	
    			if ($value['NATUREZA_OPERACAO'] == 'L')
    			{
    				$l ++;
    				
    				$dataprogitemloc['EMPRESA']					= $value['EMPRESA'];
    				$dataprogitemloc['ITEM']					= $l;
    				$dataprogitemloc['NUMERO']					= $soma;
    				$dataprogitemloc['PRODUTO'] 				= $value['PRODUTO'];
    				$dataprogitemloc['QUANTIDADE']				= $value['QUANTIDADE'];
    				$dataprogitemloc['PRECO']					= $value['PRECO_UNITARIO'];
    				$dataprogitemloc['CUSTO_NF_ENVIO'] 			= $value['PRECO_CUSTO'];
    				$dataprogitemloc['TOTALITEM']				= $value['PRECO_TOTAL_ITEM'];
    				
    				$tableitemloc->insert($dataprogitemloc);
    			}
    		}
    	}
    	
    	/*
    	 * cria o servico
    	 */ 
    	
    	foreach ($dados_horas as $key => $value){
    	    
    		//Locacao Serv
    		if (@$value['NATUREZA_OPERACAO']  == 'L'){
    			$lsim = true;
    			 
    		//Servico	
    		}elseif (@$value['NATUREZA_OPERACAO'] == 'S'){
    			$psim = true;
    		}
    	}
    	 
    	//Servico
    	if ($psim)
    	{
    		$table			= new core_Model_DbTable_Empresa();
    		$where  		= "CODIGO = ".$row['CLIENTE'];
    		$campos 		= $table->getAdapter()->fetchAll($table->select()->where($where));
    		$soma 			= @$campos[0]['ULTIMO_SERV']+1;
    	
    		$data_ormloc											= array();
    		$data_ormloc['CLIENTE'] 						= $row['CLIENTE'];
    		$data_ormloc['NUMERO'] 						= $soma;
    		$data_ormloc['EMPRESA'] 						= $row['EMPRESA'];
    		$data_ormloc['VENDEDOR'] 					= $row['VENDEDOR'];
    		$data_ormloc['DATA_ORCAMENTO'] 	= $row['DATA_ORCAMENTO'];
    		$data_ormloc['CONTATO'] 						= $row['CONTATO'];
    		$data_ormloc['VENCIMENTO'] 				= $row['VENCIMENTO'];
    		$data_ormloc['TOTAL'] 							= $row['VALOR_TOTAL'];
    		$data_ormloc['DEPARTAMENTO'] 			= $row['DEPARTAMENTO'];
    		$data_ormloc['NUM_PROJETO'] 			= $row['ID'];
    	
    		$data_ormloc['FECHAR_ORCAMENTO']		= 'S';
    		$data_ormloc['TIPO']									= 'P';
    		 
    		$table_serv->insert($data_ormloc);
    		 
    		$l = 0;
    		foreach ($dados_horas as $key => $value)
    		{
    			 
    			if ($value['NATUREZA_OPERACAO'] == 'L')
    			{
    				$l ++;
    				$dataprogitemloc										= array();
    				$dataprogitemloc['EMPRESA']					= $value['EMPRESA'];
    				$dataprogitemloc['ITEM']							= $l;
    				$dataprogitemloc['NUMERO']					= $soma;
    				$dataprogitemloc['SERVICO'] 					= $value['SERVICO'];
    				$dataprogitemloc['QUANTIDADE']				= $value['QUANTIDADE'];
    				$dataprogitemloc['PRECO']						= $value['PRECO'];
    				$dataprogitemloc['TOTALITEM']					= $value['TOTALITEM'];
    	
    				$table_servitem->insert($dataprogitemloc);
    			}
    		}
    	}
    	
    	//Locacaoserv
    	if ($lsim)
    	{
    		$table			= new core_Model_DbTable_Empresa();
    		$where  		= "CODIGO = ".$row['CLIENTE'];
    		$campos 		= $table->getAdapter()->fetchAll($table->select()->where($where));
    		$soma 			= @$campos[0]['ULTIMA_LOCACAO_SERV']+1;
    	
    		$data_ormloc											= array();
    		$data_ormloc['CLIENTE'] 						= $row['CLIENTE'];
    		$data_ormloc['NUMERO'] 						= $soma;
    		$data_ormloc['EMPRESA'] 						= $row['EMPRESA'];
    		$data_ormloc['VENDEDOR'] 					= $row['VENDEDOR'];
    		$data_ormloc['DATA_ORCAMENTO'] 	= $row['DATA_ORCAMENTO'];
    		$data_ormloc['CONTATO'] 						= $row['CONTATO'];
    		$data_ormloc['VENCIMENTO'] 				= $row['VENCIMENTO'];
    		$data_ormloc['TOTAL'] 							= $row['VALOR_TOTAL'];
    		$data_ormloc['DEPARTAMENTO'] 			= $row['DEPARTAMENTO'];
    		$data_ormloc['NUM_PROJETO'] 			= $row['ID'];
    	
    		$data_ormloc['FECHAR_ORCAMENTO']		= 'S';
    		$data_ormloc['TIPO']									= 'P';
    		 
    		$table_locserv->insert($data_ormloc);
    		 
    		$l = 0;
    		foreach ($dados_horas as $key => $value)
    		{
    			 
    			if ($value['NATUREZA_OPERACAO'] == 'L')
    			{
    				$l ++;
    				$dataprogitemloc										= array();
    				$dataprogitemloc['EMPRESA']					= $value['EMPRESA'];
    				$dataprogitemloc['ITEM']							= $l;
    				$dataprogitemloc['NUMERO']					= $soma;
    				$dataprogitemloc['SERVICO'] 					= $value['SERVICO'];
    				$dataprogitemloc['QUANTIDADE']				= $value['QUANTIDADE'];
    				$dataprogitemloc['PRECO']						= $value['PRECO'];
    				$dataprogitemloc['TOTALITEM']					= $value['TOTALITEM'];
    	
    				$tableitemlocserv->insert($dataprogitemloc);
    			}
    		}
    	}
    	
    	/*if (count($dados_horas) > 0)
    	{
    	
    		$tablecli			= new serv_Model_DbTable_Cliente();
    		$cod_cli 			= $row['CLIENTE'];
    		
    		$camposcli 			= $tablecli->find($row['CLIENTE'])->current()->toArray();
    		$soma 				= @$camposcli['ULTIMO_PROSPEC'] + 1;
    		$data_cli 			= array('ULTIMO_PROSPEC'=>$soma);
    		$where          	= "CODIGO = '$cod_cli'";
    		$tablecli->update($data_cli,$where);
    		
    		$data_ormserv						= array();
    		$data_ormserv['CLIENTE'] 			= $row['CLIENTE'];
    		$data_ormserv['ITEM'] 				= $soma;
    		$data_ormserv['EMPRESA'] 			= $row['EMPRESA'];
    		$data_ormserv['VENDEDOR'] 			= $row['VENDEDOR'];
    		$data_ormserv['DATA_ORCAMENTO'] 	= $row['DATA_ORCAMENTO'];
    		$data_ormserv['CONTATO'] 			= $row['CONTATO'];
    		$data_ormserv['VENCIMENTO'] 		= $row['VENCIMENTO'];
    		$data_ormserv['VALOR_TOTAL'] 		= $row['VALOR_TOTAL'];
    		$data_ormserv['DATA_PREV_ENTREGA'] 	= $row['DATA_PREV_ENTREGA'];
    		$data_ormserv['OBS_PREV_ENTREGA'] 	= $row['OBS_PREV_ENTREGA'];
    		$data_ormserv['JUROS'] 				= $row['JUROS'];
    		$data_ormserv['TIPO_FRETE'] 		= $row['TIPO_FRETE'];
    		$data_ormserv['VALOR_FRETE'] 		= $row['VALOR_FRETE'];
    		$data_ormserv['VALOR_SEGURO'] 		= $row['VALOR_SEGURO'];
    		$data_ormserv['PRAZO_ENTREGA_DIAS'] = $row['PRAZO_ENTREGA_DIAS'];
    		$data_ormserv['OBSERVACAO'] 		= $row['OBSERVACAO'];
    		$data_ormserv['REFERENCIA_CLIENTE'] = $row['REFERENCIA_CLIENTE'];
    		$data_ormserv['REFERENCIA_PEDIDO'] 	= $row['REFERENCIA_PEDIDO'];
    		$data_ormserv['SITUACAO'] 			= $row['SITUACAO'];
    		$data_ormserv['DEPARTAMENTO'] 		= $row['DEPARTAMENTO'];
    		$data_ormserv['NUM_PROJETO'] 		= $row['ID'];
    		 
    		$data_ormserv['FECHAR_ORCAMENTO']	= 'S';
    		$data_ormserv['TIPO']				= 'P';
    		 
    		$table_serv->insert($data_ormserv);

    		$v = 0;
    		foreach ($dados_horas as $key => $value)
    		{
    		
    				$v ++;
    		
    				$dataprogitemserv['CLIENTE'] 				= $value['CLIENTE'];
    				$dataprogitemserv['EMPRESA']				= $value['EMPRESA'];
    				$dataprogitemserv['NUM_ITEM']				= $v;
    				$dataprogitemserv['ITEM_PROGR']				= $soma;
    		
    				$dataprogitemserv['MVS'] 					= $value['MVS'];
    				$dataprogitemserv['PRECO_UNITARIO']			= $value['PRECO_UNITARIO'];
    				$dataprogitemserv['PRECO_TOTAL_ITEM']		= $value['PRECO_TOTAL_ITEM'];
    				$dataprogitemserv['QTD_HORAS']				= @$value['QTD_HORAS'];
    				
    				$table_servitem->insert($dataprogitemserv);
    		}
    	}*/
    }
    


  	public function beforeInsert(array $data) {
        if (is_null($data['TIPO']) || $data['TIPO'] == ''){
			$data['TIPO'] = 'O';
		}
        return parent::beforeInsert($data);
    }
    
    public function getCfop($cli,$emp)
    {
    
    
    	$table_empresa			= new Cisweb_Db_Abstract("empresa");
    	$table_cliente			= new Cisweb_Db_Abstract("cliente");
    	$table_estado			= new Cisweb_Db_Abstract("estados");
    	$table_cidade			= new Cisweb_Db_Abstract("cidades");
    	$table_pais				= new Cisweb_Db_Abstract("paises");
    	$table_cfop				= new Cisweb_Db_Abstract("cfop");
    
    	//Dados da empresa
    	$camposemp 				= $table_empresa->find($emp)->current();
    	$camposcityemp 			= $table_cidade->find($camposemp['CIDADE'])->current();
    	$camposestadoempresa	= $table_estado->find($camposcityemp['UF'])->current();
    	$campospaisempresa		= $table_pais->find($camposestadoempresa['PAIS'])->current();
    
    	//Dados do cliente
    	$camposcli 				= $table_cliente->find($cli)->current();
    	$camposcitycli 			= $table_cidade->find($camposcli['CIDADE'])->current();
    	$camposestadocliente	= $table_estado->find($camposcitycli['UF'])->current();
    	$campospaiscliente		= $table_pais->find($camposestadocliente['PAIS'])->current();
    
    
    	if ($camposestadoempresa['PAIS'] != $camposestadocliente['PAIS'])
    	{
    		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 6999 AND CODIGO < 8000) AND TIPONF = 'F'"));
    
    	}
    	elseif($camposcityemp['UF'] != $camposcitycli['UF'])
    	{
    		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 5999 AND CODIGO < 7000) AND TIPONF = 'F'"));
    
    	}
    	else
    	{
    		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 4999 AND CODIGO < 6000) AND TIPONF = 'F'"));
    
    	}
    
    	return $camposcfop;
    }
}
?>