<?php

class serv_Model_DbTable_Locacaointeritem extends Zsam_Db_Table {


	protected $_name = 'locacaointeritens';

        var $_conf = array(
            'NUMERO' 					=> array("grid"=>true,'edit'=>'N'),
            'EMPRESA' 					=> array("grid"=>true,'edit'=>'N'),
            'ITEM' 						=> array("grid"=>true,'edit'=>'N'),
            'ID'						=> array('edit'=>'N'),
            'SERVICO' 					=> array('editlevel'=>3,"grid"=>true,'NULLABLE' => false,'autocomplete'=>'Y','help'=>'help_inicie_a_digitacao_para_pesquisa'),
            'TIPO'						=> array('edit'=>'N'),
           	'QUANTIDADE' 				=> array('title'=>'QUANTIDADE_NECESSIDADE','NULLABLE' => false),
            'PRECO' 					=> array('NULLABLE' => false,'edit'=>'S'),
            'DESCRICAO'					=> array('edit'=>'N'),
           	'TOTALITEM' 				=> array('edit'=>'N'),
            'COM_CONTRATO'	 			=> array('edit'=>'N'),
            'PRECO_MINIMO_SUGERIDO'		=> array('edit'=>'N'),
        	'DATA_NECESSIDADE_CLIENTE'	=> array(),
        	'DATA_INCLUSAO_CONTRATO'	=> array('edit'=>'N'),
            'DATA_CANCELAMENTO'			=> array('edit'=>'N'),
	        );


        var $_referenceMap = array(

       'SERVICO' => array(
            'columns' 		=> 'SERVICO',
            'refTableClass' => 'serv_Model_DbTable_Servico',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'DESCRICAO'//nao alterar .. campo para aparecer o nome...
        ),

        'EMPRESA' => array(
            'columns' 		=> 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'NOME'//nao alterar .. campo para aparecer o nome...
        ),
	);
        
	public function __construct(){
		
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName();
		
		if($nome_controller == 'locacaointercancelar'){
			$this->_conf['SERVICO']['edit'] 				 = 'N';
			$this->_conf['QUANTIDADE']['edit'] 				 = 'N';
			$this->_conf['PRECO']['edit'] 					 = 'N';
			$this->_conf['DATA_NECESSIDADE_CLIENTE']['edit'] = 'N';
			$this->_conf['DATA_CANCELAMENTO']['edit'] 	 	 = 'S';
			$this->_conf['DATA_CANCELAMENTO']['NULLABLE'] 	 = false;
			$this->_conf['DATA_CANCELAMENTO']['validate']	 = array('Cisweb_Validate_Datacancelamentolocacaointer');
			
			$this->_restrict = "DATA_CANCELAMENTO IS NULL AND TIPO = 'P'";
		}
		
		if($nome_controller == 'locacaointeritemapoio'){
			$this->_conf['QUANTIDADE']['edit'] 				 = 'N';
			$this->_conf['PRECO']['editlevel'] 				 = 3;
			$this->_conf['DATA_NECESSIDADE_CLIENTE']['edit'] = 'N';
		}
		
		return parent::__construct();
	}        	
	
    public function beforeInsert(array $data){
        
        $numero  = $data['NUMERO'];
        $empresa = $data['EMPRESA'];
        
        $table = new Cisweb_Db_Abstract("locacaointer");
        $dado  = $table->fetchRow($table->select()->where("NUMERO = ?",$numero)->where("EMPRESA = ?",$empresa))->toArray();
        
        if(!is_null($dado['CONTRATO'])){
            
            $data['COM_CONTRATO'] = $dado['NUMERO'];
            
        }else{
            $data['COM_CONTRATO'] = 1;
        }
        
        $data['DATA_INCLUSAO_CONTRATO'] = $dado['DATA_INICIO_CONTRATO'];
        
		return parent::beforeInsert($data);
    }

   	public function beforeUpdate(array $data,$where)
	{

        $data['TOTALITEM'] = $data['PRECO']*$data['QUANTIDADE'];

		return parent::beforeUpdate($data,$where);

	}

    public function atualizar($id1,$id2,$id3)
    {
            $sql = $this->_db->prepare('UPDATE '.$this->_name.' SET ITEM = ITEM - 1 WHERE NUMERO='.$id1.' AND EMPRESA='.$id2.' AND ITEM>'.$id3);
            $sql->execute();
   	}

}
?>