<?php

class serv_Model_DbTable_Faturapendenteloc extends Zsam_Db_Table {

	protected $_name = 'faturapendenteloc';

	var $_restrict   = "BAIXA IS NULL";

    public function __construct(){

        $controller      = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora

	    $auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
			$level  = @$user['NIVEL'];
		}

        if($nome_controller == 'faturapendenteloc')
        {
			
			if($level >= 3) {
				$this->_conf['EMPRESA']['edit'] 		= 'S';
				$this->_conf['DATA']['edit'] 			= 'S';
				$this->_conf['CLIENTE']['edit'] 		= 'S';
				$this->_conf['CLIENTE']['autocomplete']	= 'Y';
				$this->_conf['CONTRATO']['edit'] 		= 'S';
				$this->_conf['NFES_OU_FATURA']['edit'] 	= 'S';
			}
		
        }
        parent::__construct();
    }
	
	
	
 	var $_conf = array(
 			'NUMERO' 					=> array('edit' => 'N'),
 			'EMPRESA' 					=> array('edit' => 'N'),
 			'DATA' 						=> array('grid' => true,'edit' => 'N'),
 			'CLIENTE' 					=> array('grid' => true,'edit' => 'N'),
 			'TOTAL' 					=> array('grid' => true),
 			'CONTRATO' 					=> array('edit' => 'N','grid' => true),
 			'IMPRESSAO' 				=> array('edit' => 'N'),
 			'OBSERVACAO' 				=> array('grid' => true),
 			'NFES_OU_FATURA' 			=> array('edit' => 'N','grid' => true,'validate' => array('Cisweb_Validate_FaturaModelo'),'VP' => 'FATURA,NFES'),
 			'BAIXA' 					=> array('edit' => 'N'),
 			'FATURA_MODELO' 			=> array(),
 			'VENCIMENTO' 				=> array('NULLABLE' => false),
 			'FORMA_ENVIO' 				=> array('VP' => array('C' => 'COB_CARTEIRA', 'S' => 'BOLETO_SEMREGISTRO','R' => 'BOLETO_COMREGISTRO'),'NULLABLE' => false),
 			'BANCO' 					=> array('NULLABLE' => false),
 			'PERIODO_FATURA' 			=> array('case'=>'NONE','NULLABLE' => false),
 			'PLANO_CONTA'				=> array('autocomplete'=>'Y','NULLABLE' => false),
 			'FUNC_ALTERACAO' 			=> array('edit' => 'N'),
 			'DATA_ALTERACAO' 			=> array('edit' => 'N'),
 			'REVISAO' 					=> array('edit' => 'N'),
       );
        
        protected $_referenceMap = array(
        'EMPRESA' => array(
            'columns' 		=> 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'EMPRESA'
        ),
        'CLIENTE' => array(
            'columns' 		=> 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'CLIENTE'
        ),

        'BANCO' => array(
            'columns' 		=> 'BANCO',
            'refTableClass' => 'core_Model_DbTable_Banco',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'BANCO'
        ),
    
        'FATURA_MODELO' => array(
            'columns' 		=> 'FATURA_MODELO',
            'refTableClass' => 'serv_Model_DbTable_Faturamodelo',
            'refColumns' 	=> 'ID_FATURA',
            'refTitle' 		=> 'ID_FATURA'
        ),
        		
        'PLANO_CONTA' => array(
        	'columns'           => 'PLANO_CONTA',
        	'refTableClass'     => 'core_Model_DbTable_Planoc',
        	'refColumns'        => 'PLANO_CONTA',
        	'refTitle'          => 'PLANO_CONTA'
		),
    );
}

?>