<?php

class serv_Model_DbTable_Fatura extends Zsam_Db_Table {

	protected $_name = 'fatura';

	var $_restrict = null;

	public function __construct()
	{
		parent::__construct();

		$controller = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA


		if($nome_controller == 'fatura')
		{

			$this->_restrict = NULL;

			$this->_conf['CANCELAMENTO']['grid'] = true;

		}

		if($nome_controller == 'faturacancelar')
		{
			$tipo= "CANCELAMENTO = '' OR CANCELAMENTO IS NULL";
			$this->_restrict = $tipo;

			$this->_conf['CANCELAMENTO']['NULLABLE'] = false;

		}

		if($nome_controller == 'faturagerenciar')
		{
			$this->_conf['CANCELAMENTO']['grid'] 	= true;
			$this->_conf['CANCELAMENTO']['edit'] 	= 'N';
			$this->_conf['PLANO_CONTA']['edit'] 	= 'N';
			$this->_conf['FATURA_MODELO']['edit'] 	= 'N';
		}

		if($nome_controller == 'gerenciarfatura' || $nome_controller == 'faturamensalloc' || $nome_controller == 'faturamensalserv')
		{

		    if($nome_controller == 'gerenciarfatura')
		    {
		        $this->_restrict = "IMPRESSAO <> ''";
		    }

		    if($nome_controller == 'faturamensalloc' || $nome_controller == 'faturamensalserv'){

		        $this->_restrict 		= "IMPRESSAO IS NULL";
		        $this->zsam_ordena_grid = 'NUMERO,EMPRESA DESC';
		    }


			$this->_conf = array(
					'NUMERO' 				=> array("grid"=>true,'NULLABLE' => false,'edit'=>'N'),
					'EMPRESA' 				=> array('edit'=>'N',"grid"=>true, 'NULLABLE' => false),
					'DATA' 					=> array('edit'=>'N',"grid"=>true),
					'CLIENTE' 				=> array('edit'=>'N','autocomplete'=>'Y',"grid"=>true, 'NULLABLE' => false,'help'=>'help_digite_para_pesquisar'),
					'NOME_CLI'				=> array('edit'=>'N'),
					'CNPJ_CLI'				=> array('edit'=>'N'),
					'IE_CLI'				=> array('edit'=>'N'),
					'TOTAL' 				=> array('editlevel'=>4),
					'CONTRATO' 				=> array("grid"=>true,'edit'=>'N'),
					'IMPRESSAO'				=> array('edit'=>'N','grid' => true),
					'FATURA_MODELO'			=> array(),
					'REPRESENTANTE' 		=> array('edit'=>'N'),
					'CODVENC' 				=> array('edit'=>'N','title'=>'VENC'),
					'VENCIMENTO' 			=> array('edit'=>'S',"grid"=>true),
					'FORMA_ENVIO' 			=> array('edit'=>'N','VP'=> array('C' => 'COB_CARTEIRA', 'S' => 'BOLETO_SEMREGISTRO','R' => 'BOLETO_COMREGISTRO'),'NULLABLE' => false),
					'BANCO' 				=> array('edit'=>'N',),
					'PERIODO_FATURA' 		=> array('editlevel'=>3,'char_spec'=>'NONE','case'=>'NONE'),
					'DATASINC' 				=> array('edit'=>'N'),
					'FUNC_ALTERACAO' 		=> array('edit'=>'N'),
					'DATA_ALTERACAO' 		=> array('edit'=>'N'),
					'REVISAO' 				=> array('edit'=>'N'),

			);

		}

	}


 	var $_conf = array(
        	'NUMERO' 				=> array("grid"=>true,'NULLABLE' => false,'edit'=>'N'),
        	'EMPRESA' 				=> array("grid"=>true,'edit'=>'N', 'NULLABLE' => false),
            'DATA' 					=> array("grid"=>true,'edit'=>'S','edit'=>'N'),
            'CLIENTE' 				=> array('edit'=>'N',"grid"=>true, 'NULLABLE' => false),
            'NOME_CLI'				=> array('edit'=>'N'),
            'CNPJ_CLI'				=> array('edit'=>'N'),
            'IE_CLI'				=> array('edit'=>'N'),
            'TOTAL' 				=> array('edit'=>'N'),
            'CONTRATO' 				=> array("grid"=>true,'edit'=>'N'),
          	'PLANO_CONTA' 				=> array(),
          	'DUPLI' 				=> array(),
            'IMPRESSAO'				=> array('edit'=>'N',"grid"=>true),
            'FATURA_MODELO'			=> array(),
            'REPRESENTANTE' 		=> array('edit'=>'N'),
           	'CODVENC' 				=> array('edit'=>'N','title'=>'VENC'),
          	'VENCIMENTO' 			=> array('edit'=>'N','grid' => true),
            'FORMA_ENVIO' 			=> array('edit'=>'N','VP'=> array('C' => 'COB_CARTEIRA', 'S' => 'BOLETO_SEMREGISTRO','R' => 'BOLETO_COMREGISTRO'),'NULLABLE' => false),
          	'BANCO' 				=> array('edit'=>'N',),
            'APROVACAO' 			=> array(),
			'PERIODO_FATURA' 		=> array('edit'=>'N','char_spec'=>'NONE','case'=>'NONE'),
            'CANCELAMENTO' 			=> array('editlevel'=>3,'char_spec'=>'NONE','case'=>'NONE','title'=>'motivo_cancelamento','help'=>'deletar_dupli'),
 			'FUNC_ALTERACAO' 		=> array('edit'=>'N'),
           	'DATA_ALTERACAO' 		=> array('edit'=>'N'),
            'REVISAO' 				=> array('edit'=>'N'),
          	'DATASINC' 				=> array('edit'=>'N'),
          	'GRID' 					=> array(),
       );


        protected $_referenceMap = array(
        'EMPRESA' => array(
            'columns' 		=> 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'EMPRESA'
        ),
        'CLIENTE' => array(
            'columns' 		=> 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'CLIENTE'
        ),

        'BANCO' => array(
            'columns' 		=> 'BANCO',
            'refTableClass' => 'core_Model_DbTable_Banco',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'BANCO'
        ),

        'CODVENC' => array(
            'columns' 		=> 'CODVENC',
            'refTableClass' => 'core_Model_DbTable_Vencimento',
            'refColumns' 	=> 'ID',
            'refTitle' 		=> 'VENC'
        ),

        'FATURA_MODELO' => array(
            'columns' 		=> 'FATURA_MODELO',
            'refTableClass' => 'serv_Model_DbTable_Faturamodelo',
            'refColumns' 	=> 'ID_FATURA',
            'refTitle' 		=> 'ID_FATURA'
        ),


   		'PLANO_CONTA' => array(
 			'columns'           => 'PLANO_CONTA',
        	'refTableClass'     => 'core_Model_DbTable_Planoc',
        	'refColumns'        => 'PLANO_CONTA',
        	'refTitle'          => 'PLANO_CONTA'
       	),

    );

    public function beforeInsert(array $data)
	{

		$table	= new core_Model_DbTable_Empresa();

		$where  = "CODIGO = ".$data['EMPRESA'];
		$campos = $table->getAdapter()->fetchAll($table->select()->where($where));

		$soma 		= @$campos[0]['ULTIMA_FATURA']+1;
		$data_emp 	= array('ULTIMA_FATURA'=>$soma);
		$table->update($data_emp,$where); // atualiza a tabela empresa antes de inserir a fatura

		$data['NUMERO']=$soma; // recebe o num da fatura da tabela empresa

		//die();
		$date= date('Y-m-d');
		$data['DATA']= $date;
		return parent::beforeInsert($data);
    }

	public function beforeUpdate(array $data,$where)
	{
        $id = $where[" NUMERO = ? "];
		$controller = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

		$cancel	 = $data["CANCELAMENTO"];

		if($nome_controller == 'faturacancelar')
		{
		    if (!is_null($cancel) && $calcel <> ''){
				$table2 		= new core_Model_DbTable_Duplicata();
				$adapter2 		= $table2->getAdapter();
				$where2 		= $adapter2->quoteInto('FATURA = ?', $id);
				$table2->delete($where2);
			}
		}

        return parent::beforeUpdate($data, $where);
    }

    public function deleteCascade($id,$emp){

		if ($nome_controller == 'gerenciarfatura')
		{
			$table2 		= new core_Model_DbTable_Duplicata();
			$adapter2 		= $table2->getAdapter();
			$where2 		= $adapter2->quoteInto('FATURA = ?', $id);
			$table2->delete($where2);
		}
    }

}

?>