<?php
class serv_Model_DbTable_Clientews extends Zsam_Db_Table {


    protected $_name = 'clientews';
    
    var $_autocomplet = array('CODIGO', 'NOME', 'FANTASIA', 'CNPJ');

    private $config;

    var $_conf = array(
        
        "CODIGO" 					=> array("grid" => true, 'width' => 1 /* cada unidade representa 50px */, "edit" => "N", 'NULLABLE' => false, 'help' => 'help_cod'),
        "NOME" 						=> array("grid" => true, 'width' => 4, 'NULLABLE' => false, 'title' => 'razao_social'),
        "FANTASIA" 					=> array("grid" => true, 'width' => 6, 'NULLABLE' => false),
        
        "CNPJ" 						=> array("grid" => true, 'help' => 'help_cnpj', 'validate' => array('Zsam_Validate_Cp')),
        "INDICADOR_IE"				=> array('NULLABLE' => false,"VP" => array('1' => 'contribuinte_do_icms', '2' => 'contribuinte_isento', '3' => 'nao_contribuinte')),
		"IE" 						=> array('validate' => array('Cisweb_Validate_Inscricaoest')), 
		"ENDERECO" 					=> array('NULLABLE' => false),
        "COMPLEMENTO" 				=> array(),
        "NUMERO_ENDERECO" 			=> array('NULLABLE' => false),
        "BAIRRO" 					=> array('NULLABLE' => false),
        "CEP" 						=> array('NULLABLE' => false, 'help' => 'help_cep'),
        "CEP1" 						=> array('NULLABLE' => false, 'help' => 'help_cep2'),
        'CIDADE' 					=> array('autocomplete' => 'Y', 'NULLABLE' => false, 'grid' => true),
        "ESTADO"					=> array("edit" => "N"),
		'REFERENCIA' 				=> array('title' => 'ponto_referencia'),
        "END_COB" 					=> array(),
		"COMPLEMENTO_COB"			=> array("edit" => "S"),
        "NUMERO_END_COB" 			=> array('title' => 'NUMERO_ENDERECO'),
        "BAI_COB" 					=> array('title' => 'BAIRRO'),
        "CIDADE_COB" 				=> array('autocomplete' => 'Y', 'title' => 'CIDADE', 'alt' => 'alt_desc_cidade'),
        "CEP_COB" 					=> array('title' => 'CEP', 'help' => 'help_cep'),
        "CEP_COB1" 					=> array('title' => 'CEP', 'help' => 'help_cep2'),
        "END_ENTREGA" 				=> array(),
		"COMPLEMENTO_ENTREGA"		=> array("edit" => "S"),
        "NUMERO_END_ENTREGA" 		=> array('title' => 'NUMERO_ENDERECO'),
        "BAI_ENTREGA" 				=> array('title' => 'BAIRRO'),
        "CIDADE_ENTREGA" 			=> array('autocomplete' => 'Y', 'title' => 'CIDADE', 'alt' => 'alt_desc_cidade'),
        "CEP_ENTREGA" 				=> array('title' => 'CEP', 'help' => 'help_cep'),
        "CEP_ENTREGA1" 				=> array('title' => 'CEP', 'help' => 'help_cep2'),
        "FONEFAX" 					=> array('validate' => array('Cisweb_Validate_Telefone')),
		"VENC" 						=> array(),
        "TRANSP" 					=> array('NULLABLE' => false),
		"DATA_CRIACAO" 				=> array('edit' => 'N'),
		"DATASINC" 					=> array('edit' => 'N'),
     
    );
    var $_referenceMap    = array(

        'CIDADE' => array(
            'columns'           => 'CIDADE',
            'refTableClass'     => 'core_Model_DbTable_Cidade',
            'refColumns'        => 'ID',
            'refTitle'          => 'CIDADE'
    	),


    	'VENC' => array(
            'columns'           => 'VENC',
            'refTableClass'     => 'core_Model_DbTable_Vencimento',
            'refColumns'        => 'ID',
            'refTitle'          => 'VENC'
    	),

        'CIDADE_COB' => array(
            'columns'           => 'CIDADE_COB',
            'refTableClass'     => 'core_Model_DbTable_Cidade',
            'refColumns'        => 'ID',
            'refTitle'          => 'CIDADE_COB'
    	),

        'CIDADE_ENTREGA' => array(
            'columns'           => 'CIDADE_ENTREGA',
            'refTableClass'     => 'core_Model_DbTable_Cidade',
            'refColumns'        => 'ID',
            'refTitle'          => 'CIDADE_ENTREGA'
    	),

        'TRANSP' => array(
            'columns'           => 'TRANSP',
            'refTableClass'     => 'core_Model_DbTable_Transportadora',
            'refColumns'        => 'CODIGO',
            'refTitle'          => 'TRANSP'
    	)
    );
	
	public function getCidade($idCli) {
        $select = $this->select(false)->setIntegrityCheck(false);
        $select->from(array('cli' => 'cliente'), array())
                ->join(array('c' => 'cidades'), 'cli.CIDADE = c.ID', array('ID', 'cidadeNome' => 'c.NOME', 'cidadeCodigoIBGE' => 'c.CODIGO_IBGE'))
                ->join(array('est' => 'estados'), 'c.UF = est.UF', array('UF', 'estadoCodigoIBGE' => 'CODIGO_IBGE'))
                ->join(array('p' => 'paises'), 'est.PAIS = p.ISO', array('ISO', 'paisNome' => 'p.NOME'))
                ->where('cli.codigo=?', $idCli);
        $row = $this->fetchRow($select);
        if ($row == null)
            return null;
        $row = $this->decrypt($row);
        return $row;
    }
    
}
?>