<?php

class especial_Model_DbTable_Nfdadoscaminhao extends Zsam_Db_Table {

	protected $_name = 'nfdadoscaminhao';

	var $_restrict = null;
	var $data_hoje = null;

	public function __construct()
	{
		parent::__construct();

		$controller 		= Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller 	= $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA
		$nome_action  		= $controller->getActionName();
		$this->data_hoje 	= date('Y-m-d');
		$dia				= date('d');
		$mes				= date('m');
		$ano				= date('Y');
		$data_mk 			= mktime ( 0, 0, 0, $mes, $dia-30, $ano );
		$this->data30		= date("Y-m-d", $data_mk);

		if($nome_controller == 'nfdadoscaminhaosaida')
		{

			$this->_restrict = "HORA_SAIDA IS NULL";
			$this->_conf['PLACA']['edit'] 					= 'N';
			$this->_conf['MOTORISTA']['edit'] 				= 'N';
			$this->_conf['TIPO_VEICULO']['edit'] 			= 'N';
			$this->_conf['TRANSP']['edit'] 					= 'N';
			$this->_conf['TIPO_ENTRADA']['edit'] 			= 'N';
			$this->_conf['HORA_SAIDA']['edit'] 				= "N";
			$this->_conf['HORA_SAIDA']['help'] 				= 'help_horaautomatica';
			$this->_conf['NUMERO_PESSOAS_CAMINHAO']['edit'] = "N";
			$this->_conf['HORA_ENTRADA']['edit'] 			= "N";

		
		if ($nome_action == 'upd')
			{

				$id 	= $controller->getParam('id');
				$table  = new especial_Model_DbTable_Nfdadossaida();
				$campos = $table->getAdapter()->fetchAll($table->select()->where("ID_CAMINHAO = '$id'"));
				$count  = count($campos);

				if ($count == 0)
				{

					$this->_conf['GRID']['buttons'] = array('edit'=>'S','rem'=>'S','insert'=>'S');

				}
				else
				{
					$this->_conf['GRID']['buttons'] = array('edit'=>'N','rem'=>'N','insert'=>'N');
				}


			}

		}

		if($nome_controller == 'nfdadoscaminhao')
		{

			$this->_restrict = "HORA_SAIDA IS NULL";
//			$this->_conf['MOTORISTA']['RESTRICT_MAP'] = "CNH <> '' AND DATA_VENC_CNH >= '$this->data30'";
		}

	}

 	var $_conf = array(
 			'ID_CAMINHAO' 				=> array("grid"=>true,'edit'=>'N'),
 			'PLACA' 					=> array("grid"=>true,'NULLABLE' => false),
 			'MOTORISTA' 				=> array('autocomplete'=>'Y'),
 			'TIPO_VEICULO' 				=> array("VP" => array("SERVICO","FUNCIONARIO"),'NULLABLE' => false),
 			'TRANSP' 					=> array('autocomplete'=>'Y',"grid"=>true,'NULLABLE' => false),
 			'HORA_ENTRADA' 				=> array("grid"=>true,'edit'=>'N'),
 			'HORA_SAIDA' 				=> array("grid"=>true,'edit'=>'N'),
 			'NUMERO_PESSOAS_CAMINHAO' 	=> array(),
 	        'TIPO_ENTRADA' 				=> array("VP" => array("PERNOITE","ENTRADA/SAIDA"),'NULLABLE' => false),
 			'NUMERO_CRACHA' 			=> array("grid"=>true),
 			'FUNC_ALTERACAO' 			=> array('edit'=>'N'),
 			'DATA_ALTERACAO' 			=> array('edit'=>'N'),
 			'REVISAO' 					=> array('edit'=>'N'),
 			'GRID'						=> array('type' 		=> 'itemGrid',
 												 'model' 		=> 'especial_Model_DbTable_Nfdadossaida',
 												 'controller' 	=> 'especial_NfdadossaidaitemController',
 												 'columns' 		=>  array('ID_CAMINHAO','ITEM','ID_NFE','NUMERO','DATA_NF','CNPJ'),
 												 'idWhere' 		=> 'ID_CAMINHAO')

 	);


 	protected $_referenceMap    = array(


 			'MOTORISTA' => array(
 					'columns'           => 'MOTORISTA',
 					'refTableClass'     => 'especial_Model_DbTable_Visitantes',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'MOTORISTA'
 			),

 			'TRANSP' => array(
 					'columns'           => 'TRANSP',
 					'refTableClass'     => 'core_Model_DbTable_Transportadora',
 					'refColumns'        => 'CODIGO',
 					'refTitle'          => 'TRANSP'
 			),

 			'GRID' => array(
 					'columns'           => 'ID_CAMINHAO',
 					'refTableClass'     => 'especial_Model_DbTable_Nfdadossaida',
 					'refColumns'        => 'ID_CAMINHAO',
 					'refTitle'          => 'ID_CAMINHAO'
 			)
 	);

	public function beforeInsert(array $data) {

		$controller = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

		$data['HORA_ENTRADA']   = date('Y-m-d G:i:s');

		return parent::beforeInsert($data);

	}

	public function beforeUpdate(array $data,$where){

		$controller = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

		if($nome_controller == 'nfdadoscaminhaosaida')
		{
			$data['HORA_SAIDA'] = date('Y-m-d G:i:s');
		}

		return parent::beforeUpdate($data,$where);

	}
}

?>