<?php
class especial_Model_DbTable_Dentista extends Zsam_Db_Table {


    protected $_name 		= 'dentista';
    var $_autocomplet 		= array('CODIGO','CRO','NOME');
    private $config;

    var $_conf = array(
        
        "CODIGO" 					=> array("grid" => true, 'width' => 1 /* cada unidade representa 50px */, "edit" => "N", 'NULLABLE' => false, 'help' => 'help_cod'),
		"CRO"						=> array('NULLABLE' => false),
		"CODIGO_USUARIO"			=> array(),
        "NOME" 						=> array("grid" => true, 'width' => 4, 'NULLABLE' => false, 'title' => 'razao_social'),
		"EMAIL" 					=> array('level' => 3,"grid"=>true,"case"=>"LOWER","cripto"=>"cisweb",'validate'=>"Zend_Validate_EmailAddress", "title" => "email_usuario",'NULLABLE' => false),
        "FANTASIA" 					=> array("grid" => true, 'width' => 6),
        "CNPJ" 						=> array("grid" => true, 'help' => 'help_cnpj',/*'validate' => array('Zsam_Validate_Cp')*/),
        "INDICADOR_IE"				=> array("VP" => array('1' => 'contribuinte_do_icms', '2' => 'contribuinte_isento', '3' => 'nao_contribuinte')),
		"IE" 						=> array(/*'validate' => array('Cisweb_Validate_Inscricaoest'),*/ "help" => "help_cnpj"),
        "INSCRICAO_MUNICIPAL" 		=> array(),
        "ENDERECO" 					=> array('NULLABLE' => false),
        "COMPLEMENTO" 				=> array(),
        "NUMERO_ENDERECO" 			=> array('NULLABLE' => false),
        "BAIRRO" 					=> array('NULLABLE' => false),
        "CEP" 						=> array('NULLABLE' => false, 'help' => 'help_cep'),
        "CEP1" 						=> array('NULLABLE' => false, 'help' => 'help_cep2'),
        'CIDADE' 					=> array('autocomplete' => 'Y', 'NULLABLE' => false, 'grid' => true),
        "ESTADO"					=> array("edit" => "N"),
		'REFERENCIA' 				=> array('title' => 'ponto_referencia'),
        "ID_RADIO" 					=> array('case' => 'NONE'),
        "FONEFAX" 					=> array('validate' => array('Cisweb_Validate_Telefone')),
        "DIACERTOVENC1" 			=> array(),
        "DIACERTOVENC2" 			=> array(),
        "DIACERTOVENC3" 			=> array(),
        "DIACERTOVENC4" 			=> array(),
        "DIACERTOVENC5" 			=> array(),
        "DIACERTOVENC6" 			=> array(),
        "PROTESTAR" 				=> array('VP' => array('S' => 'SIM', 'N' => 'NAO')),
        "SITUACAO"					=> array('VP' => array('N' => 'normal', 'P' => 'com_problema_de_pagamento')),
		"DATA_CRIACAO" 				=> array("edit" => "N"),
		"FUNC_CRIACAO"				=> array("edit" => "N"),
        "FUNC_ALTERACAO" 			=> array("edit" => "N"),
        "DATA_ALTERACAO" 			=> array("edit" => "N"),
        "DATASINC" 					=> array("edit" => "N"),
        "REVISAO" 					=> array("edit" => "N"),
    );
	
    var $_referenceMap    = array(

		'CIDADE' => array(
            'columns'           => 'CIDADE',
            'refTableClass'     => 'core_Model_DbTable_Cidade',
            'refColumns'        => 'ID',
            'refTitle'          => 'CIDADE'
    	),
    );
    

    public function beforeInsert(array $data) {
		
		$table_usuario = new core_Model_DbTable_Usuario();
		
		$login = explode(' ',$data['NOME']);
		$login = strtolower($login[0]);
		
		$data_usuario['NOME'] 					= $data['NOME'];
		$data_usuario['LOGIN'] 					= $login;
		$data_usuario['LOGIN_MANUAL'] 			= $login;
		$data_usuario['LOGIN_ADM_MANUAL'] 		= $login;
		$data_usuario['SENHA'] 					= '102030';
		$data_usuario['EMAIL'] 					= $data['EMAIL'];
		$data_usuario['NIVEL'] 					= 3;
		$data_usuario['ACESSORESTRITO'] 		= null;
		$data_usuario['FUNC'] 					= null;
		$data_usuario['M1'] 					= 'S';
		$data_usuario['M2'] 					= 'S';
		$data_usuario['M3'] 					= 'S';
		$data_usuario['M4'] 					= 'S';
		$data_usuario['M5'] 					= 'S';
		$data_usuario['M6'] 					= 'S';
		$data_usuario['M7'] 					= 'S';
		$data_usuario['M8'] 					= 'S';
		$data_usuario['M9'] 					= 'S';
		$data_usuario['M10'] 					= 'S';
		$data_usuario['M11'] 					= 'S';
		$data_usuario['MODULO_AHP'] 			= 'S';
		$data_usuario['MODULO_APS'] 			= 'S';
		$data_usuario['MODULO_CTN'] 			= 'S';
		$data_usuario['MODULO_COMPRASVMI'] 		= 'S';
		$data_usuario['MODULO_DEMANDA'] 		= 'S';
		$data_usuario['MODULO_ESTOQUE'] 		= 'S';
		$data_usuario['MODULO_ESTOQUE6SIGMA'] 	= 'S';
		$data_usuario['MODULO_FINAN'] 			= 'S';
		$data_usuario['MODULO_FISCAL'] 			= 'S';
		$data_usuario['MODULO_MANUAL'] 			= 'S';
		$data_usuario['MODULO_PRODUCAO'] 		= 'S';
		$data_usuario['MODULO_PROJETOS'] 		= 'S';
		$data_usuario['MODULO_PROJETOS6SIGMA'] 	= 'S';
		$data_usuario['MODULO_QUALIDADE'] 		= 'S';
		$data_usuario['MODULO_RH'] 				= 'S';
		$data_usuario['MODULO_TREINAMENTO'] 	= 'S';
		$data_usuario['MODULO_VENDAS'] 			= 'S';
		$data_usuario['MODULO_ADMIN'] 			= 'S';
		$data_usuario['NAVEGADOR_LIVRE'] 		= 'S';
		$data_usuario['DATA_ACESSO'] 			= null;
		$data_usuario['FUNCAO'] 				= null;
		$data_usuario['CUSTO_MENSAL'] 			= null;	
		$data_usuario['COMISSAO_PRECO_BASE'] 	= null;	
		$data_usuario['COMISSAO_PRECO_MEDIO']	= null;	
		$data_usuario['COMISSAO_PRECO_TOP'] 	= null;	
		$data_usuario['COMISSAO_POR_META1'] 	= null;	
		$data_usuario['COMISSAO_POR_META2'] 	= null;	
		$data_usuario['COMISSAO_POR_META3'] 	= null;	
		$data_usuario['INICIO_SEGUNDA'] 		= null;	
		$data_usuario['FINAL_SEGUNDA'] 			= null;	
		$data_usuario['INICIO_TERCA'] 			= null;	
		$data_usuario['FINAL_TERCA'] 			= null;	
		$data_usuario['INICIO_QUARTA'] 			= null;	
		$data_usuario['FINAL_QUARTA'] 			= null;	
		$data_usuario['INICIO_QUINTA'] 			= null;	
		$data_usuario['FINAL_QUINTA'] 			= null;	
		$data_usuario['INICIO_SEXTA'] 			= null;	
		$data_usuario['FINAL_SEXTA'] 			= null;	
		$data_usuario['INICIO_SABADO'] 			= null;	
		$data_usuario['FINAL_SABADO'] 			= null;	
		$data_usuario['INICIO_DOMINGO'] 		= null;	
		$data_usuario['FINAL_DOMINGO'] 			= null;	
		$data_usuario['TOTAL_5W2H'] 			= null;	
		$data_usuario['ATRASADO_5W2H'] 			= null;	
		$data_usuario['ONTIME_5W2H'] 			= null;	
		$data_usuario['PERMITIDO_EXCEL'] 		= null;	
		$data_usuario['PERMITIDO_PDF'] 			= null;	
		$data_usuario['APROVACAO_EDI'] 			= null;	

		$table_usuario->insert($data_usuario);
		
		$dados_usuario = $table_usuario->select()->from($table_usuario, array('MAX(ID) AS ID'));
		$dados_usuario = $table_usuario->fetchAll($dados_usuario)->toArray();
		
		$id = $dados_usuario[0]['ID'];
		
		$data['CODIGO'] = $id ++;
		
		 return parent::beforeInsert($data);
    }
}
?>