<?php

class especial_Model_DbTable_Cotacaoitemforne extends Zsam_Db_Table {

	/**
	 * The default table name
	 */
    protected $_name = 'cotacao_itemforne';

    var $_autocomplet = array('ID','FORNE');

    var $_conf = array(
   	'FORNE'                 => array('edit' => 'N'),
    	'ID_ITEM' 			=> array('edit' => 'N'),
        'NUM_OPORTUNIDADE'  => array('edit' => 'N'),
    	'ID' 				=> array('edit' => 'N'),
    	'VALOR_UNIT' 		=> array(),
    	'PORC_FRETE' 		=> array(),
    	'VALOR_FRETE' 		=> array(),
    	'TIPO_FRETE' 		=> array('VP' => 'CIF,FOB,EXW'),
    	'PRAZO' 			=> array(),
    	'ALIQUOTA_ICMS' 	=> array(),
    	'ALIQUOTA_ST' 		=> array(),
    	'ALIQUOTA_IPI' 		=> array(),
    	'NCM' 				=> array('autocomplete' => 'Y'),
    	'OBS' 				=> array(),

    );

    var $_referenceMap = array(
        'NCM' => array(
            'columns' 		=> 'NCM',
            'refTableClass' 	=> 'core_Model_DbTable_Ncm',
            'refColumns' 	=> 'NCM',
            'refTitle' 		=> 'NCM'
        ),
    );

    public function __construct()
    {
      parent::__construct();

       $controller = Zend_Controller_Front::getInstance()->getRequest();
	   $nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

	   $auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
		}

		$cliente = Zend_Registry::get('Cliente');

		/*if($cliente[0]['IND_COM_SERV'] == "I")
		{
			$this->_referenceMap['FORNE']['refTableClass'] 			= "indcom_Model_DbTable_Fornecedor";
		}

		else if($cliente[0]['IND_COM_SERV'] == "C")
		{
			$this->_referenceMap['FORNE']['refTableClass'] 			= "indcom_Model_DbTable_Fornecedor";
		}

		else
		{
			$this->_referenceMap['FORNE']['refTableClass'] 			= "serv_Model_DbTable_Fornecedor";
		}*/
	}

	public function beforeInsert(array $data)
	{

		$table 		= new Cisweb_Db_Abstract('cotacaoforne');
		$datacotacao['STATUS'] = 'I';
		$num 		= $data['NUM_OPORTUNIDADE'];
		$where 		= "NUM_OPORTUNIDADE = '$num' AND STATUS = 'N'";
		$table->update($datacotacao, $where);

		return parent::beforeInsert($data);
	}

	public function beforeUpdate(array $data, $where)
	{

		$controller = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

		if($nome_controller == 'cotacaoforneitemorm')
		{

			if ($data['VALOR_UNIT'] != '')
			{

				$table 			= new Cisweb_Db_Abstract('cotacao_itemforne');
				$tableitem 		= new Cisweb_Db_Abstract('cotacaoforneitens');
				$tableorm 		= new Cisweb_Db_Abstract('cotacaoforneorm');
				$tablecotacao 	= new Cisweb_Db_Abstract('cotacaoforne');

				$rowitem    = $tableitem->fetchRow($tableitem->select()
						->where("ID = " . $where[' ID_ITEM = ? ']));

				$total = $rowitem['QUANTIDADE'] * $data['VALOR_UNIT'];

				$data['TOTAL'] = $total;

				$forne = $where[' FORNE = ? '];
				$dados = $table->getAdapter()->fetchAll($table->select()
						->where('FORNE=?', $forne)->where('ID <> ?', $data['ID']));

				$cont = true;
				$row  = count($dados);

				foreach ($dados as $key => $value)
				{
					if ($value['VALOR_UNIT'] == '' || is_null($value['VALOR_UNIT']))
					{
						$cont = false;
					}
				}

				if ($cont)
				{
					$dataorm['STATUS_ORM'] 	= 'Cotado';
				}
				else
				{
					$dataorm['STATUS_ORM'] 	= 'Parcialmente Cotado';
				}

				$tableorm->update($dataorm, "ID = '$forne'");

				/*
				 * atualiza o status da cotacao
				*/
				$num_oportunidade 		= $rowitem['ID_COTACAO'];
				$status_cotacao 		= $this->verificaStatus($num_oportunidade,$tableorm);
				$datacotacao['STATUS'] 	= $status_cotacao;
				$wherecotacao 			= "NUM_OPORTUNIDADE = '$num_oportunidade'";
				$tablecotacao->update($datacotacao, $wherecotacao);

			}
			else
			{
				$data['TOTAL'] = 0.00;
			}



		}

		return parent::beforeUpdate($data, $where);
	}

	public function verificaStatus($num,$table)
	{
		$dados = $table->fetchAll($table->select()
				->where("NUM_OPORTUNIDADE = '$num'"));

		$cont = count($dados);
		$soma = 0;

		foreach ($dados as $k => $v)
		{
			if ($v['STATUS_ORM'] == 'Cotado')
			{
				$soma ++;
			}
		}

		if ($soma == $cont)
		{
			return 'T'; //totalmente cotado
		}
		else
		{
			return 'P'; // parcialmente cotado
		}

	}

	/*public function afterUpdate($id)
	{

	}*/



}

?>