<?php
class Application_Form_Pagamento extends Zsam_Form
{
	
    public function init ()
    {
    	
        $this->setName('frmPagamento');
        $this->setMethod('post');
        
        $zsam_form_script = 'form_layout/tres_colunas.phtml';
        $this->setDecorators(array(array('ViewScript', array('viewScript' => $zsam_form_script)), 'Form'));  
        
        
        $regGq = new Zend_Form_Element_Text('REGISTROGQ');
        $regGq->setLabel(Zsam_Util::showMessage('Registro:', true, false));//.' (*)')->setRequired(true);
							
		$empresa = new Zsam_Form_Elements_Combo('EMPRESA', null, 'core_Model_DbTable_Empresa');
		$empresa->setLabel(Zsam_Util::showMessage('Empresa:', true, false));//.' (*)')->setRequired(true);	
		
		$dtDoc = new Zend_Form_Element_Text('DATA_DOCUMENTO');
        $dtDoc->setLabel(Zsam_Util::showMessage('Data do Documento:', true, false));//.' (*)')->setRequired(true);
        $dtDoc->setAttrib("zsam", "date");
        $dtDoc->setAttrib("MASK", "Y");
        $dtDoc->setAttrib("MASK_RULE", "99/99/9999");
        
        $dtRecebimento = new Zend_Form_Element_Text('DATA_RECEBIMENTO');
        $dtRecebimento->setLabel(Zsam_Util::showMessage('Data do Recebimento:', true, false));//.' (*)')->setRequired(true);
        $dtRecebimento->setAttrib("zsam", "date");
        $dtRecebimento->setAttrib("MASK", "Y");
        $dtRecebimento->setAttrib("MASK_RULE", "99/99/9999");
        
        $codforne = new Zsam_Form_Elements_Combo('CODFORNE', null, 'core_Model_DbTable_Fornecedor');
		$codforne->setLabel(Zsam_Util::showMessage('Fornecedor:', true, false));//.' (*)')->setRequired(true);	

        $descricao = new Zend_Form_Element_Text('DESCRICAO');
        $descricao->setLabel(Zsam_Util::showMessage('Descriçao:', true, false));//.' (*)')->setRequired(true);
		
		$impressao = new Zend_Form_Element_Text('IMPRESSAO');
        $impressao->setLabel(Zsam_Util::showMessage('Impressão:', true, false));//.' (*)')->setRequired(true);
        
		$cc = new Zend_Form_Element_Text('CC');
        $cc->setLabel(Zsam_Util::showMessage('Conta Corrente:', true, false));//.' (*)')->setRequired(true);
        
		$cfop = new Zsam_Form_Elements_Combo('CFOP', null, 'core_Model_DbTable_Cfop');
        $cfop->setLabel(Zsam_Util::showMessage('CFOP', true, false));//.' (*)')->setRequired(true);
				
		$numerNf = new Zend_Form_Element_Text('NUMERO_NF');
        $numerNf->setLabel(Zsam_Util::showMessage('Numero NF:', true, false));//.' (*)')->setRequired(true);
        
        $total = new Zend_Form_Element_Text('TOTAL');
        $total->setLabel(Zsam_Util::showMessage('Total:', true, false));//.' (*)')->setRequired(true);
        
		$totalIcms = new Zend_Form_Element_Text('TOTAL_ICMS');
        $totalIcms->setLabel(Zsam_Util::showMessage('Total ICMS:', true, false));//.' (*)')->setRequired(true);
        
        $totalIpi = new Zend_Form_Element_Text('TOTAL_IPI');
        $totalIpi->setLabel(Zsam_Util::showMessage('Total IPI:', true, false));//.' (*)')->setRequired(true);
        
        $resultadoFinal = new Zend_Form_Element_Text('RESULTADOFINAL');
        $resultadoFinal->setLabel(Zsam_Util::showMessage('Resultado Final:', true, false));//.' (*)')->setRequired(true);
        
        $gerencia = new Zend_Form_Element_Text('GERENCIA');
        $gerencia->setLabel(Zsam_Util::showMessage('Gerência:', true, false));//.' (*)')->setRequired(true);
        
        $debitoContabil = new Zend_Form_Element_Text('DEBITOCONTABIL');
        $debitoContabil->setLabel(Zsam_Util::showMessage('Debito Contábil:', true, false));//.' (*)')->setRequired(true);
        
        $creditoContabil = new Zend_Form_Element_Text('CREDITOCONTABIL');
        $creditoContabil->setLabel(Zsam_Util::showMessage('Crédito Contábil:', true, false));//.' (*)')->setRequired(true);
        
        $registoItem = new Zend_Form_Element_Text('REGISTROORIGEM');
        $registoItem->setLabel(Zsam_Util::showMessage('Registro de Orígem:', true, false).' (*)')->setRequired(true);
        
        $responsavel = new Zend_Form_Element_Text('RESPONSAVEL');
        $responsavel->setLabel(Zsam_Util::showMessage('Responsável:', true, false));//.' (*)')->setRequired(true);
        
        $aprovacao = new Zend_Form_Element_Text('APROVACAO');
        $aprovacao->setLabel(Zsam_Util::showMessage('Aprovação:', true, false));//.' (*)')->setRequired(true);
        
        $cliente = new Zend_Form_Element_Text('CLIENTE', null, 'core_Model_DbTable_Cliente');
		$cliente->setLabel(Zsam_Util::showMessage('Cliente:', true, false));//.' (*)')->setRequired(true);
        
		$ultimoItem = new Zend_Form_Element_Text('ULTIMO_ITEM');
		$ultimoItem->setLabel(Zsam_Util::showMessage('Ultimo Item:', true, false));//.' (*)')->setRequired(true);	
        
		$chaveAcessoDanfe = new Zend_Form_Element_Text('CHAVE_DE_ACESSO_DANFE');
		$chaveAcessoDanfe->setLabel(Zsam_Util::showMessage('Chave de Acesso DANFE:', true, false));//.' (*)')->setRequired(true);
        
		$funcAlteracao = new Zend_Form_Element_Text('FUNC_ALTERACAO');
		$funcAlteracao->setLabel(Zsam_Util::showMessage('Alteração:', true, false));//.' (*)')->setRequired(true);	
        
		$dataAlteracao = new Zend_Form_Element_Text('DATA_ALTERACAO');
		$dataAlteracao->setLabel(Zsam_Util::showMessage('Data de Alteração:', true, false));//.' (*)')->setRequired(true);							
        $dataAlteracao->setAttrib("zsam", "date");
        $dataAlteracao->setAttrib("MASK", "Y");
        $dataAlteracao->setAttrib("MASK_RULE", "99/99/9999");
        
		$revisao = new Zend_Form_Element_Text('REVISAO');
		$revisao->setLabel(Zsam_Util::showMessage('Revisão:', true, false));//.' (*)')->setRequired(true);
        
		$datasinc = new Zend_Form_Element_Text('ULTIMO_ITEM', null, 'core_Model_DbTable_Cliente');
		$datasinc->setLabel(Zsam_Util::showMessage('Ultimo Item:', true, false));//.' (*)')->setRequired(true);							
        $datasinc->setAttrib("zsam", "date");
        $datasinc->setAttrib("MASK", "Y");
        $datasinc->setAttrib("MASK_RULE", "99/99/9999");
        
		$pagItens = new Zsam_Form_Elements_ElementItemGrid('itemGrid');
        $pagItens->setLabel('Pagamentos Itens');
        

        $pagValWhere= $regGq->getValue();
        $pagItens->setAttrib('model', 'core_Model_DbTable_PagamentoItem');
        $pagItens->setAttrib('idWhere', 'REGISTROGQ');
        $pagItens->setAttrib('valueWhere', "1");
        $pagItens->setAttrib('urlEdit', "/core/pagamento-item/new/acao/upd/id/");
        $pagItens->setAttrib('urlDel', "/core/pagamento-item/new/acao/del/id/");
        $pagItens->setAttrib('columns', array('REGISTROGQ','ITEM','PRODUTO'));
        $pagItens->setAttrib('primaryKeys', array('REGISTROGQ','ITEM'));
        
        $submit = new Zend_Form_Element_Submit(Zsam_Util::showMessage('send', true, false));       

        $this->addElements(array($regGq,$empresa,$dtDoc,$dtRecebimento,$codforne,$descricao,
 								$impressao,$cfop,$numerNf,$total,$totalIcms,$totalIpi,
								$resultadoFinal,$gerencia,$debitoContabil,$creditoContabil,
								$registoItem,$responsavel,$aprovacao,$cliente,$ultimoItem,
								$chaveAcessoDanfe,$funcAlteracao,$dataAlteracao,$revisao,
								$datasinc,$pagItens,$submit));      
        
        
        $campos = $this->getElements();
        $decor = array('FormElements', array('HtmlTag', array('tag' => 'div', 'class' => 'zsam_form_group', 'id' => 'group0', 'title' => 'Dados Gerais')));
       
        $this->addDisplayGroup(array($regGq,$empresa,$dtDoc,$dtRecebimento,$codforne,$descricao,
 								$impressao,$cfop,$numerNf,$total,$totalIcms,$totalIpi,
								$resultadoFinal,$gerencia,$debitoContabil,$creditoContabil,
								$registoItem,$responsavel,$aprovacao,$cliente,$ultimoItem,
								$chaveAcessoDanfe,$funcAlteracao,$dataAlteracao,$revisao,
								$datasinc,$submit), 'group0', array('decorators' => $decor));
        
        $decor2 = array('FormElements', array('HtmlTag', array('tag' => 'div', 'class' => 'zsam_form_group', 'id' => 'group1', 'title' => 'Itens')));
        $this->addDisplayGroup(array($pagItens), 'group1', array('decorators' => $decor2));
       
        
        
    }
}