<?php

class AuthController extends Zend_Controller_Action {

    public function init() {
        /* Initialize action controller here */
        $this->view->actionName = $this->getRequest()->getActionName();
    }

    public function indexAction() {
        // action body
    }

    public function pretimeoutAction() {
        $this->_helper->layout->disableLayout();
        echo "<script>window.location='/cisweb/public/auth/timeout'</script>";
        exit;
        // action body
    }

    public function timeoutAction() {
        // action body
    }

    public function denyAction() {
        $this->_helper->layout->disableLayout();
    }

    public function loginAction() {
        $this->_helper->layout->disableLayout();
        // use in development environment only to unblock login
        unset($_COOKIE['loginBlocked']);

        $form = new Application_Form_Login();
        $cript = new Zsam_Crypt_Cisweb();
        $timeBlockLoginError = 1800; // 30 minutos
        $timeBlockLogin = 120; // 2 minutos
        $message = $this->getRequest()->getParam('msg');
        if (isset($message))
            $this->view->message = Zsam_Util::showMessage($message, true, true);

        if ($this->getRequest()->isPost()) {
            $formData = $this->getRequest()->getPost();
            if ($form->isValid($formData)) {
                $tabuser = new core_Model_DbTable_Usuario();
                $dbAdapter = $tabuser->getAdapter();
                $adapter = new Zend_Auth_Adapter_DbTable(
                                $dbAdapter,
                                'usuario',
                                'LOGIN',
                                'SENHA'
                );

                $adapter->setIdentity($cript->encode($form->getValue('txtUserName')));
                $adapter->setCredential(md5($form->getValue('txtPassword')));

                $auth = Zend_Auth::getInstance();
                $result = $auth->authenticate($adapter);

                $blockLoginError = new Zend_Session_Namespace('blockLoginError');
                $blockLoginError->setExpirationSeconds($timeBlockLogin);

                if ($result->isValid() AND !$this->getRequest()->getCookie('loginBlocked')) {
                    $config = Zend_Registry::get('Cisweb_Config');
                    $timeoutSession = $config[0]['TIMEOUT'];

                    $timeoutLogin = new Zend_Session_Namespace('Zend_Auth');
                    $timeoutLogin->timeout = time() + $timeoutSession;

                    $data = $adapter->getResultRowObject((array('ID', 'NOME', 'LOGIN', 'EMAIL', 'NIVEL', 'ACESSORESTRITO', 'M1', 'M2', 'M3', 'M4', 'M5', 'M6', 'M7', 'M8', 'M9', 'M10', 'M11', 'M12', 'DATA_ACESSO', 'NAVEGADOR_LIVRE')));
                    $data2 = array();

                    if ($data->NAVEGADOR_LIVRE != 'S') {
                        // @TODO Para usar em produção
//						$mac = $this->getRequest()->getParam('mac');
                        // @TODO Para usar em desenvolvimento
                        $mac = 'MAC01';
                        $_SERVER['HTTP_USER_AGENT'] = 'cisweb';

                        $changeBrowser = false;
                        $macDenied = false;
                        $macExist = false;

                        if (strpos($_SERVER['HTTP_USER_AGENT'], 'cisweb') === false) {
                            $changeBrowser = true;
                        } else {
                            /**
                             * Método que verifica os macs de uma tabela chamada COMPUT_INI
                             *
                             */
                            $loadComput = $dbAdapter->fetchAll(
                                    $dbAdapter->select()
                                            ->from('comput'));
                            $comput = $loadComput;
                            foreach ($comput as $k => $v) {
                                if ($mac == $comput[$k]['COMPUTERNAME']) {
                                    $macExist = true;
                                    if (isset($comput[$k]['VALIDADE_CADASTRO']) AND
                                            $comput[$k]['VALIDADE_CADASTRO'] > Zsam_Util::dateSql(Zsam_Util::dateNow())) {
                                        $macDenied = false;
                                    }
                                }
                            }

                            if (!$macExist) {
                                $bind['COMPUTERNAME'] = $mac;
                                $bind['VALIDADE_CADASTRO'] = null;
                                $bind['DATA_CADASTRO'] = Zsam_Util::datetimeSql(Zsam_Util::datetimeNow());
                                $bind['FUNC_CADASTRO'] = 1;
                                $bind['DATA_ALTERACAO'] = Zsam_Util::datetimeSql(Zsam_Util::datetimeNow());
                                $bind['FUNC_ALTERACAO'] = 1;
                                $bind['REVISAO'] = 1;
                                $bind['DATASINC'] = Zsam_Util::datetimeSql(Zsam_Util::datetimeNow());

                                $dbAdapter->insert('comput', $bind);
                            }

                            /**
                             * Método que verifica os macs de um arquivo chamado COMPUT_INI
                             *
                              $loadComput = new Zend_Config_Ini(APPLICATION_PATH . '\configs\comput.ini',
                              null,
                              array('skipExtends' => true,
                              'allowModifications' => true)
                              );
                              $loadComput instanceof Zend_Config_Ini;
                              $comput = $loadComput->toArray();

                              foreach ($comput as $k => $v) {
                              if ($mac == $comput[$k]['MAC_ADDRESS']) {
                              $macExist = true;
                              if (isset($comput[$k]['EXPIRE_DATE']) AND
                              $comput[$k]['EXPIRE_DATE'] > Zsam_Util::dateSql(Zsam_Util::dateNow())) {
                              $macDenied = false;
                              }
                              }
                              }

                              if (!$macExist) {
                              $macTitle = "MAC_ADDRESS_" . Zsam_Util::datetimeNow();
                              $dateTitle = "EXPIRE_DATE_" . Zsam_Util::datetimeNow();

                              $loadComput->MAC_UNKNOWN->$macTitle = $mac;
                              $loadComput->MAC_UNKNOWN->$dateTitle = null;
                              $writer = new Zend_Config_Writer_Ini(array('config' => $loadComput,
                              'filename' => APPLICATION_PATH . '\configs\comput.ini'));
                              $writer->write();
                              }
                             */
                        }
                        if ($changeBrowser)
                            $this->_redirect('cisweb/public/auth/logout/msg/change_browser');

                        if ($macDenied)
                            $this->_redirect('cisweb/public/auth/logout/msg/mac_denied');
                    }

                    $dbAdapter->update('usuario', array('DATA_ACESSO' => Zsam_Util::datetimeSql(Zsam_Util::datetimeNow())), array("login='$data->LOGIN'"));

                    $auth = Zend_Auth::getInstance();
                    $user = $auth->getStorage()->read();
                    
                    $tablog = new core_Model_DbTable_Log();

                    $data_log = array(
                        'USUARIO' => $data->ID,
                        'DATA_LOG' => Zsam_Util::datetimeSql(Zsam_Util::datetimeNow()),
                        'COMPUTADOR_LOG' => $this->getRequest()->getParam('mac'),                                                
                    );
                    $id_log = $tablog->insert($data_log);

                    foreach ($data as $key => $value) {
                        $data2[$key] = $value;
                    }
                    $dados = $tabuser->decrypt($data2);
                    
                    $dados['ID_LOG'] = $id_log;

                    if ($dados['ACESSORESTRITO'] == 'N')
                        $dados['PERFIL'] = 'admin';

                    $message = 'login_successful';

                    $auth->getStorage()->write($dados);
                    $this->_redirect('/');
                } else if ($this->getRequest()->getCookie('loginBlocked')) {
                    $message = 'login_blocked';
                } else {
                    if ($result->getCode() == Zend_Auth_Result::FAILURE_CREDENTIAL_INVALID) {
//						$message = 'credencial_invalid';
                        $message = 'identity_not_found';
                    } else if ($result->getCode() == Zend_Auth_Result::FAILURE_IDENTITY_NOT_FOUND) {
                        $message = 'identity_not_found';
                    }

                    $blockLoginError->numberOfAttempts++;
                    $blockLoginError->timeBlock[$blockLoginError->numberOfAttempts] = time();

                    if (($blockLoginError->numberOfAttempts >= 3) AND (($blockLoginError->timeBlock[count($blockLoginError->timeBlock)] - $blockLoginError->timeBlock[1]) <= $timeBlockLogin)) {
                        setcookie('loginBlocked', true, time() + $timeBlockLoginError);
                        unset($blockLoginError->numberOfAttempts);
                    }
                }
                $this->view->message = Zsam_Util::showMessage($message, true, true);
            }
        }
        $this->view->form = $form;
    }

    public function logoutAction() {

        $this->_helper->layout->disableLayout();
        
        $message = $this->getRequest()->getParam('msg');
        if (isset($message))
            echo $this->view->message = Zsam_Util::showMessage($message, true, true);
        else
            echo $this->view->message = Zsam_Util::showMessage('logout_successful', true, true);

        $auth = Zend_Auth::getInstance();
        $user = $auth->getStorage()->read();

        $tablog = new core_Model_DbTable_Log();
        $dados = $tablog->fetchAll(
                $tablog->select()->where('ID = '.$user['ID_LOG'])
                )->toArray();
        $hora = substr($dados[0]['DATA_LOG'], -9, -6);
        $minuto = substr($dados[0]['DATA_LOG'], -5, -3);

        $hora_atual = date('H');
        $minuto_atual = date('i');
        $h1 = $hora * 60 + $minuto;
        $h2 = $minuto_atual + $hora_atual * 60;
        $s = $h2 - $h1;

       $tablog->getAdapter()->update('log',array('DURACAO_LOG'=>$s),'ID = '.$user['ID_LOG']);
        Zend_Auth::getInstance()->clearIdentity();
    }

    public function changeAction() {
        $form = new Application_Form_Change;
        $cript = new Zsam_Crypt_Cisweb();

        if ($this->getRequest()->isPost()) {
            $formData = $this->getRequest()->getPost();
            if ($form->isValid($formData)) {
                $tabuser = new core_Model_DbTable_Usuario();
                $dbAdapter = $tabuser->getAdapter();
                $adapter = new Zend_Auth_Adapter_DbTable(
                                $dbAdapter,
                                'usuario',
                                'LOGIN',
                                'SENHA'
                );
                $adapter->setIdentity($cript->encode($form->getValue('txtUserName')));
                $adapter->setCredential(md5($form->getValue('txtPassword')));

                $auth = Zend_Auth::getInstance();
                $result = $auth->authenticate($adapter);

                if ($result->isValid() AND !$this->getRequest()->getCookie('loginBlocked')) {

                    $adapter->setIdentity($cript->encode($form->getValue('txtUserName')));
                    $adapter->setCredential(md5($form->getValue('txtPassword')));

                    $data = $adapter->getResultRowObject((array('LOGIN')));
                    $dbAdapter->update('usuario', array('SENHA' => md5($formData['txtNewPassword'])), array("login='" . $cript->encode($formData['txtUserName']) . "'"));
                    //$this->view->message = Zsam_Util::showMessage('new_pw', true, true);  
                    $this->_redirect('cisweb/public/auth/login/msg/new_pw');
                } else {
                    $this->view->message = Zsam_Util::showMessage('A senha digitada não é válida.', true, true);
                }
            }
        }

        $this->view->form = $form;
    }

    public function recoverAction() {

        $form = new Application_Form_Recover();
        $cript = new Zsam_Crypt_Cisweb();

        $config = new Zend_Config_Ini(APPLICATION_PATH . '/configs/application.ini', APPLICATION_ENV);

        function return_password() {

            $i = 0;
            $password = '';

// set password length
            $pw_length = 8;
// set ASCII range for random character generation
            $lower_ascii_bound = 50;          // "2"
            $upper_ascii_bound = 122;       // "z"
            // Exclude special characters and some confusing alphanumerics
            // o,O,0,I,1,l etc
            $notuse = array(58, 59, 60, 61, 62, 63, 64, 73, 79, 91, 92, 93, 94, 95, 96, 108, 111);

            while ($i < $pw_length) {
                mt_srand((double) microtime() * 1000000);
                // random limits within ASCII table
                $randnum = mt_rand($lower_ascii_bound, $upper_ascii_bound);
                if (!in_array($randnum, $notuse)) {
                    $password = $password . chr($randnum);
                    $i++;
                }
            }

            return $password;
        }

        if ($this->getRequest()->isPost()) {
            $formData = $this->getRequest()->getPost();
            if ($form->isValid($formData)) {

                $pw = return_password();

                $tabuser = new core_Model_DbTable_Usuario();
                $dbAdapter = $tabuser->getAdapter();

                $where = $tabuser->getAdapter()->quoteInto('LOGIN', $cript->encode($form->getValue('txtUserName')));

                $tabuser->update(array('SENHA' => $pw), $where);

                $dados = $tabuser->fetchAll($tabuser->select()->where("LOGIN = '" . $cript->encode($form->getValue('txtUserName')) . "'"))->current();
                if ($dados == null) {
                    $this->view->message = 'Usuario nao encontrado.';
                    $this->view->form = $form;
                    return;
                }
                $dados = $tabuser->decrypt($dados);
                // Carrega a classe e e-mail
                require_once 'Zend/Mail.php';

                // Cria a forma de envio
                require_once 'Zend/Mail/Transport/Smtp.php';

                $transport = new Zend_Mail_Transport_Smtp('smtp.gmail.com', $config->email->toArray());

                $msg = Zsam_Util::showMessage('new_pw_msg', true, false) . $pw;


                $mail = new Zend_Mail();
                $mail->addTo(@$dados['EMAIL'], 'Envio de nova senha');
                $mail->setFrom('teste@gelso.com', 'Test');
                $mail->setSubject('Sua nova senha no sistema');
                $mail->setBodyText($msg);
                try {
                    $mail->send($transport);
                } catch (Zend_Mail_Exception $e) {
                    echo $e->getMessage();
                }

                $this->view->message = Zsam_Util::showMessage('', true, true);
                $this->_redirect('cisweb/public/auth/login/msg/pw_recovered');
            }
        }
        $this->view->form = $form;
    }

}